/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.UUID;
import org.bouncycastle.operator.OperatorCreationException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.test.rule.TestDirectory;

public class HostnameVerificationHelper {
    public static final String POLICY_NAME = "fakePolicy";
    public static final SslPolicyConfig SSL_POLICY_CONFIG = new SslPolicyConfig("fakePolicy");
    private static final PkiUtils PKI_UTILS = new PkiUtils();

    public static Config aConfig(String hostname, TestDirectory testDirectory) throws GeneralSecurityException, IOException, OperatorCreationException {
        String random = UUID.randomUUID().toString();
        File baseDirectory = testDirectory.directory("base_directory_" + random);
        File validCertificatePath = new File(baseDirectory, "certificate.crt");
        File validPrivateKeyPath = new File(baseDirectory, "private.pem");
        File revoked = new File(baseDirectory, "revoked");
        File trusted = new File(baseDirectory, "trusted");
        trusted.mkdirs();
        revoked.mkdirs();
        PKI_UTILS.createSelfSignedCertificate(validCertificatePath, validPrivateKeyPath, hostname);
        return Config.builder().withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.base_directory, baseDirectory.toString()).withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.trusted_dir, trusted.toString()).withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.revoked_dir, revoked.toString()).withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.private_key, validPrivateKeyPath.toString()).withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.public_certificate, validCertificatePath.toString()).withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.tls_versions, "TLSv1.2").withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.ciphers, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA").withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.client_auth, "none").withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.allow_key_generation, "false").withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.trust_all, "false").withSetting(HostnameVerificationHelper.SSL_POLICY_CONFIG.verify_hostname, "true").build();
    }

    public static void trust(Config target, Config subject) throws IOException {
        SslPolicyConfig sslPolicyConfig = new SslPolicyConfig(POLICY_NAME);
        File trustedDirectory = (File)target.get(sslPolicyConfig.trusted_dir);
        File certificate = (File)subject.get(sslPolicyConfig.public_certificate);
        Path trustedCertFilePath = trustedDirectory.toPath().resolve(certificate.getName());
        Files.copy(certificate.toPath(), trustedCertFilePath, new CopyOption[0]);
    }
}

