/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.net;

import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.runtime.spi.StreamMatchers;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.junit.EnterpriseNeo4jRule;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.server.HTTP;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ConnectionTrackingIT {
    private static final String NEO4J_USER_PWD = "test";
    private static final String OTHER_USER = "otherUser";
    private static final String OTHER_USER_PWD = "test";
    @ClassRule
    public static final Neo4jRule neo4j = new EnterpriseNeo4jRule().withConfig(GraphDatabaseSettings.auth_enabled, "true").withConfig("dbms.connector.https.enabled", "true").withConfig(ServerSettings.webserver_max_threads, "50").withConfig(OnlineBackupSettings.online_backup_enabled, "false");
    private static long dummyNodeId;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Set<TransportConnection> connections = ConcurrentHashMap.newKeySet();
    private final TransportTestUtil util = new TransportTestUtil((Neo4jPack)new Neo4jPackV2());

    @BeforeClass
    public static void beforeAll() {
        ConnectionTrackingIT.changeDefaultPasswordForUserNeo4j("test");
        ConnectionTrackingIT.createNewUser(OTHER_USER, "test");
        dummyNodeId = ConnectionTrackingIT.createDummyNode();
    }

    @After
    public void afterEach() throws Exception {
        for (TransportConnection transportConnection : this.connections) {
            try {
                transportConnection.disconnect();
            }
            catch (Exception exception) {}
        }
        for (TrackedNetworkConnection trackedNetworkConnection : ConnectionTrackingIT.acceptedConnectionsFromConnectionTracker()) {
            try {
                trackedNetworkConnection.close();
            }
            catch (Exception exception) {}
        }
        this.executor.shutdownNow();
        ConnectionTrackingIT.terminateAllTransactions();
        ConnectionTrackingIT.awaitNumberOfAcceptedConnectionsToBe(0);
    }

    @Test
    public void shouldListNoConnectionsWhenIdle() throws Exception {
        ConnectionTrackingIT.verifyConnectionCount("http", null, 0);
        ConnectionTrackingIT.verifyConnectionCount("https", null, 0);
        ConnectionTrackingIT.verifyConnectionCount("bolt", null, 0);
    }

    @Test
    public void shouldListUnauthenticatedHttpConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(5, 0, 0);
    }

    @Test
    public void shouldListUnauthenticatedHttpsConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(0, 2, 0);
    }

    @Test
    public void shouldListUnauthenticatedBoltConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(0, 0, 4);
    }

    @Test
    public void shouldListUnauthenticatedConnections() throws Exception {
        this.testListingOfUnauthenticatedConnections(3, 2, 7);
    }

    @Test
    public void shouldListAuthenticatedHttpConnections() throws Exception {
        ConnectionTrackingIT.lockNodeAndExecute(dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 4; ++i) {
                this.updateNodeViaHttp(dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 3; ++i) {
                this.updateNodeViaHttp(dummyNodeId, OTHER_USER, "test");
            }
            ConnectionTrackingIT.awaitNumberOfAuthenticatedConnectionsToBe(7);
            ConnectionTrackingIT.verifyConnectionCount("http", "neo4j", 4);
            ConnectionTrackingIT.verifyConnectionCount("http", OTHER_USER, 3);
        }));
    }

    @Test
    public void shouldListAuthenticatedHttpsConnections() throws Exception {
        ConnectionTrackingIT.lockNodeAndExecute(dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 4; ++i) {
                this.updateNodeViaHttps(dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 5; ++i) {
                this.updateNodeViaHttps(dummyNodeId, OTHER_USER, "test");
            }
            ConnectionTrackingIT.awaitNumberOfAuthenticatedConnectionsToBe(9);
            ConnectionTrackingIT.verifyConnectionCount("https", "neo4j", 4);
            ConnectionTrackingIT.verifyConnectionCount("https", OTHER_USER, 5);
        }));
    }

    @Test
    public void shouldListAuthenticatedBoltConnections() throws Exception {
        ConnectionTrackingIT.lockNodeAndExecute(dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 2; ++i) {
                this.updateNodeViaBolt(dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 5; ++i) {
                this.updateNodeViaBolt(dummyNodeId, OTHER_USER, "test");
            }
            ConnectionTrackingIT.awaitNumberOfAuthenticatedConnectionsToBe(7);
            ConnectionTrackingIT.verifyConnectionCount("bolt", "neo4j", 2);
            ConnectionTrackingIT.verifyConnectionCount("bolt", OTHER_USER, 5);
        }));
    }

    @Test
    public void shouldListAuthenticatedConnections() throws Exception {
        ConnectionTrackingIT.lockNodeAndExecute(dummyNodeId, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            int i;
            for (i = 0; i < 4; ++i) {
                this.updateNodeViaBolt(dummyNodeId, OTHER_USER, "test");
            }
            for (i = 0; i < 1; ++i) {
                this.updateNodeViaHttp(dummyNodeId, "neo4j", "test");
            }
            for (i = 0; i < 5; ++i) {
                this.updateNodeViaHttps(dummyNodeId, "neo4j", "test");
            }
            ConnectionTrackingIT.awaitNumberOfAuthenticatedConnectionsToBe(10);
            ConnectionTrackingIT.verifyConnectionCount("bolt", OTHER_USER, 4);
            ConnectionTrackingIT.verifyConnectionCount("http", "neo4j", 1);
            ConnectionTrackingIT.verifyConnectionCount("https", "neo4j", 5);
        }));
    }

    @Test
    public void shouldKillHttpConnection() throws Exception {
        this.testKillingOfConnections(neo4j.httpURI(), "http", 4);
    }

    @Test
    public void shouldKillHttpsConnection() throws Exception {
        this.testKillingOfConnections(neo4j.httpsURI(), "https", 2);
    }

    @Test
    public void shouldKillBoltConnection() throws Exception {
        this.testKillingOfConnections(neo4j.boltURI(), "bolt", 3);
    }

    private void testListingOfUnauthenticatedConnections(int httpCount, int httpsCount, int boltCount) throws Exception {
        int i;
        for (i = 0; i < httpCount; ++i) {
            this.connectSocketTo(neo4j.httpURI());
        }
        for (i = 0; i < httpsCount; ++i) {
            this.connectSocketTo(neo4j.httpsURI());
        }
        for (i = 0; i < boltCount; ++i) {
            this.connectSocketTo(neo4j.boltURI());
        }
        ConnectionTrackingIT.awaitNumberOfAcceptedConnectionsToBe(httpCount + httpsCount + boltCount);
        ConnectionTrackingIT.verifyConnectionCount("http", null, httpCount);
        ConnectionTrackingIT.verifyConnectionCount("https", null, httpsCount);
        ConnectionTrackingIT.verifyConnectionCount("bolt", null, boltCount);
    }

    private void testKillingOfConnections(URI uri, String connector, int count) throws Exception {
        ArrayList<TransportConnection> socketConnections = new ArrayList<TransportConnection>();
        for (int i = 0; i < count; ++i) {
            socketConnections.add(this.connectSocketTo(uri));
        }
        ConnectionTrackingIT.awaitNumberOfAcceptedConnectionsToBe(count);
        ConnectionTrackingIT.verifyConnectionCount(connector, null, count);
        this.killAcceptedConnectionViaBolt();
        ConnectionTrackingIT.verifyConnectionCount(connector, null, 0);
        for (TransportConnection socketConnection : socketConnections) {
            ConnectionTrackingIT.assertConnectionBreaks(socketConnection);
        }
    }

    private TransportConnection connectSocketTo(URI uri) throws IOException {
        SocketConnection connection = new SocketConnection();
        this.connections.add((TransportConnection)connection);
        connection.connect(new HostnamePort(uri.getHost(), uri.getPort()));
        return connection;
    }

    private static void awaitNumberOfAuthenticatedConnectionsToBe(int n) throws InterruptedException {
        org.neo4j.test.assertion.Assert.assertEventually((String)"Unexpected number of authenticated connections", ConnectionTrackingIT::authenticatedConnectionsFromConnectionTracker, (Matcher)Matchers.hasSize((int)n), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static void awaitNumberOfAcceptedConnectionsToBe(int n) throws InterruptedException {
        org.neo4j.test.assertion.Assert.assertEventually(connections -> "Unexpected number of accepted connections: " + connections, ConnectionTrackingIT::acceptedConnectionsFromConnectionTracker, (Matcher)Matchers.hasSize((int)n), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static void verifyConnectionCount(String connector, String username, int expectedCount) throws InterruptedException {
        org.neo4j.test.assertion.Assert.assertEventually(connections -> "Unexpected number of listed connections: " + connections, () -> ConnectionTrackingIT.listMatchingConnection(connector, username), (Matcher)Matchers.hasSize((int)expectedCount), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static List<Map<String, Object>> listMatchingConnection(String connector, String username) {
        Result result = neo4j.getGraphDatabaseService().execute("CALL dbms.listConnections()");
        Assert.assertEquals(Arrays.asList("connectionId", "connectTime", "connector", "username", "serverAddress", "clientAddress"), (Object)result.columns());
        List records = result.stream().collect(Collectors.toList());
        ArrayList<Map<String, Object>> matchingRecords = new ArrayList<Map<String, Object>>();
        for (Map record : records) {
            String actualConnector = record.get("connector").toString();
            Assert.assertNotNull((Object)actualConnector);
            Object actualUsername = record.get("username");
            if (Objects.equals(connector, actualConnector) && Objects.equals(username, actualUsername)) {
                matchingRecords.add(record);
            }
            MatcherAssert.assertThat((Object)record.get("connectionId").toString(), (Matcher)Matchers.startsWith((String)actualConnector));
            OffsetDateTime connectTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)record.get("connectTime").toString(), OffsetDateTime::from);
            Assert.assertNotNull((Object)connectTime);
            MatcherAssert.assertThat(record.get("serverAddress"), (Matcher)Matchers.instanceOf(String.class));
            MatcherAssert.assertThat(record.get("clientAddress"), (Matcher)Matchers.instanceOf(String.class));
        }
        return matchingRecords;
    }

    private static List<TrackedNetworkConnection> authenticatedConnectionsFromConnectionTracker() {
        return ConnectionTrackingIT.acceptedConnectionsFromConnectionTracker().stream().filter(connection -> connection.user() != null).collect(Collectors.toList());
    }

    private static List<TrackedNetworkConnection> acceptedConnectionsFromConnectionTracker() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)neo4j.getGraphDatabaseService();
        NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)db.getDependencyResolver().resolveDependency(NetworkConnectionTracker.class);
        return connectionTracker.activeConnections();
    }

    private static void changeDefaultPasswordForUserNeo4j(String newPassword) {
        String changePasswordUri = neo4j.httpURI().resolve("user/neo4j/password").toString();
        HTTP.Response response = HTTP.withBasicAuth((String)"neo4j", (String)"neo4j").POST(changePasswordUri, HTTP.RawPayload.quotedJson((String)("{'password':'" + newPassword + "'}")));
        Assert.assertEquals((long)200L, (long)response.status());
    }

    private static void createNewUser(String username, String password) {
        String uri = ConnectionTrackingIT.txCommitUri(false);
        HTTP.Response response1 = HTTP.withBasicAuth((String)"neo4j", (String)"test").POST(uri, ConnectionTrackingIT.query("CALL dbms.security.createUser(\\\"" + username + "\\\", \\\"" + password + "\\\", false)"));
        Assert.assertEquals((long)200L, (long)response1.status());
        HTTP.Response response2 = HTTP.withBasicAuth((String)"neo4j", (String)"test").POST(uri, ConnectionTrackingIT.query("CALL dbms.security.addRoleToUser(\\\"admin\\\", \\\"" + username + "\\\")"));
        Assert.assertEquals((long)200L, (long)response2.status());
    }

    private static long createDummyNode() {
        try (Result result = neo4j.getGraphDatabaseService().execute("CREATE (n:Dummy) RETURN id(n) AS i");){
            Map record = (Map)Iterators.single((Iterator)result);
            long l = (Long)record.get("i");
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lockNodeAndExecute(long id, ThrowingAction<Exception> action) throws Exception {
        GraphDatabaseService db = neo4j.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            Node node = db.getNodeById(id);
            Lock lock = tx.acquireWriteLock((PropertyContainer)node);
            try {
                action.apply();
            }
            finally {
                lock.release();
            }
            tx.failure();
        }
    }

    private Future<HTTP.Response> updateNodeViaHttp(long id, String username, String password) {
        return this.updateNodeViaHttp(id, false, username, password);
    }

    private Future<HTTP.Response> updateNodeViaHttps(long id, String username, String password) {
        return this.updateNodeViaHttp(id, true, username, password);
    }

    private Future<HTTP.Response> updateNodeViaHttp(long id, boolean encrypted, String username, String password) {
        String uri = ConnectionTrackingIT.txCommitUri(encrypted);
        return this.executor.submit(() -> HTTP.withBasicAuth((String)username, (String)password).POST(uri, ConnectionTrackingIT.query("MATCH (n) WHERE id(n) = " + id + " SET n.prop = 42")));
    }

    private Future<Void> updateNodeViaBolt(long id, String username, String password) {
        return this.executor.submit(() -> {
            this.connectSocketTo(neo4j.boltURI()).send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{ConnectionTrackingIT.initMessage(username, password)})).send(this.util.chunk(new RequestMessage[]{new RunMessage("MATCH (n) WHERE id(n) = " + id + " SET n.prop = 42"), PullAllMessage.INSTANCE}));
            return null;
        });
    }

    private void killAcceptedConnectionViaBolt() throws Exception {
        for (TrackedNetworkConnection connection : ConnectionTrackingIT.acceptedConnectionsFromConnectionTracker()) {
            this.killConnectionViaBolt(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killConnectionViaBolt(TrackedNetworkConnection trackedConnection) throws Exception {
        String id = trackedConnection.id();
        String user = trackedConnection.user();
        TransportConnection connection = this.connectSocketTo(neo4j.boltURI());
        try {
            connection.send(this.util.defaultAcceptedVersions()).send(this.util.chunk(new RequestMessage[]{ConnectionTrackingIT.initMessage("neo4j", "test")})).send(this.util.chunk(new RequestMessage[]{new RunMessage("CALL dbms.killConnection('" + id + "')"), PullAllMessage.INSTANCE}));
            MatcherAssert.assertThat((Object)connection, (Matcher)this.util.eventuallyReceivesSelectedProtocolVersion());
            MatcherAssert.assertThat((Object)connection, (Matcher)this.util.eventuallyReceives(new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.any(Value.class), Matchers.equalTo((Object)Values.stringOrNoValue((String)user)), Matchers.equalTo((Object)Values.stringValue((String)"Connection found"))})), MessageMatchers.msgSuccess()}));
        }
        finally {
            connection.disconnect();
        }
    }

    private static void assertConnectionBreaks(TransportConnection connection) throws TimeoutException {
        Predicates.await(() -> ConnectionTrackingIT.connectionIsBroken(connection), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static boolean connectionIsBroken(TransportConnection connection) {
        try {
            connection.send(new byte[]{1});
            connection.recv(1);
            return false;
        }
        catch (SocketException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private static void terminateAllTransactions() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)neo4j.getGraphDatabaseService()).getDependencyResolver();
        KernelTransactions kernelTransactions = (KernelTransactions)dependencyResolver.resolveDependency(KernelTransactions.class);
        kernelTransactions.activeTransactions().forEach(h -> h.markForTermination((Status)Status.Transaction.Terminated));
    }

    private static String txCommitUri(boolean encrypted) {
        URI baseUri = encrypted ? neo4j.httpsURI() : neo4j.httpURI();
        return baseUri.resolve("db/data/transaction/commit").toString();
    }

    private static HTTP.RawPayload query(String statement) {
        return HTTP.RawPayload.rawPayload((String)("{\"statements\":[{\"statement\":\"" + statement + "\"}]}"));
    }

    private static InitMessage initMessage(String username, String password) {
        Map authToken = MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", username, "credentials", password});
        return new InitMessage("TestClient", authToken);
    }
}

