/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.commandline.admin.BlockerLocator;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.PageCacheWarmupTestSupport;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.db.PageCacheMetrics;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EnterpriseDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.util.concurrent.BinaryLatch;

public class PageCacheWarmupEnterpriseEditionIT
extends PageCacheWarmupTestSupport {
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final EnterpriseDatabaseRule db = new EnterpriseDatabaseRule(this.testDirectory){

        protected void configure(GraphDatabaseFactory databaseFactory) {
            super.configure(databaseFactory);
            ((TestGraphDatabaseFactory)databaseFactory).setInternalLogProvider((LogProvider)PageCacheWarmupEnterpriseEditionIT.this.logProvider);
        }
    }.startLazily();

    private static void verifyEventuallyWarmsUp(long pagesInMemory, File metricsDirectory) throws Exception {
        org.neo4j.test.assertion.Assert.assertEventually((String)"Metrics report should include page cache page faults", () -> MetricsTestHelper.readLongValue((File)MetricsTestHelper.metricsCsv((File)metricsDirectory, (String)PageCacheMetrics.PC_PAGE_FAULTS)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesInMemory)), (long)20L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void warmupMustReloadHotPagesAfterRestartAndFaultsMustBeVisibleViaMetrics() throws Exception {
        File metricsDirectory = this.testDirectory.directory("metrics");
        this.db.withSetting(MetricsSettings.metricsEnabled, "false").withSetting(OnlineBackupSettings.online_backup_enabled, "false").withSetting(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms");
        this.db.ensureStarted();
        PageCacheWarmupEnterpriseEditionIT.createTestData((GraphDatabaseService)this.db);
        long pagesInMemory = PageCacheWarmupEnterpriseEditionIT.waitForCacheProfile(this.db.getMonitors());
        this.db.restartDatabase(new String[]{MetricsSettings.neoPageCacheEnabled.name(), "true", MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "100ms", MetricsSettings.csvPath.name(), metricsDirectory.getAbsolutePath()});
        PageCacheWarmupEnterpriseEditionIT.verifyEventuallyWarmsUp(pagesInMemory, metricsDirectory);
    }

    @Test
    public void cacheProfilesMustBeIncludedInOnlineBackups() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        this.db.withSetting(MetricsSettings.metricsEnabled, "false").withSetting(UdcSettings.udc_enabled, "false").withSetting(OnlineBackupSettings.online_backup_enabled, "true").withSetting(OnlineBackupSettings.online_backup_server, "localhost:" + backupPort).withSetting(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms");
        this.db.ensureStarted();
        PageCacheWarmupEnterpriseEditionIT.createTestData((GraphDatabaseService)this.db);
        long pagesInMemory = PageCacheWarmupEnterpriseEditionIT.waitForCacheProfile(this.db.getMonitors());
        BinaryLatch latch = PageCacheWarmupEnterpriseEditionIT.pauseProfile(this.db.getMonitors());
        File metricsDirectory = this.testDirectory.cleanDirectory("metrics");
        File backupDir = this.testDirectory.cleanDirectory("backup");
        Assert.assertTrue((boolean)OnlineBackup.from((String)"localhost", (int)backupPort).backup(backupDir).isConsistent());
        latch.release();
        DatabaseRule.RestartAction useBackupDir = (fs, storeDir) -> {
            fs.deleteRecursively(storeDir.databaseDirectory());
            fs.copyRecursively(backupDir, storeDir.databaseDirectory());
        };
        this.db.restartDatabase(useBackupDir, new String[]{OnlineBackupSettings.online_backup_enabled.name(), "false", MetricsSettings.neoPageCacheEnabled.name(), "true", MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "100ms", MetricsSettings.csvPath.name(), metricsDirectory.getAbsolutePath()});
        PageCacheWarmupEnterpriseEditionIT.verifyEventuallyWarmsUp(pagesInMemory, metricsDirectory);
    }

    @Test
    public void cacheProfilesMustNotInterfereWithOnlineBackups() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        this.db.withSetting(MetricsSettings.metricsEnabled, "false").withSetting(OnlineBackupSettings.online_backup_enabled, "true").withSetting(OnlineBackupSettings.online_backup_server, "localhost:" + backupPort).withSetting(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "1ms");
        this.db.ensureStarted();
        PageCacheWarmupEnterpriseEditionIT.createTestData((GraphDatabaseService)this.db);
        PageCacheWarmupEnterpriseEditionIT.waitForCacheProfile(this.db.getMonitors());
        for (int i = 0; i < 20; ++i) {
            String backupDir = this.testDirectory.cleanDirectory("backup").getAbsolutePath();
            Assert.assertTrue((boolean)OnlineBackup.from((String)"localhost", (int)backupPort).full(backupDir).isConsistent());
        }
    }

    @Test
    public void cacheProfilesMustBeIncludedInOfflineBackups() throws Exception {
        this.db.withSetting(MetricsSettings.metricsEnabled, "false").withSetting(OnlineBackupSettings.online_backup_enabled, "false").withSetting(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms");
        this.db.ensureStarted();
        PageCacheWarmupEnterpriseEditionIT.createTestData((GraphDatabaseService)this.db);
        long pagesInMemory = PageCacheWarmupEnterpriseEditionIT.waitForCacheProfile(this.db.getMonitors());
        this.db.shutdownAndKeepStore();
        AdminTool adminTool = new AdminTool(CommandLocator.fromServiceLocator(), BlockerLocator.fromServiceLocator(), (OutsideWorld)new RealOutsideWorld(){

            public void exit(int status) {
                Assert.assertThat((String)"exit code", (Object)status, (Matcher)Matchers.is((Object)0));
            }
        }, true);
        File databaseDir = this.db.databaseLayout().databaseDirectory();
        File data = this.testDirectory.cleanDirectory("data");
        File databases = new File(data, "databases");
        File graphdb = this.testDirectory.databaseDir(databases);
        FileUtils.copyRecursively((File)databaseDir, (File)graphdb);
        FileUtils.deleteRecursively((File)databaseDir);
        Path homePath = data.toPath().getParent();
        File dumpDir = this.testDirectory.cleanDirectory("dump-dir");
        adminTool.execute(homePath, homePath, new String[]{"dump", "--database=graph.db", "--to=" + dumpDir});
        FileUtils.deleteRecursively((File)graphdb);
        File dumpFile = new File(dumpDir, "graph.db.dump");
        adminTool.execute(homePath, homePath, new String[]{"load", "--database=graph.db", "--from=" + dumpFile});
        FileUtils.copyRecursively((File)graphdb, (File)databaseDir);
        FileUtils.deleteRecursively((File)graphdb);
        File metricsDirectory = this.testDirectory.cleanDirectory("metrics");
        this.db.withSetting(MetricsSettings.neoPageCacheEnabled, "true").withSetting(MetricsSettings.csvEnabled, "true").withSetting(MetricsSettings.csvInterval, "100ms").withSetting(MetricsSettings.csvPath, metricsDirectory.getAbsolutePath());
        this.db.ensureStarted();
        PageCacheWarmupEnterpriseEditionIT.verifyEventuallyWarmsUp(pagesInMemory, metricsDirectory);
    }

    @Test
    public void logPageCacheWarmupStartCompletionMessages() throws Exception {
        File metricsDirectory = this.testDirectory.directory("metrics");
        this.db.withSetting(MetricsSettings.metricsEnabled, "false").withSetting(OnlineBackupSettings.online_backup_enabled, "false").withSetting(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms");
        this.db.ensureStarted();
        PageCacheWarmupEnterpriseEditionIT.createTestData((GraphDatabaseService)this.db);
        long pagesInMemory = PageCacheWarmupEnterpriseEditionIT.waitForCacheProfile(this.db.getMonitors());
        this.db.restartDatabase(new String[]{MetricsSettings.neoPageCacheEnabled.name(), "true", MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "100ms", MetricsSettings.csvPath.name(), metricsDirectory.getAbsolutePath()});
        PageCacheWarmupEnterpriseEditionIT.verifyEventuallyWarmsUp(pagesInMemory, metricsDirectory);
        this.logProvider.assertContainsMessageContaining("Page cache warmup started.");
        this.logProvider.assertContainsMessageContaining("Page cache warmup completed. %d pages loaded. Duration: %s.");
    }
}

