/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.rule.TestDirectory;

public class BookmarkIT {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory(this.getClass());
    private Driver driver;
    private GraphDatabaseAPI db;

    @After
    public void tearDown() throws Exception {
        IOUtils.closeAllSilently((AutoCloseable[])new Driver[]{this.driver});
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void shouldReturnUpToDateBookmarkWhenSomeTransactionIsCommitting() throws Exception {
        CommitBlocker commitBlocker = new CommitBlocker();
        this.db = this.createDb(commitBlocker);
        this.driver = GraphDatabase.driver((String)BookmarkIT.boltAddress(this.db));
        String firstBookmark = BookmarkIT.createNode(this.driver);
        commitBlocker.blockNextTransaction();
        CompletableFuture<String> secondBookmarkFuture = CompletableFuture.supplyAsync(() -> BookmarkIT.createNode(this.driver));
        org.neo4j.test.assertion.Assert.assertEventually((String)"Transaction did not block as expected", commitBlocker::hasBlockedTransaction, (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Set otherBookmarks = Stream.generate(() -> BookmarkIT.createNode(this.driver)).limit(10L).collect(Collectors.toSet());
        commitBlocker.unblock();
        String lastBookmark = secondBookmarkFuture.get();
        Assert.assertNotNull((Object)firstBookmark);
        Assert.assertNotNull((Object)lastBookmark);
        Assert.assertNotEquals((Object)firstBookmark, (Object)lastBookmark);
        MatcherAssert.assertThat(otherBookmarks, (Matcher)Matchers.hasSize((int)10));
    }

    private GraphDatabaseAPI createDb(CommitBlocker commitBlocker) {
        return this.createDb((PlatformModule platformModule) -> new CustomCommunityEditionModule((PlatformModule)platformModule, commitBlocker));
    }

    private GraphDatabaseAPI createDb(Function<PlatformModule, AbstractEditionModule> editionModuleFactory) {
        GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
        GraphDatabaseFacadeFactory facadeFactory = new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, editionModuleFactory);
        return facadeFactory.newFacade(this.directory.databaseDir(), BookmarkIT.configWithBoltEnabled(), state.databaseDependencies());
    }

    private static String createNode(Driver driver) {
        try (Session session = driver.session();){
            try (Transaction tx = session.beginTransaction();){
                tx.run("CREATE ()");
                tx.success();
            }
            String string = session.lastBookmark();
            return string;
        }
    }

    private static Config configWithBoltEnabled() {
        Config config = Config.defaults();
        config.augment("dbms.connector.bolt.enabled", "true");
        config.augment("dbms.connector.bolt.listen_address", "localhost:0");
        return config;
    }

    private static String boltAddress(GraphDatabaseAPI db) {
        ConnectorPortRegister portRegister = (ConnectorPortRegister)db.getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return "bolt://" + portRegister.getLocalAddress("bolt");
    }

    private static class CommitBlocker {
        final ReentrantLock lock = new ReentrantLock();
        volatile boolean shouldBlock;

        private CommitBlocker() {
        }

        void blockNextTransaction() {
            this.shouldBlock = true;
            this.lock.lock();
        }

        void blockWhileWritingToStoreIfNeeded() {
            if (this.shouldBlock) {
                this.shouldBlock = false;
                this.lock.lock();
            }
        }

        void unblock() {
            this.lock.unlock();
        }

        boolean hasBlockedTransaction() {
            return this.lock.getQueueLength() == 1;
        }
    }

    private static class CustomCommitProcess
    extends TransactionRepresentationCommitProcess {
        final CommitBlocker commitBlocker;

        CustomCommitProcess(TransactionAppender appender, StorageEngine storageEngine, CommitBlocker commitBlocker) {
            super(appender, storageEngine);
            this.commitBlocker = commitBlocker;
        }

        protected void applyToStore(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
            this.commitBlocker.blockWhileWritingToStoreIfNeeded();
            super.applyToStore(batch, commitEvent, mode);
        }
    }

    private static class CustomCommitProcessFactory
    implements CommitProcessFactory {
        final CommitBlocker commitBlocker;

        private CustomCommitProcessFactory(CommitBlocker commitBlocker) {
            this.commitBlocker = commitBlocker;
        }

        public TransactionCommitProcess create(TransactionAppender appender, StorageEngine storageEngine, Config config) {
            return new CustomCommitProcess(appender, storageEngine, this.commitBlocker);
        }
    }

    private static class CustomCommunityEditionModule
    extends CommunityEditionModule {
        CustomCommunityEditionModule(PlatformModule platformModule, CommitBlocker commitBlocker) {
            super(platformModule);
            this.commitProcessFactory = new CustomCommitProcessFactory(commitBlocker);
        }
    }
}

