/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class PropertyExistenceIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deletedNodesNotCheckedByExistenceConstraints() {
        GraphDatabaseService database = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.directory());
        try {
            try (Transaction transaction = database.beginTx();){
                database.execute("CREATE CONSTRAINT ON (book:Book) ASSERT exists(book.isbn)");
                transaction.success();
            }
            transaction = database.beginTx();
            var3_3 = null;
            try {
                database.execute("CREATE (:label1 {name: \"Pelle\"})<-[:T1]-(:label2 {name: \"Elin\"})-[:T2]->(:label3)");
                transaction.success();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var3_3 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
            transaction = database.beginTx();
            var3_3 = null;
            try {
                database.execute("MATCH (n:label1 {name: \"Pelle\"})<-[r:T1]-(:label2 {name: \"Elin\"})-[:T2]->(:label3) DELETE r,n");
                transaction.success();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var3_3 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        finally {
            database.shutdown();
        }
    }
}

