/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.ssl.SecureClient;
import org.neo4j.ssl.SecureServer;
import org.neo4j.ssl.SslContextFactory;
import org.neo4j.ssl.SslResource;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class SslTrustTest {
    private static final int UNRELATED_ID = 5;
    private static final byte[] REQUEST = new byte[]{1, 2, 3, 4};
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private SecureServer server;
    private SecureClient client;
    private ByteBuf expected;

    @After
    public void cleanup() {
        if (this.expected != null) {
            this.expected.release();
        }
        if (this.client != null) {
            this.client.disconnect();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void partiesWithMutualTrustShouldCommunicate() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(1).install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("client"));
        this.server = new SecureServer(SslContextFactory.makeSslPolicy(sslServerResource));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslPolicy(sslClientResource));
        this.client.connect(this.server.port());
        ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(REQUEST);
        this.client.channel().writeAndFlush((Object)request);
        this.expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(SecureServer.RESPONSE);
        this.client.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
        this.client.assertResponse(this.expected);
    }

    @Test
    public void partiesWithMutualTrustThroughCAShouldCommunicate() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.caSignedKeyId((int)0).trustSignedByCA().install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.caSignedKeyId((int)1).trustSignedByCA().install(this.testDir.directory("client"));
        this.server = new SecureServer(SslContextFactory.makeSslPolicy(sslServerResource));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslPolicy(sslClientResource));
        this.client.connect(this.server.port());
        ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(REQUEST);
        this.client.channel().writeAndFlush((Object)request);
        this.expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(SecureServer.RESPONSE);
        this.client.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
        this.client.assertResponse(this.expected);
    }

    @Test
    public void serverShouldNotCommunicateWithUntrustedClient() throws Exception {
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("client"));
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(5).install(this.testDir.directory("server"));
        this.server = new SecureServer(SslContextFactory.makeSslPolicy(sslServerResource));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslPolicy(sslClientResource));
        this.client.connect(this.server.port());
        try {
            this.client.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }

    @Test
    public void clientShouldNotCommunicateWithUntrustedServer() throws Exception {
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(5).install(this.testDir.directory("client"));
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("server"));
        this.server = new SecureServer(SslContextFactory.makeSslPolicy(sslServerResource));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslPolicy(sslClientResource));
        this.client.connect(this.server.port());
        try {
            this.client.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }

    @Test
    public void partiesWithMutualTrustThroughCAShouldNotCommunicateWhenServerRevoked() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.caSignedKeyId((int)0).trustSignedByCA().install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.caSignedKeyId((int)1).trustSignedByCA().revoke(0).install(this.testDir.directory("client"));
        this.server = new SecureServer(SslContextFactory.makeSslPolicy(sslServerResource));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslPolicy(sslClientResource));
        this.client.connect(this.server.port());
        try {
            this.client.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Server should have been revoked");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }

    @Test
    public void partiesWithMutualTrustThroughCAShouldNotCommunicateWhenClientRevoked() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.caSignedKeyId((int)0).trustSignedByCA().revoke(1).install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.caSignedKeyId((int)1).trustSignedByCA().install(this.testDir.directory("client"));
        this.server = new SecureServer(SslContextFactory.makeSslPolicy(sslServerResource));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslPolicy(sslClientResource));
        this.client.connect(this.server.port());
        try {
            this.client.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Client should have been revoked");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }
}

