/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.operator.OperatorCreationException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.ssl.SecureClient;
import org.neo4j.ssl.SecureServer;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.test.rule.TestDirectory;

public class SslPolicyLoaderIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private static final PkiUtils PKI_UTILS = new PkiUtils();
    private static final LogProvider LOG_PROVIDER = FormattedLogProvider.withDefaultLogLevel((Level)Level.DEBUG).toOutputStream((OutputStream)System.out);
    private static final String POLICY_NAME = "fakePolicy";
    private static final SslPolicyConfig SSL_POLICY_CONFIG = new SslPolicyConfig("fakePolicy");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void certificatesWithInvalidCommonNameAreRejected() throws GeneralSecurityException, IOException, OperatorCreationException, InterruptedException {
        Config serverConfig = this.aConfig("invalid-not-localhost");
        Config clientConfig = this.aConfig("localhost");
        this.trust(serverConfig, clientConfig);
        this.trust(clientConfig, serverConfig);
        SslPolicy serverPolicy = SslPolicyLoader.create((Config)serverConfig, (LogProvider)LOG_PROVIDER).getPolicy(POLICY_NAME);
        SslPolicy clientPolicy = SslPolicyLoader.create((Config)clientConfig, (LogProvider)LOG_PROVIDER).getPolicy(POLICY_NAME);
        SecureServer secureServer = new SecureServer(serverPolicy);
        secureServer.start();
        int port = secureServer.port();
        SecureClient secureClient = new SecureClient(clientPolicy);
        try {
            secureClient.connect(port);
            secureClient.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            String expectedMessage = "No subject alternative DNS name matching localhost found.";
            Assert.assertThat(this.causes(e).map(Throwable::getMessage).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Object)expectedMessage));
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        finally {
            secureServer.stop();
        }
    }

    @Test
    public void normalBehaviourIfServerCertificateMatchesClientExpectation() throws GeneralSecurityException, IOException, OperatorCreationException, InterruptedException, TimeoutException, ExecutionException {
        Config serverConfig = this.aConfig("localhost");
        Config clientConfig = this.aConfig("invalid-localhost");
        this.trust(serverConfig, clientConfig);
        this.trust(clientConfig, serverConfig);
        SslPolicy serverPolicy = SslPolicyLoader.create((Config)serverConfig, (LogProvider)LOG_PROVIDER).getPolicy(POLICY_NAME);
        SslPolicy clientPolicy = SslPolicyLoader.create((Config)clientConfig, (LogProvider)LOG_PROVIDER).getPolicy(POLICY_NAME);
        SecureServer secureServer = new SecureServer(serverPolicy);
        secureServer.start();
        SecureClient secureClient = new SecureClient(clientPolicy);
        this.clientCanCommunicateWithServer(secureClient, secureServer);
    }

    @Test
    public void legacyPolicyDoesNotHaveHostnameVerification() throws GeneralSecurityException, IOException, OperatorCreationException, InterruptedException, TimeoutException, ExecutionException {
        Config serverConfig = this.aConfig("invalid-localhost");
        Config clientConfig = this.aConfig("invalid-localhost");
        this.trust(serverConfig, clientConfig);
        this.trust(clientConfig, serverConfig);
        SslPolicy serverPolicy = SslPolicyLoader.create((Config)serverConfig, (LogProvider)LOG_PROVIDER).getPolicy("legacy");
        SslPolicy clientPolicy = SslPolicyLoader.create((Config)clientConfig, (LogProvider)LOG_PROVIDER).getPolicy("legacy");
        SecureServer secureServer = new SecureServer(serverPolicy);
        secureServer.start();
        SecureClient secureClient = new SecureClient(clientPolicy);
        this.clientCanCommunicateWithServer(secureClient, secureServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientCanCommunicateWithServer(SecureClient secureClient, SecureServer secureServer) throws InterruptedException, TimeoutException, ExecutionException {
        int port = secureServer.port();
        try {
            secureClient.connect(port);
            ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(new byte[]{1, 2, 3, 4});
            secureClient.channel().writeAndFlush((Object)request);
            ByteBuf expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(SecureServer.RESPONSE);
            Assert.assertTrue((boolean)secureClient.sslHandshakeFuture().get(1L, TimeUnit.MINUTES).isActive());
            secureClient.assertResponse(expected);
        }
        finally {
            secureServer.stop();
        }
    }

    private Config aConfig(String hostname) throws GeneralSecurityException, IOException, OperatorCreationException {
        String random = UUID.randomUUID().toString();
        File baseDirectory = this.testDirectory.directory("base_directory_" + random);
        File validCertificatePath = new File(baseDirectory, "certificate.crt");
        File validPrivateKeyPath = new File(baseDirectory, "private.pem");
        File revoked = new File(baseDirectory, "revoked");
        File trusted = new File(baseDirectory, "trusted");
        trusted.mkdirs();
        revoked.mkdirs();
        PKI_UTILS.createSelfSignedCertificate(validCertificatePath, validPrivateKeyPath, hostname);
        return Config.builder().withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.base_directory, baseDirectory.toString()).withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.trusted_dir, trusted.toString()).withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.revoked_dir, revoked.toString()).withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.private_key, validPrivateKeyPath.toString()).withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.public_certificate, validCertificatePath.toString()).withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.tls_versions, "TLSv1.2").withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.ciphers, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA").withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.client_auth, "none").withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.allow_key_generation, "false").withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.trust_all, "false").withSetting(SslPolicyLoaderIT.SSL_POLICY_CONFIG.verify_hostname, "true").build();
    }

    private void trust(Config target, Config subject) throws IOException {
        SslPolicyConfig sslPolicyConfig = new SslPolicyConfig(POLICY_NAME);
        File trustedDirectory = (File)target.get(sslPolicyConfig.trusted_dir);
        File certificate = (File)subject.get(sslPolicyConfig.public_certificate);
        Path trustedCertFilePath = trustedDirectory.toPath().resolve(certificate.getName());
        Files.copy(certificate.toPath(), trustedCertFilePath, new CopyOption[0]);
    }

    private Stream<Throwable> causes(Throwable throwable) {
        Stream<Throwable> thisStream = Stream.of(throwable).filter(Objects::nonNull);
        if (throwable != null && throwable.getCause() != null) {
            return Stream.concat(thisStream, this.causes(throwable.getCause()));
        }
        return thisStream;
    }
}

