/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.neo4j.ssl.OnConnectSslHandler;
import org.neo4j.ssl.SslHandlerDetailsRegisteredEvent;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.test.assertion.Assert;

public class SecureClient {
    private Bootstrap bootstrap;
    private ClientInitializer clientInitializer;
    private NioEventLoopGroup eventLoopGroup;
    private Channel channel;
    private Bucket bucket = new Bucket();
    private String protocol;
    private String ciphers;
    private SslHandshakeCompletionEvent handshakeEvent;
    private CompletableFuture<Channel> handshakeFuture = new CompletableFuture();

    public SecureClient(SslPolicy sslPolicy) throws SSLException {
        this.eventLoopGroup = new NioEventLoopGroup();
        this.clientInitializer = new ClientInitializer(sslPolicy, this.bucket);
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.clientInitializer);
    }

    public Future<Channel> sslHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void connect(int port) {
        ChannelFuture channelFuture = this.bootstrap.connect("localhost", port).awaitUninterruptibly();
        this.channel = channelFuture.channel();
        if (!channelFuture.isSuccess()) {
            throw new RuntimeException("Failed to connect", channelFuture.cause());
        }
    }

    void disconnect() {
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
            this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
        this.bucket.collectedData.release();
    }

    void assertResponse(ByteBuf expected) throws InterruptedException {
        Assert.assertEventually((String)this.channel.toString(), () -> this.bucket.collectedData, (Matcher)Matchers.equalTo((Object)expected), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    Channel channel() {
        return this.channel;
    }

    String ciphers() {
        if (this.ciphers == null) {
            throw new IllegalStateException("Handshake must have been completed");
        }
        return this.ciphers;
    }

    String protocol() {
        if (this.protocol == null) {
            throw new IllegalStateException("Handshake must have been completed");
        }
        return this.protocol;
    }

    public class ClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private SslContext sslContext;
        private final Bucket bucket;
        private final SslPolicy sslPolicy;

        ClientInitializer(SslPolicy sslPolicy, Bucket bucket) throws SSLException {
            this.sslContext = sslPolicy.nettyClientContext();
            this.bucket = bucket;
            this.sslPolicy = sslPolicy;
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            OnConnectSslHandler onConnectSslHandler = (OnConnectSslHandler)this.sslPolicy.nettyClientHandler((Channel)channel, this.sslContext);
            pipeline.addLast(new ChannelHandler[]{onConnectSslHandler});
            pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof SslHandlerDetailsRegisteredEvent) {
                        SslHandlerDetailsRegisteredEvent sslHandlerDetailsRegisteredEvent = (SslHandlerDetailsRegisteredEvent)evt;
                        SecureClient.this.protocol = sslHandlerDetailsRegisteredEvent.protocol;
                        SecureClient.this.ciphers = sslHandlerDetailsRegisteredEvent.cipherSuite;
                        SecureClient.this.handshakeFuture.complete(ctx.channel());
                        return;
                    }
                    if (evt instanceof SslHandshakeCompletionEvent) {
                        SecureClient.this.handshakeEvent = (SslHandshakeCompletionEvent)evt;
                        if (SecureClient.this.handshakeEvent.cause() != null) {
                            SecureClient.this.handshakeFuture.completeExceptionally(SecureClient.this.handshakeEvent.cause());
                        }
                    }
                }
            }});
            pipeline.addLast(new ChannelHandler[]{this.bucket});
        }
    }

    static class Bucket
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final ByteBuf collectedData = ByteBufAllocator.DEFAULT.buffer();

        Bucket() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.collectedData.writeBytes(msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        }
    }
}

