/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure;

import java.io.IOException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.proc.JarBuilder;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.test.TestGraphDatabaseFactory;

public class EagerProcedureIT {
    @Rule
    public TemporaryFolder plugins = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private GraphDatabaseService db;

    @Test
    public void shouldNotGetPropertyAccessFailureWhenStreamingToAnEagerDestructiveProcedure() {
        this.setUpTestData();
        Result res = this.db.execute("MATCH (n) WHERE n.key = 'value' WITH n CALL org.neo4j.procedure.deleteNeighboursEagerized(n, 'FOLLOWS') YIELD value RETURN value");
        MatcherAssert.assertThat((String)"Should get as many rows as original nodes", (Object)res.resultAsString(), (Matcher)Matchers.containsString((String)"2 rows"));
    }

    @Test
    public void shouldGetPropertyAccessFailureWhenStreamingToANonEagerDestructiveProcedure() {
        this.setUpTestData();
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Node with id 1 has been deleted in this transaction");
        Result res = this.db.execute("MATCH (n) WHERE n.key = 'value' WITH n CALL org.neo4j.procedure.deleteNeighboursNotEagerized(n, 'FOLLOWS') YIELD value RETURN value");
        res.resultAsString();
    }

    @Test
    public void shouldNotGetErrorBecauseOfNormalEagerizationWhenStreamingFromANormalReadProcedureToDestructiveCypher() {
        int count = 10;
        this.setUpTestData(count);
        Result res = this.db.execute("MATCH (n) WHERE n.key = 'value' CALL org.neo4j.procedure.findNeighboursNotEagerized(n) YIELD relationship AS r, node as m DELETE r, m RETURN true");
        MatcherAssert.assertThat((String)"Should get one fewer rows than original nodes", (Object)res.resultAsString(), (Matcher)Matchers.containsString((String)(count - 1 + " rows")));
        MatcherAssert.assertThat((String)"The plan description should contain the 'Eager' operation", (Object)res.getExecutionPlanDescription().toString(), (Matcher)Matchers.containsString((String)"+Eager"));
    }

    @Test
    public void shouldGetEagerPlanForAnEagerProcedure() {
        Result res = this.db.execute("EXPLAIN MATCH (n) WHERE n.key = 'value' WITH n CALL org.neo4j.procedure.deleteNeighboursEagerized(n, 'FOLLOWS') YIELD value RETURN value");
        MatcherAssert.assertThat((String)"The plan description should contain the 'Eager' operation", (Object)res.getExecutionPlanDescription().toString(), (Matcher)Matchers.containsString((String)"+Eager"));
    }

    @Test
    public void shouldNotGetEagerPlanForANonEagerProcedure() {
        Result res = this.db.execute("EXPLAIN MATCH (n) WHERE n.key = 'value' WITH n CALL org.neo4j.procedure.deleteNeighboursNotEagerized(n, 'FOLLOWS') YIELD value RETURN value");
        MatcherAssert.assertThat((String)"The plan description shouldn't contain the 'Eager' operation", (Object)res.getExecutionPlanDescription().toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"+Eager")));
    }

    private void setUpTestData() {
        this.setUpTestData(2);
    }

    private void setUpTestData(int nodes) {
        try (Transaction tx = this.db.beginTx();){
            this.createChainOfNodesWithLabelAndProperty(nodes, "FOLLOWS", "User", "key", "value");
            tx.success();
        }
    }

    private void createChainOfNodesWithLabelAndProperty(int length, String relationshipName, String labelName, String property, String value) {
        RelationshipType relationshipType = RelationshipType.withName((String)relationshipName);
        Label label = Label.label((String)labelName);
        Node prev = null;
        for (int i = 0; i < length; ++i) {
            Node node = this.db.createNode(new Label[]{label});
            node.setProperty(property, (Object)value);
            if (!property.equals("name")) {
                node.setProperty("name", (Object)(labelName + " " + i));
            }
            if (prev != null) {
                prev.createRelationshipTo(node, relationshipType);
            }
            prev = node;
        }
    }

    @Before
    public void setUp() throws IOException {
        new JarBuilder().createJarFor(this.plugins.newFile("myProcedures.jar"), new Class[]{ClassWithProcedures.class});
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.plugin_dir, this.plugins.getRoot().getAbsolutePath()).newGraphDatabase();
    }

    @After
    public void tearDown() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    public static class ClassWithProcedures {
        @Context
        public GraphDatabaseService db;

        @Procedure(mode=Mode.READ)
        public Stream<NeighbourOutput> findNeighboursNotEagerized(@Name(value="node") Node node) {
            return this.findNeighbours(node);
        }

        private Stream<NeighbourOutput> findNeighbours(Node node) {
            return StreamSupport.stream(node.getRelationships(Direction.OUTGOING).spliterator(), false).map(relationship -> new NeighbourOutput((Relationship)relationship, relationship.getOtherNode(node)));
        }

        @Procedure(mode=Mode.WRITE, eager=true)
        public Stream<Output> deleteNeighboursEagerized(@Name(value="node") Node node, @Name(value="relation") String relation) {
            return Stream.of(new Output(this.deleteNeighbours(node, RelationshipType.withName((String)relation))));
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<Output> deleteNeighboursNotEagerized(@Name(value="node") Node node, @Name(value="relation") String relation) {
            return Stream.of(new Output(this.deleteNeighbours(node, RelationshipType.withName((String)relation))));
        }

        private long deleteNeighbours(Node node, RelationshipType relType) {
            try {
                long deleted = 0L;
                for (Relationship rel : node.getRelationships()) {
                    Node other = rel.getOtherNode(node);
                    rel.delete();
                    other.delete();
                    ++deleted;
                }
                return deleted;
            }
            catch (NotFoundException e) {
                return 0L;
            }
        }
    }

    public static class NeighbourOutput {
        public final Relationship relationship;
        public final Node node;

        public NeighbourOutput(Relationship relationship, Node node) {
            this.relationship = relationship;
            this.node = node;
        }
    }

    public static class Output {
        public final long value;

        public Output(long value) {
            this.value = value;
        }
    }
}

