/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmerMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.util.concurrent.BinaryLatch;

class PageCacheWarmupTestSupport {
    PageCacheWarmupTestSupport() {
    }

    static void createTestData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Label label = Label.label((String)"Label");
            RelationshipType relationshipType = RelationshipType.withName((String)"REL");
            long[] largeValue = new long[1024];
            for (int i = 0; i < 1000; ++i) {
                Node node = db.createNode(new Label[]{label});
                node.setProperty("Niels", (Object)"Borh");
                node.setProperty("Albert", (Object)largeValue);
                for (int j = 0; j < 30; ++j) {
                    Relationship rel = node.createRelationshipTo(node, relationshipType);
                    rel.setProperty("Max", (Object)"Planck");
                }
            }
            tx.success();
        }
    }

    static long waitForCacheProfile(Monitors monitors) {
        AtomicLong pageCount = new AtomicLong();
        BinaryLatch profileLatch = new BinaryLatch();
        AwaitProfileMonitor listener = new AwaitProfileMonitor(pageCount, profileLatch);
        monitors.addMonitorListener((Object)listener, new String[0]);
        profileLatch.await();
        monitors.removeMonitorListener((Object)listener);
        return pageCount.get();
    }

    static BinaryLatch pauseProfile(Monitors monitors) {
        return new PauseProfileMonitor(monitors);
    }

    private static class PauseProfileMonitor
    extends BinaryLatch
    implements PageCacheWarmerMonitor {
        private final Monitors monitors;

        PauseProfileMonitor(Monitors monitors) {
            this.monitors = monitors;
            monitors.addMonitorListener((Object)this, new String[0]);
        }

        public void warmupCompleted(long pagesLoaded) {
        }

        public void profileCompleted(long pagesInMemory) {
            this.await();
            this.monitors.removeMonitorListener((Object)this);
        }
    }

    private static class AwaitProfileMonitor
    implements PageCacheWarmerMonitor {
        private final AtomicLong pageCount;
        private final BinaryLatch profileLatch;

        AwaitProfileMonitor(AtomicLong pageCount, BinaryLatch profileLatch) {
            this.pageCount = pageCount;
            this.profileLatch = profileLatch;
        }

        public void warmupCompleted(long pagesLoaded) {
        }

        public void profileCompleted(long pagesInMemory) {
            this.pageCount.set(pagesInMemory);
            this.profileLatch.release();
        }
    }
}

