/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.PageCacheWarmupTestSupport;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmerMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.util.concurrent.BinaryLatch;

public class PageCacheWarmupCcIT
extends PageCacheWarmupTestSupport {
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withNumberOfReadReplicas(0).withSharedCoreParam(UdcSettings.udc_enabled, "false").withSharedCoreParam(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms").withSharedCoreParam(CausalClusteringSettings.multi_dc_license, "true").withSharedCoreParam(CausalClusteringSettings.upstream_selection_strategy, "leader-only").withInstanceCoreParam(CausalClusteringSettings.refuse_to_be_leader, id -> id == 0 ? "false" : "true").withSharedReadReplicaParam(UdcSettings.udc_enabled, "false").withSharedReadReplicaParam(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms").withSharedReadReplicaParam(CausalClusteringSettings.multi_dc_license, "true").withSharedReadReplicaParam(CausalClusteringSettings.pull_interval, "100ms").withSharedReadReplicaParam(CausalClusteringSettings.upstream_selection_strategy, "leader-only");
    private Cluster<?> cluster;
    private CoreClusterMember leader;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    private long warmUpCluster() throws Exception {
        this.leader = this.cluster.awaitLeader();
        this.cluster.coreTx((db, tx) -> {
            PageCacheWarmupCcIT.createTestData((GraphDatabaseService)db);
            tx.success();
        });
        AtomicLong pagesInMemory = new AtomicLong();
        this.cluster.coreTx((db, tx) -> {
            PageCacheWarmupCcIT.waitForCacheProfile(this.leader.monitors());
            pagesInMemory.set(PageCacheWarmupCcIT.waitForCacheProfile(this.leader.monitors()));
        });
        for (CoreClusterMember member : this.cluster.coreMembers()) {
            PageCacheWarmupCcIT.waitForCacheProfile(member.monitors());
        }
        return pagesInMemory.get();
    }

    private static void verifyWarmupHappensAfterStoreCopy(ClusterMember member, long pagesInMemory) {
        AtomicLong pagesLoadedInWarmup = new AtomicLong();
        BinaryLatch warmupLatch = PageCacheWarmupCcIT.injectWarmupLatch(member, pagesLoadedInWarmup);
        member.start();
        warmupLatch.await();
        Assert.assertThat((Object)pagesLoadedInWarmup.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesInMemory)));
    }

    private static BinaryLatch injectWarmupLatch(ClusterMember member, final AtomicLong pagesLoadedInWarmup) {
        final BinaryLatch warmupLatch = new BinaryLatch();
        Monitors monitors = member.monitors();
        monitors.addMonitorListener((Object)new PageCacheWarmerMonitor(){

            public void warmupCompleted(long pagesLoaded) {
                pagesLoadedInWarmup.set(pagesLoaded);
                warmupLatch.release();
            }

            public void profileCompleted(long pagesInMemory) {
            }
        }, new String[0]);
        return warmupLatch;
    }

    @Test
    public void cacheProfilesMustBeIncludedInStoreCopyToCore() throws Exception {
        long pagesInMemory = this.warmUpCluster();
        CoreClusterMember member = this.cluster.newCoreMember();
        PageCacheWarmupCcIT.verifyWarmupHappensAfterStoreCopy((ClusterMember)member, pagesInMemory);
    }

    @Test
    public void cacheProfilesMustBeIncludedInStoreCopyToReadReplica() throws Exception {
        long pagesInMemory = this.warmUpCluster();
        ReadReplica member = this.cluster.newReadReplica();
        PageCacheWarmupCcIT.verifyWarmupHappensAfterStoreCopy((ClusterMember)member, pagesInMemory);
    }
}

