/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.backup.RestoreClusterUtils;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.restore.RestoreDatabaseCommand;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class ConvertNonCausalClusteringStoreIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    @Parameterized.Parameter
    public String recordFormat;

    @Parameterized.Parameters(name="Record format {0}")
    public static Collection<Object> data() {
        return Arrays.asList("standard", "high_limit");
    }

    @Test
    public void shouldReplicateTransactionToCoreMembers() throws Throwable {
        TestDirectory testDirectory = this.clusterRule.testDirectory();
        File dbDir = testDirectory.cleanDirectory("classic-db-" + this.recordFormat);
        int classicNodeCount = 1024;
        File classicNeo4jStore = this.createNeoStore(dbDir, classicNodeCount);
        Cluster cluster = this.clusterRule.withRecordFormat(this.recordFormat).createCluster();
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            for (CoreClusterMember core : cluster.coreMembers()) {
                new RestoreDatabaseCommand((FileSystemAbstraction)fileSystem, classicNeo4jStore, core.config(), core.settingValue(GraphDatabaseSettings.active_database.name()), true).execute();
            }
        }
        cluster.start();
        cluster.coreTx((coreDB, tx) -> {
            Node node = coreDB.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        cluster.addReadReplicaWithIdAndRecordFormat(4, this.recordFormat).start();
        for (CoreClusterMember server : cluster.coreMembers()) {
            CoreGraphDatabase db = server.database();
            Transaction tx2 = db.beginTx();
            Throwable throwable = null;
            try {
                ThrowingSupplier nodeCount = () -> Iterables.count((Iterable)db.getAllNodes());
                Config config = (Config)db.getDependencyResolver().resolveDependency(Config.class);
                org.neo4j.test.assertion.Assert.assertEventually((String)("node to appear on core server " + config.get(CausalClusteringSettings.raft_advertised_address)), (ThrowingSupplier)nodeCount, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(classicNodeCount)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
                Assert.assertEquals((long)(classicNodeCount + 1), (long)Iterables.count((Iterable)db.getAllNodes()));
                tx2.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx2 == null) continue;
                if (throwable != null) {
                    try {
                        tx2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx2.close();
            }
        }
    }

    private File createNeoStore(File dbDir, int classicNodeCount) throws IOException {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            File file = RestoreClusterUtils.createClassicNeo4jStore((File)dbDir, (FileSystemAbstraction)fileSystem, (int)classicNodeCount, (String)this.recordFormat);
            return file;
        }
    }
}

