/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.neo4j.bolt.runtime.BoltConnectionMetricsMonitor;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class BoltFailuresIT {
    private static final int TEST_TIMEOUT_SECONDS = 120;
    private final TestDirectory dir = TestDirectory.testDirectory();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)Timeout.seconds((long)120L)).around((TestRule)this.dir);
    private GraphDatabaseService db;
    private Driver driver;

    @After
    public void shutdownDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
        IOUtils.closeAllSilently((AutoCloseable[])new Driver[]{this.driver});
    }

    @Test
    public void throwsWhenMonitoredWorkerCreationFails() {
        ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
        sessionMonitor.throwInConnectionOpened();
        Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
        int port = PortAuthority.allocatePort();
        this.db = this.startDbWithBolt(new GraphDatabaseFactory().setMonitors(monitors), port);
        try {
            this.driver = BoltFailuresIT.createDriver(port);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    @Test
    public void throwsWhenInitMessageReceiveFails() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInMessageReceived, false);
    }

    @Test
    public void throwsWhenInitMessageProcessingFailsToStart() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInMessageProcessingStarted, false);
    }

    @Test
    public void throwsWhenInitMessageProcessingFailsToComplete() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInMessageProcessingCompleted, true);
    }

    @Test
    public void throwsWhenRunMessageReceiveFails() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInMessageReceived);
    }

    @Test
    public void throwsWhenRunMessageProcessingFailsToStart() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInMessageProcessingStarted);
    }

    @Test
    public void throwsWhenRunMessageProcessingFailsToComplete() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInMessageProcessingCompleted);
    }

    private void throwsWhenInitMessageFails(Consumer<ThrowingSessionMonitor> monitorSetup, boolean shouldBeAbleToBeginTransaction) {
        block27: {
            ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
            monitorSetup.accept(sessionMonitor);
            Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
            int port = PortAuthority.allocatePort();
            this.db = this.startTestDb(monitors, port);
            try {
                this.driver = GraphDatabase.driver((String)("bolt://localhost:" + port), (Config)Config.build().withoutEncryption().toConfig());
                if (shouldBeAbleToBeginTransaction) {
                    try (Session session = this.driver.session();
                         Transaction tx = session.beginTransaction();){
                        tx.run("CREATE ()").consume();
                        break block27;
                    }
                }
                Assert.fail((String)"Exception expected");
            }
            catch (Exception e) {
                Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
            }
        }
    }

    private void throwsWhenRunMessageFails(Consumer<ThrowingSessionMonitor> monitorSetup) {
        ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
        Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
        int port = PortAuthority.allocatePort();
        this.db = this.startTestDb(monitors, port);
        this.driver = BoltFailuresIT.createDriver(port);
        Session session = this.driver.session();
        Transaction tx = session.beginTransaction();
        monitorSetup.accept(sessionMonitor);
        tx.run("CREATE ()");
        try {
            tx.close();
            session.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    private GraphDatabaseService startTestDb(Monitors monitors, int port) {
        return this.startDbWithBolt((GraphDatabaseFactory)BoltFailuresIT.newDbFactory().setMonitors(monitors), port);
    }

    private GraphDatabaseService startDbWithBolt(GraphDatabaseFactory dbFactory, int port) {
        return dbFactory.newEmbeddedDatabaseBuilder(this.dir.storeDir()).setConfig(new BoltConnector((String)"0").type, GraphDatabaseSettings.Connector.ConnectorType.BOLT.name()).setConfig(new BoltConnector((String)"0").enabled, "true").setConfig(new BoltConnector((String)"0").listen_address, "localhost:" + port).setConfig(GraphDatabaseSettings.auth_enabled, "false").setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    private static TestEnterpriseGraphDatabaseFactory newDbFactory() {
        return new TestEnterpriseGraphDatabaseFactory();
    }

    private static Driver createDriver(int port) {
        return GraphDatabase.driver((String)("bolt://localhost:" + port), (Config)Config.build().withoutEncryption().toConfig());
    }

    private static Monitors newMonitorsSpy(ThrowingSessionMonitor sessionMonitor) {
        Monitors monitors = (Monitors)Mockito.spy((Object)new Monitors());
        Mockito.when((Object)monitors.newMonitor(BoltConnectionMetricsMonitor.class, new String[0])).thenReturn((Object)sessionMonitor);
        Mockito.when((Object)monitors.hasListeners(BoltConnectionMetricsMonitor.class)).thenReturn((Object)true);
        return monitors;
    }

    private static class ThrowingSessionMonitor
    implements BoltConnectionMetricsMonitor {
        volatile boolean throwInConnectionOpened;
        volatile boolean throwInMessageReceived;
        volatile boolean throwInMessageProcessingStarted;
        volatile boolean throwInMessageProcessingCompleted;

        private ThrowingSessionMonitor() {
        }

        public void connectionOpened() {
            this.throwIfNeeded(this.throwInConnectionOpened);
        }

        public void connectionActivated() {
        }

        public void connectionWaiting() {
        }

        public void messageReceived() {
            this.throwIfNeeded(this.throwInMessageReceived);
        }

        public void messageProcessingStarted(long queueTime) {
            this.throwIfNeeded(this.throwInMessageProcessingStarted);
        }

        public void messageProcessingCompleted(long processingTime) {
            this.throwIfNeeded(this.throwInMessageProcessingCompleted);
        }

        public void messageProcessingFailed() {
        }

        public void connectionClosed() {
        }

        void throwInConnectionOpened() {
            this.throwInConnectionOpened = true;
        }

        void throwInMessageReceived() {
            this.throwInMessageReceived = true;
        }

        void throwInMessageProcessingStarted() {
            this.throwInMessageProcessingStarted = true;
        }

        void throwInMessageProcessingCompleted() {
            this.throwInMessageProcessingCompleted = true;
        }

        void throwIfNeeded(boolean shouldThrow) {
            if (shouldThrow) {
                throw new RuntimeException();
            }
        }
    }
}

