/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Values;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;

@RunWith(value=Parameterized.class)
public class BoltDriverLargePropertiesIT {
    @ClassRule
    public static final Neo4jRule db = new Neo4jRule().withConfig(OnlineBackupSettings.online_backup_enabled, "false");
    private static Driver driver;
    @Parameterized.Parameter
    public int size;

    @BeforeClass
    public static void setUp() throws Exception {
        driver = GraphDatabase.driver((URI)db.boltURI());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (driver != null) {
            driver.close();
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object> arraySizes() {
        return Arrays.asList(1, 2, 3, 10, 999, 4295, 10001, 55155, 100000);
    }

    @Test
    public void shouldSendAndReceiveString() {
        String originalValue = RandomStringUtils.randomAlphanumeric((int)this.size);
        Object receivedValue = BoltDriverLargePropertiesIT.sendAndReceive(originalValue);
        Assert.assertEquals((Object)originalValue, (Object)receivedValue);
    }

    @Test
    public void shouldSendAndReceiveLongArray() {
        List originalLongs = ThreadLocalRandom.current().longs(this.size).boxed().collect(Collectors.toList());
        List receivedLongs = (List)BoltDriverLargePropertiesIT.sendAndReceive(originalLongs);
        Assert.assertEquals(originalLongs, (Object)receivedLongs);
    }

    private static Object sendAndReceive(Object value) {
        try (Session session = driver.session();){
            StatementResult result = session.run("RETURN $value", Values.parameters((Object[])new Object[]{"value", value}));
            Record record = result.single();
            Object object = record.get(0).asObject();
            return object;
        }
    }
}

