/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.auth;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.IntStream;
import org.junit.Rule;
import org.neo4j.auth.FlatFileStressBase;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class FlatFileChaoticStressIT
extends FlatFileStressBase {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Override
    FileSystemAbstraction getFileSystem() {
        return this.fsRule.get();
    }

    @Override
    ExecutorService setupWorkload(int n) {
        ExecutorService service = Executors.newFixedThreadPool(n);
        Set<String> usernames = this.makeWithPrefix("user", n);
        Set<String> roleNames = this.makeWithPrefix("role", n);
        for (int i = 0; i < n; ++i) {
            service.submit(new ChaoticAdmin(i, usernames, roleNames));
        }
        return service;
    }

    private Set<String> makeWithPrefix(String prefix, int n) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        IntStream.range(0, n).forEach(i -> set.add(prefix + i));
        return set;
    }

    private class ChaoticAdmin
    extends FlatFileStressBase.IrrationalAdmin {
        private final int number;
        private final String[] usernames;
        private final String[] roleNames;

        ChaoticAdmin(int number, Set<String> usernames, Set<String> roleNames) {
            super(FlatFileChaoticStressIT.this);
            this.number = number;
            this.usernames = usernames.toArray(new String[usernames.size()]);
            this.roleNames = roleNames.toArray(new String[roleNames.size()]);
            this.setActions(this::createUser, this::deleteUser, this::changePassword, this::suspend, this::activate, this::createRole, this::deleteRole, this::assignRole, this::unAssignRole);
        }

        public String toString() {
            return "ChaoticAdmin " + this.number;
        }

        private void createUser() {
            String username = this.randomUser();
            String password = this.deviousPassword();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.newUser(username, password, false);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void deleteUser() {
            String username = this.randomUser();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.deleteUser(username);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void changePassword() {
            String username = this.randomUser();
            String password = this.deviousPassword();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.setUserPassword(username, password, false);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void suspend() {
            String username = this.randomUser();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.suspendUser(username);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void activate() {
            String username = this.randomUser();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.activateUser(username, false);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void createRole() {
            String username = this.randomUser();
            String roleName = this.randomRole();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.newRole(roleName, new String[]{username});
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void deleteRole() {
            String roleName = this.randomRole();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.deleteRole(roleName);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void assignRole() {
            String username = this.randomUser();
            String roleName = this.randomRole();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.addRoleToUser(roleName, username);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private void unAssignRole() {
            String username = this.randomUser();
            String roleName = this.randomRole();
            try {
                FlatFileChaoticStressIT.this.flatFileRealm.removeRoleFromUser(roleName, username);
            }
            catch (IOException e) {
                FlatFileChaoticStressIT.this.errors.add(e);
            }
            catch (InvalidArgumentsException invalidArgumentsException) {
                // empty catch block
            }
        }

        private String deviousPassword() {
            return this.random.nextBoolean() ? "123" : "321";
        }

        private String randomUser() {
            return this.usernames[this.random.nextInt(this.usernames.length)];
        }

        private String randomRole() {
            return this.roleNames[this.random.nextInt(this.roleNames.length)];
        }
    }
}

