/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storeupgrade;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.IntFunction;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.impl.lucene.explicit.LuceneIndexImplementation;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.Unzip;
import org.neo4j.test.matchers.NestedThrowableMatcher;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class ExplicitIndexesUpgradeIT {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void successfulMigrationWithoutExplicitIndexes() throws Exception {
        this.prepareStore("empty-explicit-index-db.zip");
        GraphDatabaseService db = this.startDatabase(true);
        try {
            this.checkDbAccessible(db);
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void successfulMigrationExplicitIndexes() throws Exception {
        this.prepareStore("explicit-index-db.zip");
        GraphDatabaseService db = this.startDatabase(true);
        try {
            this.checkDbAccessible(db);
            this.checkIndexData(db);
        }
        finally {
            db.shutdown();
        }
        this.checkMigrationProgressFeedback();
    }

    @Test
    public void migrationShouldFailIfUpgradeNotAllowed() throws IOException {
        this.prepareStore("explicit-index-db.zip");
        this.expectedException.expect((Matcher)new NestedThrowableMatcher(UpgradeNotAllowedByConfigurationException.class));
        this.startDatabase(false);
    }

    private void checkDbAccessible(GraphDatabaseService db) {
        try (Transaction transaction = db.beginTx();){
            Assert.assertNotNull((Object)db.getNodeById(1L));
            transaction.success();
        }
    }

    private GraphDatabaseService startDatabase(boolean allowUpgrade) {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(this.testDir.graphDbDir());
        builder.setConfig(GraphDatabaseSettings.allow_upgrade, Boolean.toString(allowUpgrade));
        builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
        builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
        return builder.newGraphDatabase();
    }

    private void checkIndexData(GraphDatabaseService db) {
        IntFunction<String> keyFactory = this.basicKeyFactory();
        Factory<Node> readNodes = this.readNodes(db);
        this.readIndex(db, this.nodeIndex(db, "node-1", LuceneIndexImplementation.EXACT_CONFIG), readNodes, keyFactory, this.stringValues());
        this.readIndex(db, this.nodeIndex(db, "node-2", LuceneIndexImplementation.EXACT_CONFIG), readNodes, keyFactory, this.intValues());
        this.readIndex(db, this.nodeIndex(db, "node-3", LuceneIndexImplementation.FULLTEXT_CONFIG), readNodes, keyFactory, this.stringValues());
        this.readIndex(db, this.nodeIndex(db, "node-4", LuceneIndexImplementation.FULLTEXT_CONFIG), readNodes, keyFactory, this.longValues());
        Factory<Relationship> relationships = this.readRelationships(db);
        this.readIndex(db, (Index)this.relationshipIndex(db, "rel-1", LuceneIndexImplementation.EXACT_CONFIG), (Factory)relationships, keyFactory, this.stringValues());
        this.readIndex(db, (Index)this.relationshipIndex(db, "rel-2", LuceneIndexImplementation.EXACT_CONFIG), (Factory)relationships, keyFactory, this.floatValues());
        this.readIndex(db, (Index)this.relationshipIndex(db, "rel-3", LuceneIndexImplementation.FULLTEXT_CONFIG), (Factory)relationships, keyFactory, this.stringValues());
        this.readIndex(db, (Index)this.relationshipIndex(db, "rel-4", LuceneIndexImplementation.FULLTEXT_CONFIG), (Factory)relationships, keyFactory, this.doubleValues());
    }

    private void prepareStore(String store) throws IOException {
        Unzip.unzip(this.getClass(), (String)store, (File)this.testDir.graphDbDir());
    }

    private IntFunction<Object> intValues() {
        return ValueContext::numeric;
    }

    private IntFunction<Object> longValues() {
        return value -> ValueContext.numeric((Number)value);
    }

    private IntFunction<Object> floatValues() {
        return value -> ValueContext.numeric((Number)Float.valueOf(value));
    }

    private IntFunction<Object> doubleValues() {
        return value -> ValueContext.numeric((Number)value);
    }

    private IntFunction<Object> stringValues() {
        return value -> "value balue " + value;
    }

    private Factory<Node> readNodes(final GraphDatabaseService db) {
        return new Factory<Node>(){
            private long id;

            public Node newInstance() {
                return db.getNodeById(this.id++);
            }
        };
    }

    private Factory<Relationship> readRelationships(final GraphDatabaseService db) {
        return new Factory<Relationship>(){
            private long id;

            public Relationship newInstance() {
                return db.getRelationshipById(this.id++);
            }
        };
    }

    private Index<Node> nodeIndex(GraphDatabaseService db, String name, Map<String, String> config) {
        try (Transaction tx = db.beginTx();){
            Index index = db.index().forNodes(name, config);
            tx.success();
            Index index2 = index;
            return index2;
        }
    }

    private RelationshipIndex relationshipIndex(GraphDatabaseService db, String name, Map<String, String> config) {
        try (Transaction tx = db.beginTx();){
            RelationshipIndex index = db.index().forRelationships(name, config);
            tx.success();
            RelationshipIndex relationshipIndex = index;
            return relationshipIndex;
        }
    }

    private <ENTITY extends PropertyContainer> void readIndex(GraphDatabaseService db, Index<ENTITY> index, Factory<ENTITY> entityFactory, IntFunction<String> keyFactory, IntFunction<Object> valueFactory) {
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 10; ++i) {
                PropertyContainer entity = (PropertyContainer)entityFactory.newInstance();
                String key = keyFactory.apply(i);
                Object value = valueFactory.apply(i);
                Assert.assertEquals((Object)entity, (Object)Iterators.single((Iterator)index.get(key, value)));
            }
            tx.success();
        }
    }

    private IntFunction<String> basicKeyFactory() {
        return value -> "key-" + value % 3;
    }

    private void checkMigrationProgressFeedback() {
        this.suppressOutput.getOutputVoice().containsMessage("Starting upgrade of database");
        this.suppressOutput.getOutputVoice().containsMessage("Successfully finished upgrade of database");
        this.suppressOutput.getOutputVoice().containsMessage("10%");
        this.suppressOutput.getOutputVoice().containsMessage("100%");
    }
}

