/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.ssl.SecureClient;
import org.neo4j.ssl.SecureServer;
import org.neo4j.ssl.SslContextFactory;
import org.neo4j.ssl.SslResource;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class SslNegotiationTest {
    private static final String OLD_CIPHER_A = "SSL_RSA_WITH_NULL_SHA";
    private static final String OLD_CIPHER_B = "SSL_RSA_WITH_RC4_128_MD5";
    private static final String OLD_CIPHER_C = "SSL_RSA_WITH_3DES_EDE_CBC_SHA";
    private static final String NEW_CIPHER_A = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";
    private static final String NEW_CIPHER_B = "TLS_RSA_WITH_AES_128_CBC_SHA256";
    private static final String NEW_CIPHER_C = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256";
    private static final String TLSv10 = "TLSv1";
    private static final String TLSv11 = "TLSv1.1";
    private static final String TLSv12 = "TLSv1.2";
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    @Parameterized.Parameter
    public TestSetup setup;
    private SecureServer server;
    private SecureClient client;

    @Parameterized.Parameters(name="{0}")
    public static Object[] params() {
        return new TestSetup[]{new TestSetup(SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_A), true, TLSv10, OLD_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv10).ciphers(NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv10).ciphers(NEW_CIPHER_A), true, TLSv10, NEW_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv11).ciphers(OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv11).ciphers(OLD_CIPHER_A), true, TLSv11, OLD_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_A), true, TLSv11, NEW_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_A), true, TLSv12, NEW_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv11).ciphers(OLD_CIPHER_A), false), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv11).ciphers(OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_A), false), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_A), false), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_A), false), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_B), false), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_B), false), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_B), false), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_B, OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv10).ciphers(OLD_CIPHER_C, OLD_CIPHER_A), true, TLSv10, OLD_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_B, NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv11).ciphers(NEW_CIPHER_C, NEW_CIPHER_A), true, TLSv11, NEW_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_B, NEW_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv12).ciphers(NEW_CIPHER_C, NEW_CIPHER_A), true, TLSv12, NEW_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv10, TLSv11).ciphers(OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv11, TLSv12).ciphers(OLD_CIPHER_A), true, TLSv11, OLD_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv11, TLSv12).ciphers(OLD_CIPHER_A), SslContextFactory.SslParameters.protocols(TLSv10, TLSv11).ciphers(OLD_CIPHER_A), true, TLSv11, OLD_CIPHER_A), new TestSetup(SslContextFactory.SslParameters.protocols(TLSv10, TLSv11, TLSv12).ciphers(NEW_CIPHER_B), SslContextFactory.SslParameters.protocols(TLSv10, TLSv11, TLSv12).ciphers(NEW_CIPHER_B), true, TLSv12, NEW_CIPHER_B)};
    }

    @After
    public void cleanup() {
        if (this.client != null) {
            this.client.disconnect();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldNegotiateCorrectly() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(1).install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("client"));
        this.server = new SecureServer(SslContextFactory.makeSslContext(sslServerResource, true, this.setup.serverParams));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslContext(sslClientResource, false, this.setup.clientParams));
        this.client.connect(this.server.port());
        Assert.assertTrue((boolean)this.client.sslHandshakeFuture().await(1L, TimeUnit.MINUTES));
        if (this.setup.expectedSuccess) {
            Assert.assertNull((Object)this.client.sslHandshakeFuture().cause());
            Assert.assertEquals((Object)this.setup.expectedProtocol, (Object)this.client.protocol());
            Assert.assertEquals((Object)this.setup.expectedCipher.substring(4), (Object)this.client.ciphers().substring(4));
        } else {
            Assert.assertNotNull((Object)this.client.sslHandshakeFuture().cause());
        }
    }

    private static class TestSetup {
        private final SslContextFactory.SslParameters serverParams;
        private final SslContextFactory.SslParameters clientParams;
        private final boolean expectedSuccess;
        private final String expectedProtocol;
        private final String expectedCipher;

        private TestSetup(SslContextFactory.SslParameters serverParams, SslContextFactory.SslParameters clientParams, boolean expectedSuccess) {
            this(serverParams, clientParams, expectedSuccess, null, null);
        }

        private TestSetup(SslContextFactory.SslParameters serverParams, SslContextFactory.SslParameters clientParams, boolean expectedSuccess, String expectedProtocol, String expectedCipher) {
            this.serverParams = serverParams;
            this.clientParams = clientParams;
            this.expectedSuccess = expectedSuccess;
            this.expectedProtocol = expectedProtocol;
            this.expectedCipher = expectedCipher;
        }

        public String toString() {
            return "TestSetup{serverParams=" + this.serverParams + ", clientParams=" + this.clientParams + ", expectedSuccess=" + this.expectedSuccess + ", expectedProtocol='" + this.expectedProtocol + '\'' + ", expectedCipher='" + this.expectedCipher + '\'' + '}';
        }
    }
}

