/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;

class SecureServer {
    static final byte[] RESPONSE = new byte[]{5, 6, 7, 8};
    private SslContext sslContext;
    private Channel channel;
    private NioEventLoopGroup eventLoopGroup;

    SecureServer(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    void start() {
        this.eventLoopGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).localAddress(0)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                SSLEngine sslEngine = SecureServer.this.sslContext.newEngine(ch.alloc());
                sslEngine.setNeedClientAuth(true);
                SslHandler sslHandler = new SslHandler(sslEngine);
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                pipeline.addLast(new ChannelHandler[]{new Responder()});
            }
        });
        this.channel = bootstrap.bind().syncUninterruptibly().channel();
    }

    void stop() {
        this.channel.close().awaitUninterruptibly();
        this.channel = null;
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }

    int port() {
        return ((InetSocketAddress)this.channel.localAddress()).getPort();
    }

    static class Responder
    extends SimpleChannelInboundHandler<ByteBuf> {
        Responder() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            ctx.channel().writeAndFlush((Object)ctx.alloc().buffer().writeBytes(RESPONSE));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        }
    }
}

