/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.neo4j.test.assertion.Assert;

public class SecureClient {
    private Bootstrap bootstrap;
    private ClientInitializer clientInitializer;
    private NioEventLoopGroup eventLoopGroup;
    private Channel channel;
    private Bucket bucket = new Bucket();

    public SecureClient(SslContext sslContext) {
        this.eventLoopGroup = new NioEventLoopGroup();
        this.clientInitializer = new ClientInitializer(sslContext, this.bucket);
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.clientInitializer);
    }

    public void connect(int port) {
        ChannelFuture channelFuture = this.bootstrap.connect("localhost", port).awaitUninterruptibly();
        this.channel = channelFuture.channel();
        if (!channelFuture.isSuccess()) {
            throw new RuntimeException("Failed to connect", channelFuture.cause());
        }
    }

    void disconnect() {
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
            this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
        this.bucket.collectedData.release();
    }

    void assertResponse(ByteBuf expected) throws InterruptedException {
        Assert.assertEventually((String)this.channel.toString(), () -> this.bucket.collectedData, (Matcher)Matchers.equalTo((Object)expected), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    Channel channel() {
        return this.channel;
    }

    public Future<Channel> sslHandshakeFuture() {
        return this.clientInitializer.handshakeFuture;
    }

    public String ciphers() {
        return this.clientInitializer.sslEngine.getSession().getCipherSuite();
    }

    public String protocol() {
        return this.clientInitializer.sslEngine.getSession().getProtocol();
    }

    public static class ClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private SslContext sslContext;
        private final Bucket bucket;
        private Future<Channel> handshakeFuture;
        private SSLEngine sslEngine;

        ClientInitializer(SslContext sslContext, Bucket bucket) {
            this.sslContext = sslContext;
            this.bucket = bucket;
        }

        protected void initChannel(SocketChannel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            this.sslEngine = this.sslContext.newEngine(channel.alloc());
            this.sslEngine.setUseClientMode(true);
            SslHandler sslHandler = new SslHandler(this.sslEngine);
            this.handshakeFuture = sslHandler.handshakeFuture();
            pipeline.addLast(new ChannelHandler[]{sslHandler});
            pipeline.addLast(new ChannelHandler[]{this.bucket});
        }
    }

    static class Bucket
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final ByteBuf collectedData = ByteBufAllocator.DEFAULT.buffer();

        Bucket() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.collectedData.writeBytes(msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        }
    }
}

