/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.net.URI;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;

public class DeleteUserStressIT {
    @Rule
    public Neo4jRule db = new Neo4jRule().withConfig(GraphDatabaseSettings.auth_enabled, "true").withConfig(OnlineBackupSettings.online_backup_enabled, "false");
    private Driver adminDriver;
    private final Set<Throwable> errors = ConcurrentHashMap.newKeySet();
    private final Runnable transactionWork = () -> {
        while (true) {
            try {
                while (true) {
                    Driver driver;
                    block38: {
                        driver = GraphDatabase.driver((URI)this.db.boltURI(), (AuthToken)AuthTokens.basic((String)"pontus", (String)"sutnop"));
                        Throwable throwable = null;
                        try {
                            try (Session session = driver.session();
                                 Transaction tx = session.beginTransaction();){
                                tx.run("UNWIND range(1, 100000) AS n RETURN n").consume();
                                tx.success();
                            }
                            if (driver == null) continue;
                            if (throwable == null) break block38;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (driver == null) throw throwable4;
                                if (throwable == null) {
                                    driver.close();
                                    throw throwable4;
                                }
                                try {
                                    driver.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        try {
                            driver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    driver.close();
                }
            }
            catch (ClientException e) {
                if (e.getMessage().equals("The client is unauthorized due to authentication failure.")) continue;
                this.errors.add(e);
                continue;
            }
            break;
        }
    };
    private final Runnable deleteUserWork = () -> {
        while (true) {
            try {
                while (true) {
                    Session session;
                    block26: {
                        session = this.adminDriver.session();
                        Throwable throwable = null;
                        try {
                            try (Transaction tx = session.beginTransaction();){
                                tx.run("CALL dbms.security.deleteUser('pontus')").consume();
                                tx.success();
                            }
                            if (session == null) continue;
                            if (throwable == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (session == null) throw throwable4;
                                if (throwable == null) {
                                    session.close();
                                    throw throwable4;
                                }
                                try {
                                    session.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    session.close();
                }
            }
            catch (ClientException e) {
                if (e.getMessage().equals("User 'pontus' does not exist.")) continue;
                this.errors.add(e);
                continue;
            }
            break;
        }
    };
    private final Runnable createUserWork = () -> {
        while (true) {
            try {
                while (true) {
                    Session session;
                    block26: {
                        session = this.adminDriver.session();
                        Throwable throwable = null;
                        try {
                            try (Transaction tx = session.beginTransaction();){
                                tx.run("CALL dbms.security.createUser('pontus', 'sutnop', false)").consume();
                                tx.success();
                            }
                            if (session == null) continue;
                            if (throwable == null) break block26;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (session == null) throw throwable4;
                                if (throwable == null) {
                                    session.close();
                                    throw throwable4;
                                }
                                try {
                                    session.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    session.close();
                }
            }
            catch (ClientException e) {
                if (e.getMessage().equals("The specified user 'pontus' already exists.")) continue;
                this.errors.add(e);
                continue;
            }
            break;
        }
    };

    @Before
    public void setup() {
        this.adminDriver = GraphDatabase.driver((URI)this.db.boltURI(), (AuthToken)AuthTokens.basic((String)"neo4j", (String)"neo4j"));
        try (Session session = this.adminDriver.session();
             Transaction tx = session.beginTransaction();){
            tx.run("CALL dbms.changePassword('abc')").consume();
            tx.success();
        }
        this.adminDriver.close();
        this.adminDriver = GraphDatabase.driver((URI)this.db.boltURI(), (AuthToken)AuthTokens.basic((String)"neo4j", (String)"abc"));
    }

    @Test
    public void shouldRun() throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(3);
        service.submit(this.createUserWork);
        service.submit(this.deleteUserWork);
        service.submit(this.transactionWork);
        service.awaitTermination(30L, TimeUnit.SECONDS);
        String msg = String.join((CharSequence)System.lineSeparator(), this.errors.stream().map(Throwable::getMessage).collect(Collectors.toList()));
        MatcherAssert.assertThat((String)msg, this.errors, (Matcher)Matchers.empty());
    }
}

