/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.rule.SuppressOutput;

public class CypherOverBoltIT {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public Neo4jRule graphDb = new Neo4jRule();
    private URL url;
    private final int lineCountInCSV = 3;

    @Before
    public void setUp() throws Exception {
        this.url = this.prepareTestImportFile(3);
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWork() {
        for (int i = 2; i < 4; ++i) {
            try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
                 Session session = driver.session();){
                StatementResult result = session.run("USING PERIODIC COMMIT " + i + "\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label1 {uuid:row[0]})\nRETURN currentnode;");
                int countOfNodes = 0;
                while (result.hasNext()) {
                    Node node = result.next().get(0).asNode();
                    Assert.assertTrue((boolean)node.hasLabel("Label1"));
                    Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                    ++countOfNodes;
                }
                Assert.assertEquals((long)3L, (long)countOfNodes);
                session.reset();
                continue;
            }
        }
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWork2() {
        try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
             Session session = driver.session();){
            StatementResult result = session.run("USING PERIODIC COMMIT 4\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label1 {uuid:row[0]})\nRETURN currentnode;");
            int countOfNodes = 0;
            while (result.hasNext()) {
                Node node = result.next().get(0).asNode();
                Assert.assertTrue((boolean)node.hasLabel("Label1"));
                Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                ++countOfNodes;
            }
            Assert.assertEquals((long)3L, (long)countOfNodes);
        }
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWork3() {
        try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
             Session session = driver.session();){
            StatementResult result = session.run("USING PERIODIC COMMIT 3\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label1 {uuid:row[0]})\nRETURN currentnode;");
            int countOfNodes = 0;
            while (result.hasNext()) {
                Node node = result.next().get(0).asNode();
                Assert.assertTrue((boolean)node.hasLabel("Label1"));
                Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                ++countOfNodes;
            }
            Assert.assertEquals((long)3L, (long)countOfNodes);
        }
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWorkWithLists() throws Exception {
        try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
             Session session = driver.session();){
            StatementResult result = session.run("USING PERIODIC COMMIT 2\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label2 {uuid:row[0]})\nRETURN [currentnode];");
            int countOfNodes = 0;
            while (result.hasNext()) {
                for (Node node : result.next().get(0).asList()) {
                    Assert.assertTrue((boolean)node.hasLabel("Label2"));
                    Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                    ++countOfNodes;
                }
            }
            Assert.assertEquals((long)3L, (long)countOfNodes);
        }
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWorkWithListsOfLists() throws Exception {
        try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
             Session session = driver.session();){
            StatementResult result = session.run("USING PERIODIC COMMIT 2\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label3 {uuid:row[0]})\nRETURN [[currentnode]];");
            int countOfNodes = 0;
            while (result.hasNext()) {
                Iterator iterator = result.next().get(0).asList().iterator();
                Assert.assertTrue((boolean)iterator.hasNext());
                for (Node node : (List)iterator.next()) {
                    Assert.assertTrue((boolean)node.hasLabel("Label3"));
                    Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                    ++countOfNodes;
                }
            }
            Assert.assertEquals((long)3L, (long)countOfNodes);
        }
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWorkWithMaps() throws Exception {
        try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
             Session session = driver.session();){
            StatementResult result = session.run("USING PERIODIC COMMIT 2\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label4 {uuid:row[0]})\nRETURN {node:currentnode};");
            int countOfNodes = 0;
            while (result.hasNext()) {
                for (Map.Entry entry : result.next().get(0).asMap().entrySet()) {
                    Assert.assertEquals((Object)"node", entry.getKey());
                    Node node = (Node)entry.getValue();
                    Assert.assertTrue((boolean)node.hasLabel("Label4"));
                    Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                    ++countOfNodes;
                }
            }
            Assert.assertEquals((long)3L, (long)countOfNodes);
        }
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWorkWithMapsWithinMaps() throws Exception {
        try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
             Session session = driver.session();){
            StatementResult result = session.run("USING PERIODIC COMMIT 2\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label5 {uuid:row[0]})\nRETURN {outer:{node:currentnode}};");
            int countOfNodes = 0;
            while (result.hasNext()) {
                Iterator iterator = result.next().get(0).asMap().entrySet().iterator();
                Assert.assertTrue((boolean)iterator.hasNext());
                for (Map.Entry entry : ((Map)iterator.next().getValue()).entrySet()) {
                    Assert.assertEquals((Object)"node", entry.getKey());
                    Node node = (Node)entry.getValue();
                    Assert.assertTrue((boolean)node.hasLabel("Label5"));
                    Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                    ++countOfNodes;
                }
            }
            Assert.assertEquals((long)3L, (long)countOfNodes);
        }
    }

    @Test
    public void mixingPeriodicCommitAndLoadCSVShouldWorkWithMapsWithLists() throws Exception {
        try (Driver driver = GraphDatabase.driver((URI)this.graphDb.boltURI(), (Config)this.configuration());
             Session session = driver.session();){
            StatementResult result = session.run("USING PERIODIC COMMIT 2\nLOAD CSV FROM \"" + this.url + "\" as row fieldterminator \" \"\nMERGE (currentnode:Label6 {uuid:row[0]})\nRETURN {outer:[currentnode]};");
            int countOfNodes = 0;
            while (result.hasNext()) {
                Iterator mapIterator = result.next().get(0).asMap().entrySet().iterator();
                Assert.assertTrue((boolean)mapIterator.hasNext());
                for (Node node : (List)mapIterator.next().getValue()) {
                    Assert.assertTrue((boolean)node.hasLabel("Label6"));
                    Assert.assertEquals((Object)String.valueOf(countOfNodes), (Object)node.get("uuid").asString());
                    ++countOfNodes;
                }
            }
            Assert.assertEquals((long)3L, (long)countOfNodes);
        }
    }

    private Config configuration() {
        return Config.build().withEncryptionLevel(Config.EncryptionLevel.NONE).toConfig();
    }

    private URL prepareTestImportFile(int lines) throws IOException {
        File tempFile = File.createTempFile("testImport", ".csv");
        try (PrintWriter writer = FileUtils.newFilePrintWriter((File)tempFile, (Charset)StandardCharsets.UTF_8);){
            for (int i = 0; i < lines; ++i) {
                writer.println(i + " " + i + " " + i);
            }
        }
        return tempFile.toURI().toURL();
    }
}

