/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.util.Pair;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.TestDirectory;

public class BoltSnapshotQueryExecutionIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private Driver driver;
    private GraphDatabaseService db;

    @After
    public void tearDown() {
        if (this.db != null) {
            this.db.shutdown();
        }
        IOUtils.closeAllSilently((AutoCloseable[])new Driver[]{this.driver});
    }

    @Test
    public void executeQueryWithSnapshotEngine() {
        this.executeQuery("withSnapshotEngine", "true");
    }

    @Test
    public void executeQueryWithoutSnapshotEngine() {
        this.executeQuery("withoutSnapshotEngine", "false");
    }

    private void executeQuery(String directory, String useSnapshotEngineSettingValue) {
        this.db = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.directory(directory)).setConfig(new BoltConnector((String)"bolt").type, "BOLT").setConfig(new BoltConnector((String)"bolt").enabled, "true").setConfig(new BoltConnector((String)"bolt").listen_address, "localhost:0").setConfig(GraphDatabaseSettings.snapshot_query, useSnapshotEngineSettingValue).newGraphDatabase();
        this.initDatabase();
        this.connectDirver();
        this.verifyQueryExecution();
    }

    private void verifyQueryExecution() {
        try (Session session = this.driver.session();){
            session.readTransaction(tx -> {
                StatementResult statementResult = tx.run("MATCH (n) RETURN n.name, n.profession, n.planet, n.city ORDER BY n.name");
                List<String> fields = Arrays.asList("n.name", "n.profession", "n.planet", "n.city");
                Record amy = statementResult.next();
                Assert.assertEquals((Object)amy.keys(), fields);
                this.assertPairs(amy.fields(), "n.name", "Amy", "n.profession", "Student", "n.planet", "Mars", "n.city", "null");
                Record fry = statementResult.next();
                Assert.assertEquals((Object)fry.keys(), fields);
                this.assertPairs(fry.fields(), "n.name", "Fry", "n.profession", "Delivery Boy", "n.planet", "Earth", "n.city", "New York");
                Record lila = statementResult.next();
                Assert.assertEquals((Object)lila.keys(), fields);
                this.assertPairs(lila.fields(), "n.name", "Lila", "n.profession", "Pilot", "n.planet", "Earth", "n.city", "New York");
                Assert.assertFalse((boolean)statementResult.hasNext());
                return null;
            });
        }
    }

    private void connectDirver() {
        this.driver = GraphDatabase.driver((URI)this.boltURI(), (Config)Config.build().withoutEncryption().toConfig());
    }

    private void initDatabase() {
        try (Transaction transaction = this.db.beginTx();){
            Node fry = this.db.createNode();
            fry.setProperty("name", (Object)"Fry");
            fry.setProperty("profession", (Object)"Delivery Boy");
            fry.setProperty("planet", (Object)"Earth");
            fry.setProperty("city", (Object)"New York");
            Node lila = this.db.createNode();
            lila.setProperty("name", (Object)"Lila");
            lila.setProperty("profession", (Object)"Pilot");
            lila.setProperty("planet", (Object)"Earth");
            lila.setProperty("city", (Object)"New York");
            Node amy = this.db.createNode();
            amy.setProperty("name", (Object)"Amy");
            amy.setProperty("profession", (Object)"Student");
            amy.setProperty("planet", (Object)"Mars");
            transaction.success();
        }
    }

    private void assertPairs(List<Pair<String, Value>> pairs, String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4) {
        Assert.assertThat(pairs, (Matcher)Matchers.hasSize((int)4));
        this.validatePair(pairs.get(0), key1, value1);
        this.validatePair(pairs.get(1), key2, value2);
        this.validatePair(pairs.get(2), key3, value3);
        this.validatePair(pairs.get(3), key4, value4);
    }

    private void validatePair(Pair<String, Value> pair, String key, String value) {
        Assert.assertEquals((Object)key, (Object)pair.key());
        Assert.assertEquals((Object)value, (Object)((Value)pair.value()).asString());
    }

    private URI boltURI() {
        ConnectorPortRegister connectorPortRegister = (ConnectorPortRegister)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        HostnamePort boltHostNamePort = connectorPortRegister.getLocalAddress("bolt");
        return URI.create("bolt://" + boltHostNamePort.getHost() + ":" + boltHostNamePort.getPort());
    }
}

