/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;

public class BoltProceduresIT {
    @ClassRule
    public static final Neo4jRule db = new Neo4jRule().withProcedure(BoltTestProcedures.class).withConfig(OnlineBackupSettings.online_backup_enabled, "false");
    private static Driver driver;

    @BeforeClass
    public static void setUp() throws Exception {
        driver = GraphDatabase.driver((URI)db.boltURI());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (driver != null) {
            driver.close();
        }
    }

    @Test
    public void shouldTransmitStreamingFailure() {
        try (Session session = driver.session();){
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("name1", BoltProceduresIT.randomLongString());
            params.put("name2", BoltProceduresIT.randomLongString());
            session.run("CREATE (n1 :Person {name: $name1}), (n2 :Person {name: $name2}) RETURN n1, n2", params).consume();
            StatementResult result = session.run("CALL test.readNodesReturnThemAndTerminateTheTransaction() YIELD node");
            Assert.assertTrue((boolean)result.hasNext());
            Record record = result.next();
            Assert.assertEquals((Object)"Person", (Object)Iterables.single((Iterable)record.get(0).asNode().labels()));
            Assert.assertNotNull((Object)record.get(0).asNode().get("name"));
            try {
                result.hasNext();
                Assert.fail((String)"Exception expected");
            }
            catch (TransientException e) {
                Assert.assertEquals((Object)Status.Transaction.Terminated.code().serialize(), (Object)e.code());
            }
        }
    }

    private static String randomLongString() {
        return RandomStringUtils.randomAlphanumeric((int)10000);
    }

    private static class TransactionTerminatingIterator<T>
    implements Iterator<T> {
        final KernelTransaction tx;
        final Queue<T> elements;

        @SafeVarargs
        private TransactionTerminatingIterator(KernelTransaction tx, T ... elements) {
            this.tx = tx;
            this.elements = new ArrayDeque<T>();
            Collections.addAll(this.elements, elements);
        }

        @Override
        public boolean hasNext() {
            return !this.elements.isEmpty();
        }

        @Override
        public T next() {
            T element;
            if (this.elements.size() == 1) {
                this.tx.markForTermination((Status)Status.Transaction.Terminated);
            }
            if ((element = this.elements.poll()) == null) {
                throw new NoSuchElementException();
            }
            return element;
        }
    }

    public static class NodeResult {
        public Node node;

        NodeResult(Node node) {
            this.node = node;
        }
    }

    public static class BoltTestProcedures {
        @Context
        public GraphDatabaseService db;
        @Context
        public KernelTransaction tx;

        @Procedure(name="test.readNodesReturnThemAndTerminateTheTransaction", mode=Mode.READ)
        public Stream<NodeResult> readNodesReturnThemAndTerminateTheTransaction() {
            Result result = this.db.execute("MATCH (n) RETURN n");
            Object[] results = (NodeResult[])result.stream().map(record -> (Node)record.get("n")).map(NodeResult::new).toArray(NodeResult[]::new);
            return Iterators.stream(new TransactionTerminatingIterator(this.tx, results));
        }
    }
}

