/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.EditionModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.enterprise.OpenEnterpriseNeoServer;
import org.neo4j.server.enterprise.helpers.EnterpriseServerBuilder;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.HTTP;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class TransactionGuardIT {
    @ClassRule
    public static CleanupRule cleanupRule = new CleanupRule();
    @ClassRule
    public static TestDirectory testDirectory = TestDirectory.testDirectory();
    private static final String BOLT_CONNECTOR_KEY = "bolt";
    private static final FakeClock fakeClock = Clocks.fakeClock();
    private static GraphDatabaseAPI databaseWithTimeout;
    private static GraphDatabaseAPI databaseWithoutTimeout;
    private static OpenEnterpriseNeoServer neoServer;
    private static int boltPortDatabaseWithTimeout;
    private static final String DEFAULT_TIMEOUT = "2s";
    private static final KernelTransactionTimeoutMonitorSupplier monitorSupplier;
    private static final IdInjectionFunctionAction getIdInjectionFunction;

    @After
    public void tearDown() {
        monitorSupplier.clear();
    }

    @Test
    public void terminateLongRunningTransaction() {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx();){
            fakeClock.forward(3L, TimeUnit.SECONDS);
            transaction.success();
            timeoutMonitor.run();
            database.createNode();
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (TransactionTerminatedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"The transaction has been terminated."));
            Assert.assertEquals((Object)e.status(), (Object)Status.Transaction.TransactionTimedOut);
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningTransactionWithPeriodicCommit() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        monitorSupplier.setTransactionTimeoutMonitor(timeoutMonitor);
        try {
            URL url = this.prepareTestImportFile(8);
            database.execute("USING PERIODIC COMMIT 5 LOAD CSV FROM '" + url + "' AS line CREATE ();");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (TransactionTerminatedException transactionTerminatedException) {
            // empty catch block
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateTransactionWithCustomTimeoutWithoutConfiguredDefault() {
        GraphDatabaseAPI database = this.startDatabaseWithoutTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx(27L, TimeUnit.SECONDS);){
            fakeClock.forward(26L, TimeUnit.SECONDS);
            timeoutMonitor.run();
            database.createNode();
            transaction.failure();
        }
        try {
            transaction = database.beginTx(27L, TimeUnit.SECONDS);
            var4_5 = null;
            try {
                fakeClock.forward(28L, TimeUnit.SECONDS);
                timeoutMonitor.run();
                database.createNode();
                Assert.fail((String)"Transaction should be already terminated.");
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var4_5 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (TransactionTerminatedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"The transaction has been terminated."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningQueryTransaction() {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        monitorSupplier.setTransactionTimeoutMonitor(timeoutMonitor);
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx();){
            fakeClock.forward(3L, TimeUnit.SECONDS);
            timeoutMonitor.run();
            transaction.success();
            database.execute("create (n)");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (TransactionTerminatedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"The transaction has been terminated."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningQueryWithCustomTimeoutWithoutConfiguredDefault() {
        GraphDatabaseAPI database = this.startDatabaseWithoutTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx(5L, TimeUnit.SECONDS);){
            fakeClock.forward(4L, TimeUnit.SECONDS);
            timeoutMonitor.run();
            database.execute("create (n)");
            transaction.failure();
        }
        try {
            transaction = database.beginTx(6L, TimeUnit.SECONDS);
            var4_5 = null;
            try {
                fakeClock.forward(7L, TimeUnit.SECONDS);
                timeoutMonitor.run();
                transaction.success();
                database.execute("create (n)");
                Assert.fail((String)"Transaction should be already terminated.");
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var4_5 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (TransactionTerminatedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"The transaction has been terminated."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningShellQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        GraphDatabaseShellServer shellServer = this.getGraphDatabaseShellServer(database);
        try {
            SameJvmClient client = this.getShellClient(shellServer);
            CollectingOutput commandOutput = new CollectingOutput();
            this.execute(shellServer, commandOutput, client.getId(), "begin Transaction");
            fakeClock.forward(3L, TimeUnit.SECONDS);
            timeoutMonitor.run();
            this.execute(shellServer, commandOutput, client.getId(), "create (n);");
            this.execute(shellServer, commandOutput, client.getId(), "commit");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"The transaction has not completed within the specified timeout (dbms.transaction.timeout)"));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningShellPeriodicCommitQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        monitorSupplier.setTransactionTimeoutMonitor(timeoutMonitor);
        GraphDatabaseShellServer shellServer = this.getGraphDatabaseShellServer(database);
        try {
            SameJvmClient client = this.getShellClient(shellServer);
            CollectingOutput commandOutput = new CollectingOutput();
            URL url = this.prepareTestImportFile(8);
            this.execute(shellServer, commandOutput, client.getId(), "USING PERIODIC COMMIT 5 LOAD CSV FROM '" + url + "' AS line CREATE ();");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"The transaction has been terminated."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningRestTransactionalEndpointQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        OpenEnterpriseNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        String transactionEndPoint = HTTP.POST((String)this.transactionUri(neoServer)).location();
        fakeClock.forward(3L, TimeUnit.SECONDS);
        timeoutMonitor.run();
        HTTP.Response response = HTTP.POST((String)transactionEndPoint, (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)200L, (long)response.status());
        HTTP.Response commitResponse = HTTP.POST((String)(transactionEndPoint + "/commit"));
        Assert.assertEquals((String)"Transaction should be already closed and not found.", (long)404L, (long)commitResponse.status());
        Assert.assertEquals((String)"Transaction should be forcefully closed.", (Object)Status.Transaction.TransactionNotFound.code().serialize(), (Object)commitResponse.get("errors").findValue("code").asText());
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningRestTransactionalEndpointWithCustomTimeoutQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        OpenEnterpriseNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        long customTimeout = TimeUnit.SECONDS.toMillis(10L);
        HTTP.Response beginResponse = HTTP.withHeaders((String[])new String[]{"max-execution-time", String.valueOf(customTimeout)}).POST(this.transactionUri(neoServer), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)201L, (long)beginResponse.status());
        String transactionEndPoint = beginResponse.location();
        fakeClock.forward(3L, TimeUnit.SECONDS);
        HTTP.Response response = HTTP.POST((String)transactionEndPoint, (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)200L, (long)response.status());
        fakeClock.forward(11L, TimeUnit.SECONDS);
        timeoutMonitor.run();
        response = HTTP.POST((String)transactionEndPoint, (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)200L, (long)response.status());
        HTTP.Response commitResponse = HTTP.POST((String)(transactionEndPoint + "/commit"));
        Assert.assertEquals((String)"Transaction should be already closed and not found.", (long)404L, (long)commitResponse.status());
        Assert.assertEquals((String)"Transaction should be forcefully closed.", (Object)Status.Transaction.TransactionNotFound.code().serialize(), (Object)commitResponse.get("errors").findValue("code").asText());
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningDriverQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        OpenEnterpriseNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        Config driverConfig = this.getDriverConfig();
        try (Driver driver = GraphDatabase.driver((String)("bolt://localhost:" + boltPortDatabaseWithTimeout), (Config)driverConfig);
             Session session = driver.session();){
            Transaction transaction = session.beginTransaction();
            transaction.run("create (n)").consume();
            transaction.success();
            fakeClock.forward(3L, TimeUnit.SECONDS);
            timeoutMonitor.run();
            try {
                transaction.run("create (n)").consume();
                Assert.fail((String)"Transaction should be already terminated by execution guard.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningDriverPeriodicCommitQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        monitorSupplier.setTransactionTimeoutMonitor(timeoutMonitor);
        OpenEnterpriseNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        Config driverConfig = this.getDriverConfig();
        try (Driver driver = GraphDatabase.driver((String)("bolt://localhost:" + boltPortDatabaseWithTimeout), (Config)driverConfig);
             Session session = driver.session();){
            URL url = this.prepareTestImportFile(8);
            session.run("USING PERIODIC COMMIT 5 LOAD CSV FROM '" + url + "' AS line CREATE ();").consume();
            Assert.fail((String)"Transaction should be already terminated by execution guard.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void changeTimeoutAtRuntime() {
        Throwable throwable;
        org.neo4j.graphdb.Transaction transaction;
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        KernelTransactionTimeoutMonitor timeoutMonitor = (KernelTransactionTimeoutMonitor)database.getDependencyResolver().resolveDependency(KernelTransactionTimeoutMonitor.class);
        try {
            transaction = database.beginTx();
            throwable = null;
            try {
                fakeClock.forward(3L, TimeUnit.SECONDS);
                timeoutMonitor.run();
                transaction.success();
                database.execute("create (n)");
                Assert.fail((String)"Transaction should be already terminated.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (transaction != null) {
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (TransactionTerminatedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"The transaction has been terminated."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
        transaction = database.beginTx();
        throwable = null;
        try {
            database.execute("CALL dbms.setConfigValue('" + GraphDatabaseSettings.transaction_timeout.name() + "', '5s')");
            transaction.success();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (transaction != null) {
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = database.beginTx();
        throwable = null;
        try {
            fakeClock.forward(3L, TimeUnit.SECONDS);
            timeoutMonitor.run();
            transaction.success();
            database.execute("create (n)");
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (transaction != null) {
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        throwable = null;
        try (org.neo4j.graphdb.Transaction ignored = database.beginTx();){
            Assert.assertEquals((long)1L, (long)database.getAllNodes().stream().count());
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        transaction = database.beginTx();
        throwable = null;
        try {
            database.execute("CALL dbms.setConfigValue('" + GraphDatabaseSettings.transaction_timeout.name() + "', '" + DEFAULT_TIMEOUT + "')");
            try (Stream stream = database.getAllNodes().stream();){
                stream.findFirst().map(node -> {
                    node.delete();
                    return node;
                });
            }
            transaction.success();
        }
        catch (Throwable throwable9) {
            throwable = throwable9;
            throw throwable9;
        }
        finally {
            if (transaction != null) {
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private GraphDatabaseAPI startDatabaseWithTimeout() {
        if (databaseWithTimeout == null) {
            Map<Setting<?>, String> configMap = this.getSettingsWithTimeoutAndBolt();
            databaseWithTimeout = this.startCustomDatabase(testDirectory.directory("dbWithTimeout"), configMap);
            boltPortDatabaseWithTimeout = this.getBoltConnectorPort(databaseWithTimeout);
        }
        return databaseWithTimeout;
    }

    private int getBoltConnectorPort(GraphDatabaseAPI databaseAPI) {
        ConnectorPortRegister connectorPortRegister = (ConnectorPortRegister)databaseAPI.getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return connectorPortRegister.getLocalAddress(BOLT_CONNECTOR_KEY).getPort();
    }

    private GraphDatabaseAPI startDatabaseWithoutTimeout() {
        if (databaseWithoutTimeout == null) {
            Map<Setting<?>, String> configMap = this.getSettingsWithoutTransactionTimeout();
            databaseWithoutTimeout = this.startCustomDatabase(testDirectory.directory("dbWithoutTimeout"), configMap);
        }
        return databaseWithoutTimeout;
    }

    private Config getDriverConfig() {
        return Config.build().withEncryptionLevel(Config.EncryptionLevel.NONE).toConfig();
    }

    private OpenEnterpriseNeoServer startNeoServer(GraphDatabaseFacade database) throws IOException {
        if (neoServer == null) {
            GuardingServerBuilder serverBuilder = new GuardingServerBuilder(database);
            BoltConnector boltConnector = new BoltConnector(BOLT_CONNECTOR_KEY);
            serverBuilder.withProperty(boltConnector.type.name(), "BOLT").withProperty(boltConnector.enabled.name(), "true").withProperty(boltConnector.encryption_level.name(), BoltConnector.EncryptionLevel.DISABLED.name()).withProperty(GraphDatabaseSettings.auth_enabled.name(), "false");
            serverBuilder.withProperty(new HttpConnector((String)"http").listen_address.name(), "localhost:" + PortAuthority.allocatePort());
            neoServer = serverBuilder.build();
            cleanupRule.add((Object)neoServer);
            neoServer.start();
        }
        return neoServer;
    }

    private Map<Setting<?>, String> getSettingsWithTimeoutAndBolt() {
        BoltConnector boltConnector = new BoltConnector(BOLT_CONNECTOR_KEY);
        return MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.transaction_timeout, DEFAULT_TIMEOUT, boltConnector.address, "localhost:0", boltConnector.type, "BOLT", boltConnector.enabled, "true", boltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED.name(), GraphDatabaseSettings.auth_enabled, "false"});
    }

    private Map<Setting<?>, String> getSettingsWithoutTransactionTimeout() {
        return MapUtil.genericMap((Object[])new Object[0]);
    }

    private String transactionUri(OpenEnterpriseNeoServer neoServer) {
        return neoServer.baseUri().toString() + "db/data/transaction";
    }

    private URL prepareTestImportFile(int lines) throws IOException {
        File tempFile = File.createTempFile("testImport", ".csv");
        try (PrintWriter writer = FileUtils.newFilePrintWriter((File)tempFile, (Charset)StandardCharsets.UTF_8);){
            for (int i = 0; i < lines; ++i) {
                writer.println("a,b,c");
            }
        }
        return tempFile.toURI().toURL();
    }

    private Response execute(GraphDatabaseShellServer shellServer, CollectingOutput output, Serializable clientId, String command) throws ShellException {
        return shellServer.interpretLine(clientId, command, (Output)output);
    }

    private SameJvmClient getShellClient(GraphDatabaseShellServer shellServer) throws ShellException, RemoteException {
        SameJvmClient client = new SameJvmClient(new HashMap(), (ShellServer)shellServer, (Output)new CollectingOutput(), (CtrlCHandler)InterruptSignalHandler.getHandler());
        cleanupRule.add((Object)client);
        return client;
    }

    private GraphDatabaseShellServer getGraphDatabaseShellServer(GraphDatabaseAPI database) throws RemoteException {
        GraphDatabaseShellServer shellServer = new GraphDatabaseShellServer(database);
        cleanupRule.add((Object)shellServer);
        return shellServer;
    }

    private void assertDatabaseDoesNotHaveNodes(GraphDatabaseAPI database) {
        try (org.neo4j.graphdb.Transaction ignored = database.beginTx();){
            Assert.assertEquals((long)0L, (long)database.getAllNodes().stream().count());
        }
    }

    private GraphDatabaseAPI startCustomDatabase(File storeDir, Map<Setting<?>, String> configMap) {
        CustomClockEnterpriseFacadeFactory customClockEnterpriseFacadeFactory = new CustomClockEnterpriseFacadeFactory();
        GraphDatabaseBuilder databaseBuilder = new CustomGuardTestTestGraphDatabaseFactory(customClockEnterpriseFacadeFactory).newImpermanentDatabaseBuilder(storeDir);
        configMap.forEach((arg_0, arg_1) -> ((GraphDatabaseBuilder)databaseBuilder).setConfig(arg_0, arg_1));
        databaseBuilder.setConfig(GraphDatabaseSettings.record_id_batch_size, "1");
        GraphDatabaseAPI database = (GraphDatabaseAPI)databaseBuilder.setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        cleanupRule.add((Object)database);
        return database;
    }

    static {
        monitorSupplier = new KernelTransactionTimeoutMonitorSupplier();
        getIdInjectionFunction = new IdInjectionFunctionAction(monitorSupplier);
    }

    private class TerminationIdGenerator
    implements IdGenerator {
        private IdGenerator delegate;

        TerminationIdGenerator(IdGenerator delegate) {
            this.delegate = delegate;
        }

        public IdRange nextIdBatch(int size) {
            return this.delegate.nextIdBatch(size);
        }

        public void setHighId(long id) {
            this.delegate.setHighId(id);
        }

        public long getHighId() {
            return this.delegate.getHighId();
        }

        public long getHighestPossibleIdInUse() {
            return this.delegate.getHighestPossibleIdInUse();
        }

        public void freeId(long id) {
            this.delegate.freeId(id);
        }

        public void close() {
            this.delegate.close();
        }

        public long getNumberOfIdsInUse() {
            return this.delegate.getNumberOfIdsInUse();
        }

        public long getDefragCount() {
            return this.delegate.getDefragCount();
        }

        public void delete() {
            this.delegate.delete();
        }

        public long nextId() {
            getIdInjectionFunction.tickAndCheck();
            return this.delegate.nextId();
        }
    }

    private class TerminationIdGeneratorFactory
    implements IdGeneratorFactory {
        private IdGeneratorFactory delegate;

        TerminationIdGeneratorFactory(IdGeneratorFactory delegate) {
            this.delegate = delegate;
        }

        public IdGenerator open(File filename, IdType idType, LongSupplier highIdSupplier, long maxId) {
            return this.delegate.open(filename, idType, highIdSupplier, maxId);
        }

        public IdGenerator open(File filename, int grabSize, IdType idType, LongSupplier highIdSupplier, long maxId) {
            return new TerminationIdGenerator(this.delegate.open(filename, grabSize, idType, highIdSupplier, maxId));
        }

        public void create(File filename, long highId, boolean throwIfFileExists) {
            this.delegate.create(filename, highId, throwIfFileExists);
        }

        public IdGenerator get(IdType idType) {
            return this.delegate.get(idType);
        }
    }

    private class CustomClockEnterpriseFacadeFactory
    extends GraphDatabaseFacadeFactory {
        CustomClockEnterpriseFacadeFactory() {
            super(DatabaseInfo.ENTERPRISE, (Function)new Function<PlatformModule, EditionModule>(){

                @Override
                public EditionModule apply(PlatformModule platformModule) {
                    return new TransactionGuardTerminationEditionModule(platformModule);
                }
            });
        }

        protected PlatformModule createPlatform(File storeDir, org.neo4j.kernel.configuration.Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
            return new PlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade){

                protected SystemNanoClock createClock() {
                    return fakeClock;
                }
            };
        }
    }

    private class TransactionGuardTerminationEditionModule
    extends EnterpriseEditionModule {
        TransactionGuardTerminationEditionModule(PlatformModule platformModule) {
            super(platformModule);
        }

        protected IdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fs, IdTypeConfigurationProvider idTypeConfigurationProvider) {
            IdGeneratorFactory generatorFactory = super.createIdGeneratorFactory(fs, idTypeConfigurationProvider);
            return new TerminationIdGeneratorFactory(generatorFactory);
        }
    }

    private class CustomGuardTestTestGraphDatabaseFactory
    extends TestGraphDatabaseFactory {
        private GraphDatabaseFacadeFactory customFacadeFactory;

        CustomGuardTestTestGraphDatabaseFactory(GraphDatabaseFacadeFactory customFacadeFactory) {
            this.customFacadeFactory = customFacadeFactory;
        }

        protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final File storeDir, final TestGraphDatabaseFactoryState state) {
            return new GraphDatabaseBuilder.DatabaseCreator(){

                public GraphDatabaseService newDatabase(Map<String, String> config) {
                    return this.newDatabase(org.neo4j.kernel.configuration.Config.defaults(config));
                }

                public GraphDatabaseService newDatabase(org.neo4j.kernel.configuration.Config config) {
                    return CustomGuardTestTestGraphDatabaseFactory.this.customFacadeFactory.newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
                }
            };
        }
    }

    private class GuardingServerBuilder
    extends EnterpriseServerBuilder {
        private GraphDatabaseFacade graphDatabaseFacade;
        final LifecycleManagingDatabase.GraphFactory PRECREATED_FACADE_FACTORY;

        GuardingServerBuilder(GraphDatabaseFacade graphDatabaseAPI) {
            super((LogProvider)NullLogProvider.getInstance());
            this.PRECREATED_FACADE_FACTORY = (config, dependencies) -> this.graphDatabaseFacade;
            this.graphDatabaseFacade = graphDatabaseAPI;
        }

        protected CommunityNeoServer build(File configFile, org.neo4j.kernel.configuration.Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new GuardTestServer(config, dependencies, (LogProvider)NullLogProvider.getInstance());
        }

        private class GuardTestServer
        extends OpenEnterpriseNeoServer {
            GuardTestServer(org.neo4j.kernel.configuration.Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
                super(config, LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)GuardingServerBuilder.this.PRECREATED_FACADE_FACTORY), dependencies, logProvider);
            }
        }
    }

    private static class IdInjectionFunctionAction {
        private final Supplier<KernelTransactionTimeoutMonitor> monitorSupplier;

        IdInjectionFunctionAction(Supplier<KernelTransactionTimeoutMonitor> monitorSupplier) {
            this.monitorSupplier = monitorSupplier;
        }

        void tickAndCheck() {
            KernelTransactionTimeoutMonitor timeoutMonitor = this.monitorSupplier.get();
            if (timeoutMonitor != null) {
                fakeClock.forward(1L, TimeUnit.SECONDS);
                timeoutMonitor.run();
            }
        }
    }

    private static class KernelTransactionTimeoutMonitorSupplier
    implements Supplier<KernelTransactionTimeoutMonitor> {
        private volatile KernelTransactionTimeoutMonitor transactionTimeoutMonitor;

        private KernelTransactionTimeoutMonitorSupplier() {
        }

        void setTransactionTimeoutMonitor(KernelTransactionTimeoutMonitor transactionTimeoutMonitor) {
            this.transactionTimeoutMonitor = transactionTimeoutMonitor;
        }

        @Override
        public KernelTransactionTimeoutMonitor get() {
            return this.transactionTimeoutMonitor;
        }

        public void clear() {
            this.setTransactionTimeoutMonitor(null);
        }
    }
}

