/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslProvider;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.ssl.SecureClient;
import org.neo4j.ssl.SecureServer;
import org.neo4j.ssl.SslContextFactory;
import org.neo4j.ssl.SslResource;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class SslPlatformTest {
    private static final byte[] REQUEST = new byte[]{1, 2, 3, 4};
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private SecureServer server;
    private SecureClient client;
    private ByteBuf expected;

    @Test
    public void shouldSupportOpenSSLOnSupportedPlatforms() throws Exception {
        Assume.assumeTrue((SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX ? 1 : 0) != 0);
        Assume.assumeThat((Object)System.getProperty("os.arch"), (Matcher)Matchers.equalTo((Object)"x86_64"));
        Assume.assumeThat((Object)SystemUtils.JAVA_VENDOR, (Matcher)Matchers.isOneOf((Object[])new String[]{"Oracle Corporation", "Sun Microsystems Inc."}));
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(1).install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("client"));
        this.server = new SecureServer(SslContextFactory.makeSslContext(sslServerResource, true, SslProvider.OPENSSL.name()));
        this.server.start();
        this.client = new SecureClient(SslContextFactory.makeSslContext(sslClientResource, false, SslProvider.OPENSSL.name()));
        this.client.connect(this.server.port());
        ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(REQUEST);
        this.client.channel().writeAndFlush((Object)request);
        this.expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(SecureServer.RESPONSE);
        this.client.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
        this.client.assertResponse(this.expected);
    }
}

