/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.commandline.admin.BlockerLocator;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.PageCacheWarmupTestSupport;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.MetricsTestHelper;
import org.neo4j.metrics.source.db.PageCacheMetrics;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EnterpriseDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.util.concurrent.BinaryLatch;

public class PageCacheWarmupEnterpriseEditionIT
extends PageCacheWarmupTestSupport {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public EnterpriseDatabaseRule db = new EnterpriseDatabaseRule().startLazily();
    private TestDirectory dir = this.db.getTestDirectory();

    private void verifyEventuallyWarmsUp(long pagesInMemory, File metricsDirectory) throws Exception {
        org.neo4j.test.assertion.Assert.assertEventually((String)"Metrics report should include page cache page faults", () -> MetricsTestHelper.readLongValue((File)MetricsTestHelper.metricsCsv((File)metricsDirectory, (String)PageCacheMetrics.PC_PAGE_FAULTS)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesInMemory)), (long)20L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void warmupMustReloadHotPagesAfterRestartAndFaultsMustBeVisibleViaMetrics() throws Exception {
        File metricsDirectory = this.dir.directory("metrics");
        this.db.setConfig(MetricsSettings.metricsEnabled, "false").setConfig(OnlineBackupSettings.online_backup_enabled, "false").setConfig(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms");
        this.db.ensureStarted(new String[0]);
        this.createTestData((GraphDatabaseService)this.db);
        long pagesInMemory = this.waitForCacheProfile((GraphDatabaseAPI)this.db);
        this.db.restartDatabase(new String[]{MetricsSettings.neoPageCacheEnabled.name(), "true", MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "100ms", MetricsSettings.csvPath.name(), metricsDirectory.getAbsolutePath()});
        this.verifyEventuallyWarmsUp(pagesInMemory, metricsDirectory);
    }

    @Test
    public void cacheProfilesMustBeIncludedInOnlineBackups() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        this.db.setConfig(MetricsSettings.metricsEnabled, "false").setConfig(UdcSettings.udc_enabled, "false").setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + backupPort).setConfig(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms");
        this.db.ensureStarted(new String[0]);
        this.createTestData((GraphDatabaseService)this.db);
        long pagesInMemory = this.waitForCacheProfile((GraphDatabaseAPI)this.db);
        BinaryLatch latch = this.pauseProfile((GraphDatabaseAPI)this.db);
        File metricsDirectory = this.dir.cleanDirectory("metrics");
        File backupDir = this.dir.cleanDirectory("backup");
        Assert.assertTrue((boolean)OnlineBackup.from((String)"localhost", (int)backupPort).backup(backupDir).isConsistent());
        latch.release();
        DatabaseRule.RestartAction useBackupDir = (fs, storeDir) -> {
            fs.deleteRecursively(storeDir);
            fs.copyRecursively(backupDir, storeDir);
        };
        this.db.restartDatabase(useBackupDir, new String[]{OnlineBackupSettings.online_backup_enabled.name(), "false", MetricsSettings.neoPageCacheEnabled.name(), "true", MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "100ms", MetricsSettings.csvPath.name(), metricsDirectory.getAbsolutePath()});
        this.verifyEventuallyWarmsUp(pagesInMemory, metricsDirectory);
    }

    @Test
    public void cacheProfilesMustNotInterfereWithOnlineBackups() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        this.db.setConfig(MetricsSettings.metricsEnabled, "false").setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + backupPort).setConfig(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "1ms");
        this.db.ensureStarted(new String[0]);
        this.createTestData((GraphDatabaseService)this.db);
        this.waitForCacheProfile((GraphDatabaseAPI)this.db);
        for (int i = 0; i < 20; ++i) {
            String backupDir = this.dir.cleanDirectory("backup").getAbsolutePath();
            Assert.assertTrue((boolean)OnlineBackup.from((String)"localhost", (int)backupPort).full(backupDir).isConsistent());
        }
    }

    @Test
    public void cacheProfilesMustBeIncludedInOfflineBackups() throws Exception {
        this.db.setConfig(MetricsSettings.metricsEnabled, "false").setConfig(OnlineBackupSettings.online_backup_enabled, "false").setConfig(GraphDatabaseSettings.pagecache_warmup_profiling_interval, "100ms");
        this.db.ensureStarted(new String[0]);
        this.createTestData((GraphDatabaseService)this.db);
        long pagesInMemory = this.waitForCacheProfile((GraphDatabaseAPI)this.db);
        this.db.shutdownAndKeepStore();
        AdminTool adminTool = new AdminTool(CommandLocator.fromServiceLocator(), BlockerLocator.fromServiceLocator(), (OutsideWorld)new RealOutsideWorld(){

            public void exit(int status) {
                Assert.assertThat((String)"exit code", (Object)status, (Matcher)Matchers.is((Object)0));
            }
        }, true);
        File storeDir = this.db.getStoreDir();
        File data = this.dir.cleanDirectory("data");
        File databases = new File(data, "databases");
        File graphdb = new File(databases, "graph.db");
        Assert.assertTrue((boolean)graphdb.mkdirs());
        FileUtils.copyRecursively((File)storeDir, (File)graphdb);
        FileUtils.deleteRecursively((File)storeDir);
        Path homePath = data.toPath().getParent();
        File dumpDir = this.dir.cleanDirectory("dump-dir");
        adminTool.execute(homePath, homePath, new String[]{"dump", "--database=graph.db", "--to=" + dumpDir});
        FileUtils.deleteRecursively((File)graphdb);
        File dumpFile = new File(dumpDir, "graph.db.dump");
        adminTool.execute(homePath, homePath, new String[]{"load", "--database=graph.db", "--from=" + dumpFile});
        FileUtils.copyRecursively((File)graphdb, (File)storeDir);
        FileUtils.deleteRecursively((File)graphdb);
        File metricsDirectory = this.dir.cleanDirectory("metrics");
        this.db.ensureStarted(new String[]{OnlineBackupSettings.online_backup_enabled.name(), "false", MetricsSettings.neoPageCacheEnabled.name(), "true", MetricsSettings.csvEnabled.name(), "true", MetricsSettings.csvInterval.name(), "100ms", MetricsSettings.csvPath.name(), metricsDirectory.getAbsolutePath()});
        this.verifyEventuallyWarmsUp(pagesInMemory, metricsDirectory);
    }
}

