/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.NullOutputStream;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.TestDirectory;

public class HalfCreatedConstraintIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void uniqueIndexWithoutOwningConstraintIsIgnoredDuringCheck() throws ConsistencyCheckTool.ToolFailureException, IOException {
        File storeDir = this.testDirectory.graphDbDir();
        Label marker = Label.label((String)"MARKER");
        String property = "property";
        GraphDatabaseService database = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try {
            this.createNodes(marker, property, database);
            this.addIndex(database);
            this.waitForIndexPopulationFailure(database);
        }
        finally {
            database.shutdown();
        }
        ConsistencyCheckService.Result checkResult = ConsistencyCheckTool.runConsistencyCheckTool((String[])new String[]{storeDir.getAbsolutePath()}, (PrintStream)HalfCreatedConstraintIT.emptyPrintStream(), (PrintStream)HalfCreatedConstraintIT.emptyPrintStream());
        Assert.assertTrue((String)String.join((CharSequence)System.lineSeparator(), Files.readAllLines(checkResult.reportFile().toPath())), (boolean)checkResult.isSuccessful());
    }

    private void waitForIndexPopulationFailure(GraphDatabaseService database) {
        try (Transaction ignored = database.beginTx();){
            database.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
            Assert.fail((String)"Unique index population should fail.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Index entered a FAILED state. Please see database logs.", (Object)e.getMessage());
        }
    }

    private void addIndex(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            ThreadToStatementContextBridge statementBridge = (ThreadToStatementContextBridge)((GraphDatabaseAPI)database).getDependencyResolver().provideDependency(ThreadToStatementContextBridge.class).get();
            KernelTransaction kernelTransaction = statementBridge.getKernelTransactionBoundToThisThread(true);
            LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
            SchemaIndexDescriptor index = SchemaIndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor);
            ((KernelTransactionImplementation)kernelTransaction).txState().indexRuleDoAdd(index);
            transaction.success();
        }
    }

    private void createNodes(Label marker, String property, GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            for (int i = 0; i < 10; ++i) {
                Node node = database.createNode(new Label[]{marker});
                node.setProperty(property, (Object)"a");
            }
            transaction.success();
        }
    }

    private static PrintStream emptyPrintStream() {
        return new PrintStream(NullOutputStream.NULL_OUTPUT_STREAM);
    }
}

