/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.ssl.SecureClient;
import org.neo4j.ssl.SslContextFactory;
import org.neo4j.ssl.SslResource;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class BoltTlsIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private SslPolicyConfig sslPolicy = new SslPolicyConfig("bolt");
    private GraphDatabaseAPI db;
    private SslResource sslResource;
    private BoltConnector bolt = new BoltConnector("bolt");
    @Parameterized.Parameter
    public TestSetup setup;

    @Before
    public void setup() throws IOException {
        File sslObjectsDir = new File(this.testDirectory.graphDbDir(), "certificates");
        Assert.assertTrue((boolean)sslObjectsDir.mkdirs());
        this.sslResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(0).install(sslObjectsDir);
        this.createAndStartDb();
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[] params() {
        return new TestSetup[]{new TestSetup("TLSv1.1", "TLSv1.2", false), new TestSetup("TLSv1.2", "TLSv1.1", false), new TestSetup("TLSv1", "TLSv1.1", false), new TestSetup("TLSv1.1", "TLSv1.2", false), new TestSetup("TLSv1", "TLSv1", true), new TestSetup("TLSv1.1", "TLSv1.1", true), new TestSetup("TLSv1.2", "TLSv1.2", true), new TestSetup("SSLv3,TLSv1", "TLSv1.1,TLSv1.2", false), new TestSetup("TLSv1.1,TLSv1.2", "TLSv1.1,TLSv1.2", true)};
    }

    private void createAndStartDb() {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(this.bolt.enabled, "true").setConfig(this.bolt.listen_address, ":" + PortAuthority.allocatePort()).setConfig(BoltKernelExtension.Settings.ssl_policy, "bolt").setConfig(this.sslPolicy.allow_key_generation, "true").setConfig(this.sslPolicy.base_directory, "certificates").setConfig(this.sslPolicy.tls_versions, this.setup.boltTlsVersions).setConfig(this.sslPolicy.client_auth, "none").newGraphDatabase();
    }

    @After
    public void teardown() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void shouldRespectProtocolSelection() throws Exception {
        Config config = (Config)this.db.getDependencyResolver().resolveDependency(Config.class);
        int boltPort = ((AdvertisedSocketAddress)config.get(this.bolt.advertised_address)).getPort();
        SslContextFactory.SslParameters params = SslContextFactory.SslParameters.protocols(this.setup.clientTlsVersions).ciphers(new String[0]);
        SecureClient client = new SecureClient(SslContextFactory.makeSslContext(this.sslResource, false, params));
        client.connect(boltPort);
        Assert.assertTrue((boolean)client.sslHandshakeFuture().await(1L, TimeUnit.MINUTES));
        if (this.setup.shouldSucceed) {
            Assert.assertNull((Object)client.sslHandshakeFuture().cause());
        } else {
            Assert.assertNotNull((Object)client.sslHandshakeFuture().cause());
        }
    }

    static class TestSetup {
        private final String clientTlsVersions;
        private final String boltTlsVersions;
        private final boolean shouldSucceed;

        TestSetup(String clientTlsVersions, String boltTlsVersion, boolean shouldSucceed) {
            this.clientTlsVersions = clientTlsVersions;
            this.boltTlsVersions = boltTlsVersion;
            this.shouldSucceed = shouldSucceed;
        }

        public String toString() {
            return "TestSetup{clientTlsVersions='" + this.clientTlsVersions + '\'' + ", boltTlsVersions='" + this.boltTlsVersions + '\'' + ", shouldSucceed=" + this.shouldSucceed + '}';
        }
    }
}

