/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.configuration.ssl.SslSystemSettings;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.ssl.SslResource;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class SecureCommunicationsTest {
    private static final int UNRELATED_ID = 5;
    private static final byte[] REQUEST = new byte[]{1, 2, 3, 4};
    private static final byte[] RESPONSE = new byte[]{5, 6, 7, 8};
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private SecureServer server;
    private SecureClient client;
    private ByteBuf expected;

    @After
    public void cleanup() {
        if (this.expected != null) {
            this.expected.release();
        }
        if (this.client != null) {
            this.client.disconnect();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void partiesWithMutualTrustShouldCommunicate() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(1).install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("client"));
        this.server = new SecureServer(this.makeSslContext(sslServerResource, true));
        this.server.start();
        this.client = new SecureClient(this.makeSslContext(sslClientResource, false));
        this.client.connect(this.server.port());
        ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(REQUEST);
        this.client.channel.writeAndFlush((Object)request);
        this.expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(RESPONSE);
        this.client.clientInitializer.handshakeFuture.get();
        this.client.assertResponse(this.expected);
    }

    @Test
    public void partiesWithMutualTrustThroughCAShouldCommunicate() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.caSignedKeyId((int)0).trustSignedByCA().install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.caSignedKeyId((int)1).trustSignedByCA().install(this.testDir.directory("client"));
        this.server = new SecureServer(this.makeSslContext(sslServerResource, true));
        this.server.start();
        this.client = new SecureClient(this.makeSslContext(sslClientResource, false));
        this.client.connect(this.server.port());
        ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(REQUEST);
        this.client.channel.writeAndFlush((Object)request);
        this.expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(RESPONSE);
        this.client.clientInitializer.handshakeFuture.get();
        this.client.assertResponse(this.expected);
    }

    @Test
    public void serverShouldNotCommunicateWithUntrustedClient() throws Exception {
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("client"));
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(5).install(this.testDir.directory("server"));
        this.server = new SecureServer(this.makeSslContext(sslServerResource, true));
        this.server.start();
        this.client = new SecureClient(this.makeSslContext(sslClientResource, false));
        this.client.connect(this.server.port());
        try {
            this.client.clientInitializer.handshakeFuture.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }

    @Test
    public void clientShouldNotCommunicateWithUntrustedServer() throws Exception {
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(5).install(this.testDir.directory("client"));
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("server"));
        this.server = new SecureServer(this.makeSslContext(sslServerResource, true));
        this.server.start();
        this.client = new SecureClient(this.makeSslContext(sslClientResource, false));
        this.client.connect(this.server.port());
        try {
            this.client.clientInitializer.handshakeFuture.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }

    @Test
    public void partiesWithMutualTrustThroughCAShouldNotCommunicateWhenServerRevoked() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.caSignedKeyId((int)0).trustSignedByCA().install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.caSignedKeyId((int)1).trustSignedByCA().revoke(0).install(this.testDir.directory("client"));
        this.server = new SecureServer(this.makeSslContext(sslServerResource, true));
        this.server.start();
        this.client = new SecureClient(this.makeSslContext(sslClientResource, false));
        this.client.connect(this.server.port());
        try {
            this.client.clientInitializer.handshakeFuture.get();
            Assert.fail((String)"Server should have been revoked");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }

    @Test
    public void partiesWithMutualTrustThroughCAShouldNotCommunicateWhenClientRevoked() throws Exception {
        SslResource sslServerResource = SslResourceBuilder.caSignedKeyId((int)0).trustSignedByCA().revoke(1).install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.caSignedKeyId((int)1).trustSignedByCA().install(this.testDir.directory("client"));
        this.server = new SecureServer(this.makeSslContext(sslServerResource, true));
        this.server.start();
        this.client = new SecureClient(this.makeSslContext(sslClientResource, false));
        this.client.connect(this.server.port());
        try {
            this.client.clientInitializer.handshakeFuture.get();
            Assert.fail((String)"Client should have been revoked");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
        }
    }

    @Test
    public void shouldSupportOpenSSLOnSupportedPlatforms() throws Exception {
        Assume.assumeTrue((SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX ? 1 : 0) != 0);
        Assume.assumeThat((Object)System.getProperty("os.arch"), (Matcher)Matchers.equalTo((Object)"x86_64"));
        Assume.assumeThat((Object)SystemUtils.JAVA_VENDOR, (Matcher)Matchers.isOneOf((Object[])new String[]{"Oracle Corporation", "Sun Microsystems Inc."}));
        SslResource sslServerResource = SslResourceBuilder.selfSignedKeyId((int)0).trustKeyId(1).install(this.testDir.directory("server"));
        SslResource sslClientResource = SslResourceBuilder.selfSignedKeyId((int)1).trustKeyId(0).install(this.testDir.directory("client"));
        this.server = new SecureServer(this.makeSslContext(sslServerResource, true, SslProvider.OPENSSL.name()));
        this.server.start();
        this.client = new SecureClient(this.makeSslContext(sslClientResource, false, SslProvider.OPENSSL.name()));
        this.client.connect(this.server.port());
        ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(REQUEST);
        this.client.channel.writeAndFlush((Object)request);
        this.expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(RESPONSE);
        this.client.clientInitializer.handshakeFuture.get();
        this.client.assertResponse(this.expected);
    }

    private SslContext makeSslContext(SslResource sslResource, boolean forServer) throws IOException {
        return this.makeSslContext(sslResource, forServer, SslProvider.JDK.name());
    }

    private SslContext makeSslContext(SslResource sslResource, boolean forServer, String sslProvider) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(SslSystemSettings.netty_ssl_provider.name(), sslProvider);
        SslPolicyConfig policyConfig = new SslPolicyConfig("default");
        File baseDirectory = sslResource.privateKey().getParentFile();
        new File(baseDirectory, "trusted").mkdirs();
        new File(baseDirectory, "revoked").mkdirs();
        config.put(policyConfig.base_directory.name(), baseDirectory.getPath());
        config.put(policyConfig.private_key.name(), sslResource.privateKey().getPath());
        config.put(policyConfig.public_certificate.name(), sslResource.publicCertificate().getPath());
        config.put(policyConfig.trusted_dir.name(), sslResource.trustedDirectory().getPath());
        config.put(policyConfig.revoked_dir.name(), sslResource.revokedDirectory().getPath());
        SslPolicyLoader sslPolicyFactory = SslPolicyLoader.create((Config)Config.fromSettings(config).build(), (LogProvider)NullLogProvider.getInstance());
        SslPolicy sslPolicy = sslPolicyFactory.getPolicy("default");
        return forServer ? sslPolicy.nettyServerContext() : sslPolicy.nettyClientContext();
    }

    private class Responder
    extends SimpleChannelInboundHandler<ByteBuf> {
        private Responder() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            ctx.channel().writeAndFlush((Object)ctx.alloc().buffer().writeBytes(RESPONSE));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        }
    }

    class Bucket
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final ByteBuf collectedData = ByteBufAllocator.DEFAULT.buffer();

        Bucket() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            this.collectedData.writeBytes(msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        }
    }

    public class ClientInitializer
    extends ChannelInitializer<SocketChannel> {
        SslContext sslContext;
        private final Bucket bucket;
        private Future<Channel> handshakeFuture;

        ClientInitializer(SslContext sslContext, Bucket bucket) {
            this.sslContext = sslContext;
            this.bucket = bucket;
        }

        protected void initChannel(SocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            SSLEngine sslEngine = this.sslContext.newEngine(channel.alloc());
            sslEngine.setUseClientMode(true);
            SslHandler sslHandler = new SslHandler(sslEngine);
            this.handshakeFuture = sslHandler.handshakeFuture();
            pipeline.addLast(new ChannelHandler[]{sslHandler});
            pipeline.addLast(new ChannelHandler[]{this.bucket});
        }
    }

    private class SecureClient {
        ClientInitializer clientInitializer;
        Bootstrap bootstrap;
        NioEventLoopGroup eventLoopGroup;
        Channel channel;
        Bucket bucket;

        SecureClient(SslContext sslContext) {
            this.bucket = new Bucket();
            this.eventLoopGroup = new NioEventLoopGroup();
            this.clientInitializer = new ClientInitializer(sslContext, this.bucket);
            this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.clientInitializer);
        }

        void connect(int port) {
            ChannelFuture channelFuture = this.bootstrap.connect("localhost", port).awaitUninterruptibly();
            this.channel = channelFuture.channel();
        }

        void disconnect() {
            if (this.channel != null) {
                this.channel.close().awaitUninterruptibly();
                this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            }
            this.bucket.collectedData.release();
        }

        void assertResponse(ByteBuf expected) throws InterruptedException {
            org.neo4j.test.assertion.Assert.assertEventually((String)this.channel.toString(), () -> this.bucket.collectedData, (Matcher)Matchers.equalTo((Object)expected), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private class SecureServer {
        SslContext sslContext;
        Channel channel;
        NioEventLoopGroup eventLoopGroup;

        SecureServer(SslContext sslContext) {
            this.sslContext = sslContext;
        }

        private void start() {
            this.eventLoopGroup = new NioEventLoopGroup();
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).localAddress(0)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    SSLEngine sslEngine = SecureServer.this.sslContext.newEngine(ch.alloc());
                    sslEngine.setNeedClientAuth(true);
                    SslHandler sslHandler = new SslHandler(sslEngine);
                    pipeline.addLast(new ChannelHandler[]{sslHandler});
                    pipeline.addLast(new ChannelHandler[]{new Responder()});
                }
            });
            this.channel = bootstrap.bind().syncUninterruptibly().channel();
        }

        private void stop() {
            this.channel.close().awaitUninterruptibly();
            this.channel = null;
            this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        private int port() {
            return ((InetSocketAddress)this.channel.localAddress()).getPort();
        }
    }
}

