/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.proc.JarBuilder;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.StringMatcherIgnoresNewlines;
import org.neo4j.procedure.UserFunction;
import org.neo4j.test.TestGraphDatabaseFactory;

public class UserFunctionIT {
    @Rule
    public TemporaryFolder plugins = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static List<Exception> exceptionsInFunction = Collections.synchronizedList(new ArrayList());
    private GraphDatabaseService db;
    private static final ScheduledExecutorService jobs = Executors.newScheduledThreadPool(5);

    @Test
    public void shouldGiveNiceErrorMessageOnWrongStaticType() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Type mismatch: expected Integer but was String (line 1, column 43 (offset: 42))");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.simpleArgument('42')");
        }
    }

    @Test
    public void shouldGiveNiceErrorMessageWhenNoArguments() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage(StringMatcherIgnoresNewlines.containsStringIgnoreNewlines(String.format("Function call does not provide the required number of arguments: expected 1 got 0.%n%nFunction org.neo4j.procedure.simpleArgument has signature: org.neo4j.procedure.simpleArgument(someValue :: INTEGER?) :: INTEGER?%nmeaning that it expects 1 argument of type INTEGER? (line 1, column 8 (offset: 7))", new Object[0])));
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.simpleArgument()");
        }
    }

    @Test
    public void shouldShowDescriptionWhenMissingArguments() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage(StringMatcherIgnoresNewlines.containsStringIgnoreNewlines(String.format("Function call does not provide the required number of arguments: expected 1 got 0.%n%nFunction org.neo4j.procedure.nodeWithDescription has signature: org.neo4j.procedure.nodeWithDescription(someValue :: NODE?) :: NODE?%nmeaning that it expects 1 argument of type NODE?%nDescription: This is a description (line 1, column 8 (offset: 7))", new Object[0])));
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.nodeWithDescription()");
        }
    }

    @Test
    public void shouldCallDelegatingFunction() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.delegatingFunction({name}) AS someVal", MapUtil.map((Object[])new Object[]{"name", 43L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 43L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallRecursiveFunction() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.recursiveSum({order}) AS someVal", MapUtil.map((Object[])new Object[]{"order", 10L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 55L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallFunctionWithGenericArgument() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.genericArguments([ ['graphs'], ['are'], ['everywhere']], [ [[1, 2, 3]], [[4, 5]]] ) AS someVal");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 5L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallFunctionWithMapArgument() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.mapArgument({foo: 42, bar: 'hello'}) AS someVal");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 2L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallFunctionWithMapArgumentContainingNullFromParameter() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.mapArgument({foo: $p}) AS someVal", MapUtil.map((Object[])new Object[]{"p", null}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 1L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallFunctionWithNull() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.mapArgument(null) AS someVal");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 0L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallFunctionWithNullFromParameter() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.mapArgument($p) AS someVal", MapUtil.map((Object[])new Object[]{"p", null}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 0L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallFunctionWithNodeReturn() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            long nodeId = this.db.createNode().getId();
            Result res = this.db.execute("RETURN org.neo4j.procedure.node({id}) AS node", MapUtil.map((Object[])new Object[]{"id", nodeId}));
            Node node = (Node)res.next().get("node");
            MatcherAssert.assertThat((Object)node.getId(), (Matcher)IsEqual.equalTo((Object)nodeId));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldGiveHelpfulErrorOnMissingFunction() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage(String.format("Unknown function 'org.someFunctionThatDoesNotExist' (line 1, column 8 (offset: 7))%n\"RETURN org.someFunctionThatDoesNotExist()", new Object[0]));
        this.db.execute("RETURN org.someFunctionThatDoesNotExist()");
    }

    @Test
    public void shouldGiveHelpfulErrorOnExceptionMidStream() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result result = this.db.execute("RETURN org.neo4j.procedure.throwsExceptionInStream()");
            this.exception.expect(QueryExecutionException.class);
            this.exception.expectMessage("Failed to invoke function `org.neo4j.procedure.throwsExceptionInStream`: Caused by: java.lang.RuntimeException: Kaboom");
            result.next();
        }
    }

    @Test
    public void shouldShowCauseOfError() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            this.exception.expect(QueryExecutionException.class);
            this.exception.expectMessage("Failed to invoke function `org.neo4j.procedure.indexOutOfBounds`: Caused by: java.lang.ArrayIndexOutOfBoundsException");
            this.db.execute("RETURN org.neo4j.procedure.indexOutOfBounds()").next();
        }
    }

    @Test
    public void shouldCallFunctionWithAccessToDB() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")}).setProperty("name", (Object)"Buddy Holly");
            tx.success();
        }
        var2_2 = null;
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.listCoolPeopleInDatabase() AS cool");
            Assert.assertEquals(res.next().get("cool"), Collections.singletonList("Buddy Holly"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldLogLikeThereIsNoTomorrow() throws Throwable {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.db.shutdown();
        this.db = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)logProvider).setUserLogProvider((LogProvider)logProvider).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.plugin_dir, this.plugins.getRoot().getAbsolutePath()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.logAround()");
            while (res.hasNext()) {
                res.next();
            }
        }
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(Procedures.class);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{match.debug("1"), match.info("2"), match.warn("3"), match.error("4")});
    }

    @Test
    public void shouldDenyReadOnlyFunctionToPerformWrites() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Write operations are not allowed");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.readOnlyTryingToWrite()").next();
        }
    }

    @Test
    public void shouldNotBeAbleToCallWriteProcedureThroughReadFunction() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Write operations are not allowed");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.readOnlyCallingWriteProcedure()").next();
        }
    }

    @Test
    public void shouldDenyReadOnlyFunctionToPerformSchema() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Schema operations are not allowed");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.readOnlyTryingToWriteSchema()").next();
        }
    }

    @Test
    public void shouldCoerceLongToDoubleAtRuntimeWhenCallingFunction() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.squareDouble({value}) AS result", MapUtil.map((Object[])new Object[]{"value", 4L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"result", 16.0})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCoerceListOfNumbersToDoublesAtRuntimeWhenCallingFunction() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.avgNumberList({param}) AS result", MapUtil.map((Object[])new Object[]{"param", Arrays.asList(1L, 2L, 3L)}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"result", 2.0})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCoerceListOfMixedNumbers() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.avgDoubleList([{long}, {double}]) AS result", MapUtil.map((Object[])new Object[]{"long", 1L, "double", 2.0}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"result", 1.5})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCoerceDoubleToLongAtRuntimeWhenCallingFunction() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("RETURN org.neo4j.procedure.squareLong({value}) as someVal", MapUtil.map((Object[])new Object[]{"value", 4L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 16L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldBeAbleToPerformWritesOnNodesReturnedFromReadOnlyFunction() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            long nodeId = this.db.createNode().getId();
            Node node = (Node)Iterators.single((Iterator)this.db.execute("RETURN org.neo4j.procedure.node({id}) AS node", MapUtil.map((Object[])new Object[]{"id", nodeId})).columnAs("node"));
            node.setProperty("name", (Object)"Stefan");
            tx.success();
        }
    }

    @Test
    public void shouldFailToShutdown() {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Failed to invoke function `org.neo4j.procedure.shutdown`: Caused by: java.lang.UnsupportedOperationException");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.shutdown()").next();
        }
    }

    @Test
    public void shouldBeAbleToWriteAfterCallingReadOnlyFunction() {
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("RETURN org.neo4j.procedure.simpleArgument(12)").close();
            this.db.createNode();
        }
    }

    @Test
    public void shouldPreserveSecurityContextWhenSpawningThreadsCreatingTransactionInFunctions() throws Throwable {
        int i;
        Runnable doIt = () -> {
            Result result = this.db.execute("RETURN org.neo4j.procedure.unsupportedFunction()");
            result.resultAsString();
            result.close();
        };
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(doIt);
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
        Predicates.await(() -> exceptionsInFunction.size() >= numThreads, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        for (Exception exceptionInFunction : exceptionsInFunction) {
            MatcherAssert.assertThat((String)Exceptions.stringify((Throwable)exceptionInFunction), (Object)exceptionInFunction, (Matcher)Matchers.instanceOf(AuthorizationViolationException.class));
            MatcherAssert.assertThat((String)Exceptions.stringify((Throwable)exceptionInFunction), (Object)exceptionInFunction.getMessage(), (Matcher)Matchers.startsWith((String)"Write operations are not allowed"));
        }
        Result result = this.db.execute("MATCH () RETURN count(*) as n");
        MatcherAssert.assertThat((Object)result.hasNext(), (Matcher)IsEqual.equalTo((Object)true));
        while (result.hasNext()) {
            MatcherAssert.assertThat(result.next().get("n"), (Matcher)IsEqual.equalTo((Object)0L));
        }
        result.close();
    }

    @Test
    public void shouldBeAbleToUseFunctionCallWithPeriodicCommit() throws IOException {
        String[] lines = (String[])IntStream.rangeClosed(1, 100).boxed().map(i -> Integer.toString(i)).toArray(String[]::new);
        String url = this.createCsvFile(lines);
        Result result = this.db.execute("USING PERIODIC COMMIT 1 LOAD CSV FROM '" + url + "' AS line CREATE (n {prop: org.neo4j.procedure.simpleArgument(toInt(line[0]))}) RETURN n.prop");
        for (long i2 = 1L; i2 <= 100L; ++i2) {
            MatcherAssert.assertThat(result.next().get("n.prop"), (Matcher)IsEqual.equalTo((Object)i2));
        }
        String[] dbContents = (String[])this.db.execute("MATCH (n) return n.prop").stream().map(m -> Long.toString((Long)m.get("n.prop"))).toArray(String[]::new);
        MatcherAssert.assertThat((Object)dbContents, (Matcher)IsEqual.equalTo((Object)lines));
    }

    @Test
    public void shouldFailIfUsingPeriodicCommitWithReadOnlyQuery() throws IOException {
        String url = this.createCsvFile("13");
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Cannot use periodic commit in a non-updating query (line 1, column 1 (offset: 0))");
        this.db.execute("USING PERIODIC COMMIT 1 LOAD CSV FROM '" + url + "' AS line WITH org.neo4j.procedure.simpleArgument(toInt(line[0])) AS val RETURN val");
    }

    @Test
    public void shouldCallFunctionReturningPaths() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Node node1 = this.db.createNode();
            Node node2 = this.db.createNode();
            Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"KNOWS"));
            Result res = this.db.execute("RETURN org.neo4j.procedure.nodePaths({node}) AS path", MapUtil.map((Object[])new Object[]{"node", node1}));
            Assert.assertTrue((boolean)res.hasNext());
            Map value = res.next();
            Path path = (Path)value.get("path");
            MatcherAssert.assertThat((Object)path.length(), (Matcher)IsEqual.equalTo((Object)1));
            MatcherAssert.assertThat((Object)path.startNode(), (Matcher)IsEqual.equalTo((Object)node1));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)path.relationships()), (Matcher)IsEqual.equalTo(Collections.singletonList(rel)));
            MatcherAssert.assertThat((Object)path.endNode(), (Matcher)IsEqual.equalTo((Object)node2));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    private String createCsvFile(String ... lines) throws IOException {
        File file = this.plugins.newFile();
        try (PrintWriter writer = FileUtils.newFilePrintWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            for (String line : lines) {
                writer.println(line);
            }
        }
        return file.toURI().toURL().toString();
    }

    @Test
    public void shouldHandleAggregationFunctionInFunctionCall() {
        try (Transaction ignore = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            Assert.assertEquals(this.db.execute("MATCH (n:Person) RETURN org.neo4j.procedure.nodeListArgument(collect(n)) AS someVal").next().get("someVal"), (Object)2L);
        }
    }

    @Test
    public void shouldHandleNullInList() {
        try (Transaction ignore = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            Assert.assertEquals(this.db.execute("MATCH (n:Person) RETURN org.neo4j.procedure.nodeListArgument([n, null]) AS someVal").next().get("someVal"), (Object)1L);
        }
    }

    @Test
    public void shouldWorkWhenUsingWithToProjectList() {
        try (Transaction ignore = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            Result res = this.db.execute("MATCH (n:Person) WITH collect(n) as persons RETURN org.neo4j.procedure.nodeListArgument(persons) AS someVal");
            MatcherAssert.assertThat(res.next().get("someVal"), (Matcher)IsEqual.equalTo((Object)2L));
        }
    }

    @Test
    public void shouldNotAllowReadFunctionInNoneTransaction() throws Throwable {
        this.exception.expect(AuthorizationViolationException.class);
        this.exception.expectMessage("Read operations are not allowed");
        GraphDatabaseAPI gdapi = (GraphDatabaseAPI)this.db;
        try (InternalTransaction tx = gdapi.beginTransaction(Transaction.Type.explicit, (SecurityContext)AnonymousContext.none());){
            this.db.execute("RETURN org.neo4j.procedure.integrationTestMe()").next();
            tx.success();
        }
    }

    @Test
    public void shouldCallProcedureWithAllDefaultArgument() throws Throwable {
        Result res = this.db.execute("RETURN org.neo4j.procedure.defaultValues() AS result");
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo((Object)"a string,42,3.14,true"));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldHandleNullAsParameter() throws Throwable {
        Result res = this.db.execute("RETURN org.neo4j.procedure.defaultValues($p) AS result", MapUtil.map((Object[])new Object[]{"p", null}));
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo((Object)"null,42,3.14,true"));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallFunctionWithOneProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("RETURN org.neo4j.procedure.defaultValues('another string') AS result");
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo((Object)"another string,42,3.14,true"));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallFunctionWithTwoProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("RETURN org.neo4j.procedure.defaultValues('another string', 1337) AS result");
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo((Object)"another string,1337,3.14,true"));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallFunctionWithThreeProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("RETURN org.neo4j.procedure.defaultValues('another string', 1337, 2.718281828) AS result");
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo((Object)"another string,1337,2.72,true"));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallFunctionWithFourProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("RETURN org.neo4j.procedure.defaultValues('another string', 1337, 2.718281828, false) AS result");
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo((Object)"another string,1337,2.72,false"));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallFunctionReturningNull() throws Throwable {
        Result res = this.db.execute("RETURN org.neo4j.procedure.node(-1) AS result");
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo(null));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldListAllUserDefinedFunctions() throws Throwable {
        Result res = this.db.execute("CALL dbms.functions()");
        String expected = String.format("+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+%n| name                                                | signature                                                                                                                                                    | description                |%n+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+%n| \"org.neo4j.procedure.avgDoubleList\"                 | \"org.neo4j.procedure.avgDoubleList(someValue :: LIST? OF FLOAT?) :: (FLOAT?)\"                                                                                | \"\"                         |%n| \"org.neo4j.procedure.avgNumberList\"                 | \"org.neo4j.procedure.avgNumberList(someValue :: LIST? OF NUMBER?) :: (FLOAT?)\"                                                                               | \"\"                         |%n| \"org.neo4j.procedure.defaultValues\"                 | \"org.neo4j.procedure.defaultValues(string = a string :: STRING?, integer = 42 :: INTEGER?, float = 3.14 :: FLOAT?, boolean = true :: BOOLEAN?) :: (STRING?)\" | \"\"                         |%n| \"org.neo4j.procedure.delegatingFunction\"            | \"org.neo4j.procedure.delegatingFunction(someValue :: INTEGER?) :: (INTEGER?)\"                                                                                | \"\"                         |%n| \"org.neo4j.procedure.genericArguments\"              | \"org.neo4j.procedure.genericArguments(strings :: LIST? OF LIST? OF STRING?, longs :: LIST? OF LIST? OF LIST? OF INTEGER?) :: (INTEGER?)\"                     | \"\"                         |%n| \"org.neo4j.procedure.indexOutOfBounds\"              | \"org.neo4j.procedure.indexOutOfBounds() :: (INTEGER?)\"                                                                                                       | \"\"                         |%n| \"org.neo4j.procedure.integrationTestMe\"             | \"org.neo4j.procedure.integrationTestMe() :: (INTEGER?)\"                                                                                                      | \"\"                         |%n| \"org.neo4j.procedure.listCoolPeopleInDatabase\"      | \"org.neo4j.procedure.listCoolPeopleInDatabase() :: (LIST? OF ANY?)\"                                                                                          | \"\"                         |%n| \"org.neo4j.procedure.logAround\"                     | \"org.neo4j.procedure.logAround() :: (INTEGER?)\"                                                                                                              | \"\"                         |%n| \"org.neo4j.procedure.mapArgument\"                   | \"org.neo4j.procedure.mapArgument(map :: MAP?) :: (INTEGER?)\"                                                                                                 | \"\"                         |%n| \"org.neo4j.procedure.node\"                          | \"org.neo4j.procedure.node(id :: INTEGER?) :: (NODE?)\"                                                                                                        | \"\"                         |%n| \"org.neo4j.procedure.nodeListArgument\"              | \"org.neo4j.procedure.nodeListArgument(nodes :: LIST? OF NODE?) :: (INTEGER?)\"                                                                                | \"\"                         |%n| \"org.neo4j.procedure.nodePaths\"                     | \"org.neo4j.procedure.nodePaths(someValue :: NODE?) :: (PATH?)\"                                                                                               | \"\"                         |%n| \"org.neo4j.procedure.nodeWithDescription\"           | \"org.neo4j.procedure.nodeWithDescription(someValue :: NODE?) :: (NODE?)\"                                                                                     | \"This is a description\"    |%n| \"org.neo4j.procedure.readOnlyCallingWriteFunction\"  | \"org.neo4j.procedure.readOnlyCallingWriteFunction() :: (NODE?)\"                                                                                              | \"\"                         |%n| \"org.neo4j.procedure.readOnlyCallingWriteProcedure\" | \"org.neo4j.procedure.readOnlyCallingWriteProcedure() :: (INTEGER?)\"                                                                                          | \"\"                         |%n| \"org.neo4j.procedure.readOnlyTryingToWrite\"         | \"org.neo4j.procedure.readOnlyTryingToWrite() :: (NODE?)\"                                                                                                     | \"\"                         |%n| \"org.neo4j.procedure.readOnlyTryingToWriteSchema\"   | \"org.neo4j.procedure.readOnlyTryingToWriteSchema() :: (STRING?)\"                                                                                             | \"\"                         |%n| \"org.neo4j.procedure.recursiveSum\"                  | \"org.neo4j.procedure.recursiveSum(someValue :: INTEGER?) :: (INTEGER?)\"                                                                                      | \"\"                         |%n| \"org.neo4j.procedure.shutdown\"                      | \"org.neo4j.procedure.shutdown() :: (STRING?)\"                                                                                                                | \"\"                         |%n| \"org.neo4j.procedure.simpleArgument\"                | \"org.neo4j.procedure.simpleArgument(someValue :: INTEGER?) :: (INTEGER?)\"                                                                                    | \"\"                         |%n| \"org.neo4j.procedure.squareDouble\"                  | \"org.neo4j.procedure.squareDouble(someValue :: FLOAT?) :: (FLOAT?)\"                                                                                          | \"\"                         |%n| \"org.neo4j.procedure.squareLong\"                    | \"org.neo4j.procedure.squareLong(someValue :: INTEGER?) :: (INTEGER?)\"                                                                                        | \"\"                         |%n| \"org.neo4j.procedure.throwsExceptionInStream\"       | \"org.neo4j.procedure.throwsExceptionInStream() :: (INTEGER?)\"                                                                                                | \"\"                         |%n| \"org.neo4j.procedure.unsupportedFunction\"           | \"org.neo4j.procedure.unsupportedFunction() :: (STRING?)\"                                                                                                     | \"\"                         |%n| \"randomUUID\"                                        | \"randomUUID() :: (STRING?)\"                                                                                                                                  | \"Generates a random UUID.\" |%n| \"this.is.test.only.sum\"                             | \"this.is.test.only.sum(numbers :: LIST? OF NUMBER?) :: (NUMBER?)\"                                                                                            | \"\"                         |%n+-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+%n27 rows%n", new Object[0]);
        MatcherAssert.assertThat((Object)res.resultAsString(), (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldCallFunctionWithSameNameAsBuiltIn() throws Throwable {
        Result res = this.db.execute("RETURN this.is.test.only.sum([1337, 2.718281828, 3.1415]) AS result");
        MatcherAssert.assertThat(res.next().get("result"), (Matcher)IsEqual.equalTo((Object)1342.859781828));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Before
    public void setUp() throws IOException {
        exceptionsInFunction.clear();
        new JarBuilder().createJarFor(this.plugins.newFile("myFunctions.jar"), new Class[]{ClassWithFunctions.class});
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.plugin_dir, this.plugins.getRoot().getAbsolutePath()).setConfig(GraphDatabaseSettings.record_id_batch_size, "1").setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    @After
    public void tearDown() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    public static class ClassWithFunctions {
        @Context
        public GraphDatabaseService db;
        @Context
        public Log log;

        @UserFunction
        public long integrationTestMe() {
            return 1337L;
        }

        @UserFunction
        public long simpleArgument(@Name(value="someValue") long someValue) {
            return someValue;
        }

        @UserFunction
        public String defaultValues(@Name(value="string", defaultValue="a string") String string, @Name(value="integer", defaultValue="42") long integer, @Name(value="float", defaultValue="3.14") double aFloat, @Name(value="boolean", defaultValue="true") boolean aBoolean) {
            return String.format("%s,%d,%.2f,%b", string, integer, aFloat, aBoolean);
        }

        @UserFunction
        public long nodeListArgument(@Name(value="nodes") List<Node> nodes) {
            long count = 0L;
            for (Node node : nodes) {
                if (node == null) continue;
                ++count;
            }
            return count;
        }

        @UserFunction
        public long delegatingFunction(@Name(value="someValue") long someValue) {
            return (Long)this.db.execute("RETURN org.neo4j.procedure.simpleArgument({name}) AS result", MapUtil.map((Object[])new Object[]{"name", someValue})).next().get("result");
        }

        @UserFunction
        public long recursiveSum(@Name(value="someValue") long order) {
            if (order == 0L) {
                return 0L;
            }
            Long prev = (Long)this.db.execute("RETURN org.neo4j.procedure.recursiveSum({order}) AS someVal", MapUtil.map((Object[])new Object[]{"order", order - 1L})).next().get("someVal");
            return order + prev;
        }

        @UserFunction
        public long genericArguments(@Name(value="strings") List<List<String>> stringList, @Name(value="longs") List<List<List<Long>>> longList) {
            return stringList.size() + longList.size();
        }

        @UserFunction
        public long mapArgument(@Name(value="map") Map<String, Object> map) {
            if (map == null) {
                return 0L;
            }
            return map.size();
        }

        @UserFunction
        public Node node(@Name(value="id") long id) {
            if (id < 0L) {
                return null;
            }
            return this.db.getNodeById(id);
        }

        @UserFunction
        public double squareDouble(@Name(value="someValue") double value) {
            return value * value;
        }

        @UserFunction
        public double avgNumberList(@Name(value="someValue") List<Number> list) {
            return ((Number)list.stream().reduce((l, r) -> l.doubleValue() + r.doubleValue()).orElse(0.0)).doubleValue() / (double)list.size();
        }

        @UserFunction
        public double avgDoubleList(@Name(value="someValue") List<Double> list) {
            return list.stream().reduce((l, r) -> l + r).orElse(0.0) / (double)list.size();
        }

        @UserFunction
        public long squareLong(@Name(value="someValue") long value) {
            return value * value;
        }

        @UserFunction
        public long throwsExceptionInStream() {
            throw new RuntimeException("Kaboom");
        }

        @UserFunction
        public long indexOutOfBounds() {
            int[] ints = new int[]{1, 2, 3};
            return ints[4];
        }

        @UserFunction
        public List<String> listCoolPeopleInDatabase() {
            return this.db.findNodes(Label.label((String)"Person")).map(node -> (String)node.getProperty("name")).stream().collect(Collectors.toList());
        }

        @UserFunction
        public long logAround() {
            this.log.debug("1");
            this.log.info("2");
            this.log.warn("3");
            this.log.error("4");
            return 1337L;
        }

        @UserFunction
        public Node readOnlyTryingToWrite() {
            return this.db.createNode();
        }

        @UserFunction
        public Node readOnlyCallingWriteFunction() {
            return (Node)this.db.execute("RETURN org.neo4j.procedure.writingFunction() AS node").next().get("node");
        }

        @UserFunction
        public long readOnlyCallingWriteProcedure() {
            this.db.execute("CALL org.neo4j.procedure.writingProcedure()");
            return 1337L;
        }

        @UserFunction(value="this.is.test.only.sum")
        public Number sum(@Name(value="numbers") List<Number> numbers) {
            return numbers.stream().mapToDouble(Number::doubleValue).sum();
        }

        @Procedure(mode=Mode.WRITE)
        public void writingProcedure() {
            this.db.createNode();
        }

        @UserFunction
        public String shutdown() {
            this.db.shutdown();
            return "oh no!";
        }

        @UserFunction
        public String unsupportedFunction() {
            jobs.submit(() -> {
                try (Transaction tx = this.db.beginTx();){
                    this.db.createNode();
                    tx.success();
                }
                catch (Exception e) {
                    exceptionsInFunction.add(e);
                }
            });
            return "why!?";
        }

        @UserFunction
        public Path nodePaths(@Name(value="someValue") Node node) {
            return this.db.execute("WITH {node} AS node MATCH p=(node)-[*]->() RETURN p", MapUtil.map((Object[])new Object[]{"node", node})).next().getOrDefault("p", null);
        }

        @Description(value="This is a description")
        @UserFunction
        public Node nodeWithDescription(@Name(value="someValue") Node node) {
            return node;
        }

        @UserFunction
        public String readOnlyTryingToWriteSchema() {
            this.db.execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
            return "done";
        }
    }
}

