/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class GraphDatabaseFactoryWithCustomBoltKernelExtension
extends GraphDatabaseFactory {
    private final BoltKernelExtension customExtension;

    public GraphDatabaseFactoryWithCustomBoltKernelExtension(BoltKernelExtension customExtension) {
        this.customExtension = customExtension;
    }

    protected GraphDatabaseService newDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        CustomBoltKernelExtensionFacadeFactory factory = new CustomBoltKernelExtensionFacadeFactory(this.customExtension);
        return factory.newFacade(storeDir, config, dependencies);
    }

    private static class CustomBoltKernelExtension
    extends KernelExtensionFactory<BoltKernelExtension.Dependencies> {
        final BoltKernelExtension customExtension;

        CustomBoltKernelExtension(BoltKernelExtension customExtension) {
            super("custom-bolt-server");
            this.customExtension = customExtension;
        }

        public Lifecycle newInstance(KernelContext context, BoltKernelExtension.Dependencies dependencies) throws Throwable {
            return this.customExtension.newInstance(context, dependencies);
        }
    }

    private static class CustomBoltKernelExtensionDependencies
    implements GraphDatabaseFacadeFactory.Dependencies {
        final BoltKernelExtension customExtension;
        final GraphDatabaseFacadeFactory.Dependencies delegate;

        CustomBoltKernelExtensionDependencies(BoltKernelExtension customExtension, GraphDatabaseFacadeFactory.Dependencies delegate) {
            this.customExtension = customExtension;
            this.delegate = delegate;
        }

        public Monitors monitors() {
            return this.delegate.monitors();
        }

        public LogProvider userLogProvider() {
            return this.delegate.userLogProvider();
        }

        public Iterable<Class<?>> settingsClasses() {
            return this.delegate.settingsClasses();
        }

        public Iterable<KernelExtensionFactory<?>> kernelExtensions() {
            return Iterables.stream((Iterable)this.delegate.kernelExtensions()).map(this::replaceBoltKernelExtensionFactory).collect(Collectors.toList());
        }

        public Map<String, URLAccessRule> urlAccessRules() {
            return this.delegate.urlAccessRules();
        }

        public Iterable<QueryEngineProvider> executionEngines() {
            return this.delegate.executionEngines();
        }

        KernelExtensionFactory<?> replaceBoltKernelExtensionFactory(KernelExtensionFactory<?> factory) {
            if (factory instanceof BoltKernelExtension) {
                return new CustomBoltKernelExtension(this.customExtension);
            }
            return factory;
        }
    }

    private static class CustomBoltKernelExtensionFacadeFactory
    extends GraphDatabaseFacadeFactory {
        final BoltKernelExtension customExtension;

        CustomBoltKernelExtensionFacadeFactory(BoltKernelExtension customExtension) {
            super(DatabaseInfo.ENTERPRISE, EnterpriseEditionModule::new);
            this.customExtension = customExtension;
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
            CustomBoltKernelExtensionDependencies newDependencies = new CustomBoltKernelExtensionDependencies(this.customExtension, dependencies);
            return new PlatformModule(storeDir, config, this.databaseInfo, (GraphDatabaseFacadeFactory.Dependencies)newDependencies, graphDatabaseFacade);
        }
    }
}

