/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class BoltMessageLoggingIT {
    private static final String CONNECTOR_KEY = "bolt";
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        protected void configure(GraphDatabaseFactory databaseFactory) {
            super.configure(databaseFactory);
            ((TestGraphDatabaseFactory)databaseFactory).setFileSystem((FileSystemAbstraction)BoltMessageLoggingIT.this.fs);
        }

        protected void configure(GraphDatabaseBuilder builder) {
            super.configure(builder);
            builder.setConfig(GraphDatabaseSettings.auth_enabled, "false");
            builder.setConfig(new BoltConnector((String)BoltMessageLoggingIT.CONNECTOR_KEY).type, Connector.ConnectorType.BOLT.toString());
            builder.setConfig(new BoltConnector((String)BoltMessageLoggingIT.CONNECTOR_KEY).enabled, "true");
            builder.setConfig(new BoltConnector((String)BoltMessageLoggingIT.CONNECTOR_KEY).listen_address, "localhost:0");
            builder.setConfig(new BoltConnector((String)BoltMessageLoggingIT.CONNECTOR_KEY).encryption_level, BoltConnector.EncryptionLevel.DISABLED.toString());
        }
    }.withSetting(OnlineBackupSettings.online_backup_enabled, "false").startLazily();
    private Driver driver;

    @After
    public void closeDriver() throws Exception {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    public void shouldWriteToDefaultFileWhenEnabled() throws IOException {
        this.db.setConfig(GraphDatabaseSettings.bolt_logging_enabled, "true");
        this.db.ensureStarted(new String[0]);
        this.driver = this.newDriver();
        File boltLogFile = (File)this.config().get(GraphDatabaseSettings.bolt_log_filename);
        this.assertBoltLogIsWritten(boltLogFile);
    }

    @Test
    public void shouldWriteNothingWhenDisabled() {
        this.db.setConfig(GraphDatabaseSettings.bolt_logging_enabled, "false");
        this.db.ensureStarted(new String[0]);
        this.driver = this.newDriver();
        File boltLogFile = (File)this.config().get(GraphDatabaseSettings.bolt_log_filename);
        Assert.assertFalse((boolean)this.fs.fileExists(boltLogFile));
        try (Session session = this.driver.session();){
            session.run("CREATE ()").consume();
        }
        Assert.assertFalse((boolean)this.fs.fileExists(boltLogFile));
    }

    @Test
    public void shouldWriteToCustomFileWhenConfigured() throws IOException {
        File customBoltLogFile = BoltMessageLoggingIT.customBoltLogFile();
        this.db.setConfig(GraphDatabaseSettings.bolt_logging_enabled, "true");
        this.db.setConfig(GraphDatabaseSettings.bolt_log_filename, customBoltLogFile.toString());
        this.db.ensureStarted(new String[0]);
        this.driver = this.newDriver();
        this.assertBoltLogIsWritten(customBoltLogFile);
    }

    @Test
    public void shouldWriteErrorsToCustomFileWhenConfigured() throws IOException {
        File customBoltLogFile = BoltMessageLoggingIT.customBoltLogFile();
        this.db.setConfig(GraphDatabaseSettings.bolt_logging_enabled, "true");
        this.db.setConfig(GraphDatabaseSettings.bolt_log_filename, customBoltLogFile.toString());
        this.db.ensureStarted(new String[0]);
        this.driver = this.newDriver();
        Assert.assertTrue((boolean)this.fs.fileExists(customBoltLogFile));
        String query = "RETURN 1 as 2";
        try (Session session = this.driver.session();){
            session.run(query).consume();
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            String contents = this.readFile(customBoltLogFile);
            Assert.assertThat((Object)contents, (Matcher)Matchers.containsString((String)"S FAILURE"));
        }
    }

    private void assertBoltLogIsWritten(File boltLogFile) throws IOException {
        Assert.assertTrue((boolean)this.fs.fileExists(boltLogFile));
        String query = "CREATE (n:Person {name: 'Beta Ray Bill'}) \nRETURN 42";
        try (Session session = this.driver.session();){
            session.run(query).consume();
        }
        String contents = this.readFile(boltLogFile);
        Assert.assertThat((Object)contents, (Matcher)Matchers.containsString((String)"C RUN -"));
    }

    private String readFile(File file) throws IOException {
        return IOUtils.toString((InputStream)this.fs.openAsInputStream(file));
    }

    private Config config() {
        return this.resolveDependency(Config.class);
    }

    private Driver newDriver() {
        org.neo4j.driver.v1.Config driverConfig = org.neo4j.driver.v1.Config.build().withoutEncryption().toConfig();
        return GraphDatabase.driver((URI)this.boltUri(), (org.neo4j.driver.v1.Config)driverConfig);
    }

    private URI boltUri() {
        HostnamePort localAddress = this.resolveDependency(ConnectorPortRegister.class).getLocalAddress(CONNECTOR_KEY);
        return URI.create("bolt://" + localAddress);
    }

    private <T> T resolveDependency(Class<T> type) {
        return (T)this.graphDbApi().getDependencyResolver().resolveDependency(type);
    }

    private GraphDatabaseAPI graphDbApi() {
        return this.db.getGraphDatabaseAPI();
    }

    private static File customBoltLogFile() {
        return Paths.get("tmp", "my_bolt.log").toAbsolutePath().toFile();
    }
}

