/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.protocol.HttpRequestHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.concurrent.RecentK;
import org.neo4j.ext.udc.Edition;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.DefaultUdcInformationCollector;
import org.neo4j.ext.udc.impl.PingerHandler;
import org.neo4j.ext.udc.impl.UdcTimerTask;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.RegexMatcher;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class UdcExtensionImplIT
extends LocalServerTestBase {
    private static final String VersionPattern = "(\\d\\.\\d+(([.-]).*)?)|(dev)";
    private static final Condition<Integer> IS_ZERO = value -> value == 0;
    private static final Condition<Integer> IS_GREATER_THAN_ZERO = value -> value > 0;
    @Rule
    public TestDirectory path = TestDirectory.testDirectory();
    private PingerHandler handler;
    private Map<String, String> config;
    private GraphDatabaseService graphdb;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        UdcTimerTask.successCounts.clear();
        UdcTimerTask.failureCounts.clear();
        this.handler = new PingerHandler();
        this.serverBootstrap.registerHandler("/*", (HttpRequestHandler)this.handler);
        HttpHost target = this.start();
        int servicePort = target.getPort();
        String serviceHostName = target.getHostName();
        String serverAddress = serviceHostName + ":" + servicePort;
        this.config = new HashMap<String, String>();
        this.config.put(UdcSettings.first_delay.name(), "100");
        this.config.put(UdcSettings.udc_host.name(), serverAddress);
        this.config.put(OnlineBackupSettings.online_backup_enabled.name(), "false");
        this.blockUntilServerAvailable(new URL("http", serviceHostName, servicePort, "/"));
    }

    @After
    public void cleanup() throws IOException {
        this.cleanup(this.graphdb);
    }

    @Test
    public void shouldLoadWhenNormalGraphdbIsCreated() throws Exception {
        Map<String, String> config = Collections.singletonMap(OnlineBackupSettings.online_backup_enabled.name(), "false");
        this.graphdb = this.createDatabase(config);
        this.assertGotSuccessWithRetry(IS_ZERO);
    }

    @Test
    public void shouldLoadForEachCreatedGraphdb() throws IOException {
        Map<String, String> config = Collections.singletonMap(OnlineBackupSettings.online_backup_enabled.name(), "false");
        GraphDatabaseService graphdb1 = this.createDatabase(this.path.directory("first-db"), config);
        GraphDatabaseService graphdb2 = this.createDatabase(this.path.directory("second-db"), config);
        Set successCountValues = UdcTimerTask.successCounts.keySet();
        Assert.assertThat((Object)successCountValues.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)"this", (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"that")));
        this.cleanup(graphdb1);
        this.cleanup(graphdb2);
    }

    @Test
    public void shouldRecordFailuresWhenThereIsNoServer() throws Exception {
        this.graphdb = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path.directory("should-record-failures")).setConfig(UdcSettings.first_delay, "100").setConfig(UdcSettings.udc_host, "127.0.0.1:1").setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        this.assertGotFailureWithRetry(IS_GREATER_THAN_ZERO);
    }

    @Test
    public void shouldRecordSuccessesWhenThereIsAServer() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        this.assertGotFailureWithRetry(IS_ZERO);
    }

    @Test
    public void shouldBeAbleToSpecifySourceWithConfig() throws Exception {
        this.config.put(UdcSettings.udc_source.name(), "unit-testing");
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertEquals((Object)"unit-testing", this.handler.getQueryMap().get("source"));
    }

    @Test
    public void shouldRecordDatabaseMode() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertEquals((Object)"single", this.handler.getQueryMap().get("databasemode"));
    }

    @Test
    public void shouldRecordClusterName() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        String hashOfDefaultClusterName = "1108231321";
        Assert.assertEquals((Object)hashOfDefaultClusterName, this.handler.getQueryMap().get("cluster"));
    }

    private void blockUntilServerAvailable(URL url) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        PointerTo<Boolean> flag = new PointerTo<Boolean>(false);
        Thread t = new Thread(() -> {
            while (!((Boolean)flag.getValue()).booleanValue()) {
                try {
                    HttpGet httpget = new HttpGet(url.toURI());
                    httpget.addHeader("Accept", "application/json");
                    DefaultHttpClient client = new DefaultHttpClient();
                    client.execute((HttpUriRequest)httpget);
                    flag.setValue(true);
                    latch.countDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        t.run();
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        t.join();
    }

    @Test
    public void shouldBeAbleToReadDefaultRegistration() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertEquals((Object)"unreg", this.handler.getQueryMap().get("reg"));
    }

    @Test
    public void shouldBeAbleToDetermineTestTagFromClasspath() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertEquals((Object)"test,web", this.handler.getQueryMap().get("tags"));
    }

    @Test
    public void shouldBeAbleToDetermineEditionFromClasspath() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertEquals((Object)Edition.enterprise.name(), this.handler.getQueryMap().get("edition"));
    }

    @Test
    public void shouldBeAbleToDetermineUserAgent() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.makeRequestWithAgent("test/1.0");
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertEquals((Object)"test/1.0", this.handler.getQueryMap().get("ua"));
    }

    @Test
    public void shouldBeAbleToDetermineUserAgents() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.makeRequestWithAgent("test/1.0");
        this.makeRequestWithAgent("foo/bar");
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        String userAgents = (String)this.handler.getQueryMap().get("ua");
        Assert.assertEquals((Object)true, (Object)userAgents.contains("test/1.0"));
        Assert.assertEquals((Object)true, (Object)userAgents.contains("foo/bar"));
    }

    @Test
    public void shouldIncludeMacAddressInConfig() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertNotNull(this.handler.getQueryMap().get("mac"));
    }

    @Test
    public void shouldIncludePrefixedSystemProperties() throws Exception {
        this.withSystemProperty("unsupported.dbms.udc.test", "udc-property", () -> {
            this.withSystemProperty("os.test", "os-property", () -> {
                this.graphdb = this.createDatabase(this.config);
                this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
                Assert.assertEquals((Object)"udc-property", this.handler.getQueryMap().get("test"));
                Assert.assertEquals((Object)"os-property", this.handler.getQueryMap().get("os.test"));
                return null;
            });
            return null;
        });
    }

    @Test
    public void shouldNotIncludeDistributionForWindows() throws Exception {
        this.withSystemProperty("os.name", "Windows", () -> {
            this.graphdb = this.createDatabase(this.config);
            this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
            Assert.assertEquals((Object)"unknown", this.handler.getQueryMap().get("dist"));
            return null;
        });
    }

    @Test
    public void shouldIncludeDistributionForLinux() throws Exception {
        if (!SystemUtils.IS_OS_LINUX) {
            return;
        }
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        Assert.assertEquals((Object)DefaultUdcInformationCollector.searchForPackageSystems(), this.handler.getQueryMap().get("dist"));
    }

    @Test
    public void shouldNotIncludeDistributionForMacOS() throws Exception {
        this.withSystemProperty("os.name", "Mac OS X", () -> {
            this.graphdb = this.createDatabase(this.config);
            this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
            Assert.assertEquals((Object)"unknown", this.handler.getQueryMap().get("dist"));
            return null;
        });
    }

    @Test
    public void shouldIncludeVersionInConfig() throws Exception {
        this.graphdb = this.createDatabase(this.config);
        this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
        String version = (String)this.handler.getQueryMap().get("v");
        Assert.assertThat((Object)version, (Matcher)new RegexMatcher(Pattern.compile(VersionPattern)));
    }

    @Test
    public void shouldOverrideSourceWithSystemProperty() throws Exception {
        this.withSystemProperty(UdcSettings.udc_source.name(), "overridden", () -> {
            this.graphdb = this.createDatabase(this.path.directory("db-with-property"), this.config);
            this.assertGotSuccessWithRetry(IS_GREATER_THAN_ZERO);
            String source = (String)this.handler.getQueryMap().get("source");
            Assert.assertEquals((Object)"overridden", (Object)source);
            return null;
        });
    }

    @Test
    public void shouldMatchAllValidVersions() throws Exception {
        Assert.assertTrue((boolean)"1.8.M07".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.8.RC1".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.8.GA".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.8".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.9".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.9-SNAPSHOT".matches(VersionPattern));
        Assert.assertTrue((boolean)"2.0-SNAPSHOT".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.9.M01".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.10".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.10-SNAPSHOT".matches(VersionPattern));
        Assert.assertTrue((boolean)"1.10.M01".matches(VersionPattern));
    }

    @Test
    public void shouldFilterPlusBuildNumbers() throws Exception {
        Assert.assertThat((Object)DefaultUdcInformationCollector.filterVersionForUDC((String)"1.9.0-M01+00001"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1.9.0-M01")));
    }

    @Test
    public void shouldNotFilterSnapshotBuildNumbers() throws Exception {
        Assert.assertThat((Object)DefaultUdcInformationCollector.filterVersionForUDC((String)"2.0-SNAPSHOT"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"2.0-SNAPSHOT")));
    }

    @Test
    public void shouldNotFilterReleaseBuildNumbers() throws Exception {
        Assert.assertThat((Object)DefaultUdcInformationCollector.filterVersionForUDC((String)"1.9"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1.9")));
    }

    @Test
    public void shouldUseTheCustomConfiguration() throws Exception {
        this.config.put(UdcSettings.udc_source.name(), "my_source");
        this.config.put(UdcSettings.udc_registration_key.name(), "my_key");
        this.graphdb = this.createDatabase(this.config);
        Config config = (Config)((GraphDatabaseAPI)this.graphdb).getDependencyResolver().resolveDependency(Config.class);
        Assert.assertEquals((Object)"my_source", (Object)config.get(UdcSettings.udc_source));
        Assert.assertEquals((Object)"my_key", (Object)config.get(UdcSettings.udc_registration_key));
    }

    private void assertGotSuccessWithRetry(Condition<Integer> condition) throws Exception {
        this.assertGotPingWithRetry(UdcTimerTask.successCounts, condition);
    }

    private void assertGotFailureWithRetry(Condition<Integer> condition) throws Exception {
        this.assertGotPingWithRetry(UdcTimerTask.failureCounts, condition);
    }

    private void assertGotPingWithRetry(Map<String, Integer> counts, Condition<Integer> condition) throws Exception {
        for (int i = 0; i < 50; ++i) {
            Thread.sleep(200L);
            Collection<Integer> countValues = counts.values();
            Integer count = countValues.iterator().next();
            if (!condition.isTrue(count)) continue;
            return;
        }
        Assert.fail();
    }

    private GraphDatabaseService createDatabase() throws IOException {
        return this.createDatabase(null, null);
    }

    private GraphDatabaseService createDatabase(Map<String, String> config) throws IOException {
        return this.createDatabase(null, config);
    }

    private GraphDatabaseService createDatabase(File storeDir, Map<String, String> config) throws IOException {
        GraphDatabaseBuilder graphDatabaseBuilder;
        TestEnterpriseGraphDatabaseFactory factory = new TestEnterpriseGraphDatabaseFactory();
        GraphDatabaseBuilder graphDatabaseBuilder2 = graphDatabaseBuilder = storeDir != null ? factory.newImpermanentDatabaseBuilder(storeDir) : factory.newImpermanentDatabaseBuilder();
        if (config != null) {
            graphDatabaseBuilder.setConfig(config);
        }
        return graphDatabaseBuilder.newGraphDatabase();
    }

    private void cleanup(GraphDatabaseService gdb) throws IOException {
        if (gdb != null) {
            GraphDatabaseAPI db = (GraphDatabaseAPI)gdb;
            gdb.shutdown();
            FileUtils.deleteDirectory((File)db.getStoreDir());
        }
    }

    private void makeRequestWithAgent(String agent) {
        RecentK clients = (RecentK)((UsageData)((GraphDatabaseAPI)this.graphdb).getDependencyResolver().resolveDependency(UsageData.class)).get(UsageDataKeys.clientNames);
        clients.add((Object)agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withSystemProperty(String name, String value, Callable<Void> block) throws Exception {
        String original = System.getProperty(name);
        System.setProperty(name, value);
        try {
            block.call();
        }
        finally {
            if (original == null) {
                System.clearProperty(name);
            } else {
                System.setProperty(name, original);
            }
        }
    }

    private static class PointerTo<T> {
        private T value;

        PointerTo(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }

    private static interface Condition<T> {
        public boolean isTrue(T var1);
    }
}

