/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class BoltHAIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withBoltEnabled().withCluster(ClusterManager.clusterOfSize((int)3));

    @Test
    public void shouldContinueServingBoltRequestsBetweenInternalRestarts() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Driver driver = GraphDatabase.driver((String)cluster.getBoltAddress(slave1), (AuthToken)AuthTokens.basic((String)"neo4j", (String)"neo4j"));
        String lastBookmark = BoltHAIT.inExpirableSession(driver, Driver::session, s -> {
            try (Transaction tx = s.beginTransaction();){
                tx.run("CREATE (person:Person {name: {name}, title: {title}})", Values.parameters((Object[])new Object[]{"name", "Webber", "title", "Mr"}));
                tx.success();
            }
            return s.lastBookmark();
        });
        ClusterManager.RepairKit slaveFailRK = cluster.fail(slave1);
        cluster.await(ClusterManager.entireClusterSeesMemberAsNotAvailable((HighlyAvailableGraphDatabase)slave1));
        slaveFailRK.repair();
        cluster.await(ClusterManager.masterSeesMembers((int)3));
        Integer count = BoltHAIT.inExpirableSession(driver, Driver::session, s -> {
            Record record;
            try (Transaction tx = s.beginTransaction(lastBookmark);){
                record = tx.run("MATCH (n:Person) RETURN COUNT(*) AS count").next();
                tx.success();
            }
            return record.get("count").asInt();
        });
        Assert.assertEquals((long)1L, (long)count.intValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T inExpirableSession(Driver driver, Function<Driver, Session> acquirer, Function<Session, T> op) throws TimeoutException, InterruptedException {
        long endTime = System.currentTimeMillis() + 15000L;
        while (true) {
            try (Session session = acquirer.apply(driver);){
                Session t = op.apply(session);
                return (T)t;
            }
            catch (SessionExpiredException | TransientException throwable6) {
                if (System.currentTimeMillis() < endTime) continue;
                throw new TimeoutException("Transaction did not succeed in time");
            }
            break;
        }
    }
}

