/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.net.URI;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.kernel.configuration.ssl.LegacySslPolicyConfig;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.server.HTTP;

public class BatchEndpointIT {
    @Rule
    public final Neo4jRule neo4j = new Neo4jRule().withConfig(LegacySslPolicyConfig.certificates_directory, ServerTestUtils.getRelativePath((File)ServerTestUtils.getSharedTestTemporaryFolder(), (Setting)LegacySslPolicyConfig.certificates_directory)).withConfig(GraphDatabaseSettings.logs_directory, ServerTestUtils.getRelativePath((File)ServerTestUtils.getSharedTestTemporaryFolder(), (Setting)GraphDatabaseSettings.logs_directory)).withConfig(ServerSettings.http_logging_enabled, "true").withConfig(GraphDatabaseSettings.auth_enabled, "false");

    @Test
    public void requestsShouldNotFailWhenHttpLoggingIsOn() {
        String body = "[{'method': 'POST', 'to': '/node', 'body': {'age': 1}, 'id': 1} ]";
        HTTP.Response response = HTTP.withBaseUri((URI)this.neo4j.httpURI()).withHeaders(new String[]{"Content-Type", "application/json"}).POST("db/data/batch", HTTP.RawPayload.quotedJson((String)body));
        Assert.assertEquals((long)200L, (long)response.status());
    }
}

