/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.proc.JarBuilder;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.ProcedureTransaction;
import org.neo4j.procedure.StringMatcherIgnoresNewlines;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.procedure.UserFunction;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class ProcedureIT {
    @Rule
    public TemporaryFolder plugins = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private GraphDatabaseService db;
    public static boolean[] onCloseCalled;
    private static List<Exception> exceptionsInProcedure;
    private static final ScheduledExecutorService jobs;

    @Before
    public void setUp() throws IOException {
        exceptionsInProcedure.clear();
        new JarBuilder().createJarFor(this.plugins.newFile("myProcedures.jar"), new Class[]{ClassWithProcedures.class});
        new JarBuilder().createJarFor(this.plugins.newFile("myFunctions.jar"), new Class[]{ClassWithFunctions.class});
        this.db = new TestEnterpriseGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.plugin_dir, this.plugins.getRoot().getAbsolutePath()).setConfig(GraphDatabaseSettings.record_id_batch_size, "1").newGraphDatabase();
        onCloseCalled = new boolean[2];
    }

    @After
    public void tearDown() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void shouldCallProcedureWithParameterMap() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.simpleArgument", MapUtil.map((Object[])new Object[]{"name", 42L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 42L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithDefaultArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.simpleArgumentWithDefault");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 42L})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallYieldProcedureWithDefaultArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.simpleArgumentWithDefault() YIELD someVal as n RETURN n + 1295 as val");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"val", 1337L})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallProcedureWithAllDefaultArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.defaultValues");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"string", "a string", "integer", 42L, "aFloat", 3.14, "aBoolean", true})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallProcedureWithOneProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.defaultValues('another string')");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"string", "another string", "integer", 42L, "aFloat", 3.14, "aBoolean", true})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallProcedureWithTwoProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.defaultValues('another string', 1337)");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"string", "another string", "integer", 1337L, "aFloat", 3.14, "aBoolean", true})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallProcedureWithThreeProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.defaultValues('another string', 1337, 2.718281828)");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"string", "another string", "integer", 1337L, "aFloat", 2.718281828, "aBoolean", true})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallProcedureWithFourProvidedRestDefaultArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.defaultValues('another string', 1337, 2.718281828, false)");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"string", "another string", "integer", 1337L, "aFloat", 2.718281828, "aBoolean", false})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldGiveNiceErrorMessageOnWrongStaticType() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Type mismatch: expected Integer but was String (line 1, column 41 (offset: 40))");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.simpleArgument('42')");
        }
    }

    @Test
    public void shouldGiveNiceErrorMessageWhenNoArguments() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage(StringMatcherIgnoresNewlines.containsStringIgnoreNewlines(String.format("Procedure call does not provide the required number of arguments: got 0 expected 1.%n%nProcedure org.neo4j.procedure.simpleArgument has signature: org.neo4j.procedure.simpleArgument(name :: INTEGER?) :: someVal :: INTEGER?%nmeaning that it expects 1 argument of type INTEGER?", new Object[0])));
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.simpleArgument()");
        }
    }

    @Test
    public void shouldGiveNiceErrorWhenMissingArgumentsToVoidFunction() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage(StringMatcherIgnoresNewlines.containsStringIgnoreNewlines(String.format("Procedure call does not provide the required number of arguments: got 1 expected 3.%n%nProcedure org.neo4j.procedure.sideEffectWithDefault has signature: org.neo4j.procedure.sideEffectWithDefault(label :: STRING?, propertyKey :: STRING?, value  =  Zhang Wei :: STRING?) :: VOID%nmeaning that it expects 3 arguments of type STRING?, STRING?, STRING? (line 1, column 1 (offset: 0))", new Object[0])));
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.sideEffectWithDefault()");
        }
    }

    @Test
    public void shouldShowDescriptionWhenMissingArguments() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage(StringMatcherIgnoresNewlines.containsStringIgnoreNewlines(String.format("Procedure call does not provide the required number of arguments: got 0 expected 1.%n%nProcedure org.neo4j.procedure.nodeWithDescription has signature: org.neo4j.procedure.nodeWithDescription(node :: NODE?) :: node :: NODE?%nmeaning that it expects 1 argument of type NODE?%nDescription: This is a description (line 1, column 1 (offset: 0))", new Object[0])));
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.nodeWithDescription()");
        }
    }

    @Test
    public void shouldCallDelegatingProcedure() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.delegatingProcedure", MapUtil.map((Object[])new Object[]{"name", 43L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 43L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallRecursiveProcedure() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.recursiveSum", MapUtil.map((Object[])new Object[]{"order", 10L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 55L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithGenericArgument() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.genericArguments([ ['graphs'], ['are'], ['everywhere']], [ [[1, 2, 3]], [[4, 5]]] )");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 5L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithMapArgument() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.mapArgument({foo: 42, bar: 'hello'})");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 2L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithMapArgumentDefaultingToNull() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.mapWithNullDefault()");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"map", null})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithMapArgumentDefaultingToMap() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.mapWithOtherDefault");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"map", MapUtil.map((Object[])new Object[]{"default", true})})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithListWithDefault() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.listWithDefault");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"list", Arrays.asList(42L, 1337L)})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithGenericListWithDefault() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.genericListWithDefault");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"list", Arrays.asList(42L, 1337L)})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureListWithNull() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.genericListWithDefault(null)");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"list", null})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureListWithNullInList() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.genericListWithDefault([[42, null, 57]])");
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"list", Arrays.asList(42L, null, 57L)})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureWithNodeReturn() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            long nodeId = this.db.createNode().getId();
            Result res = this.db.execute("CALL org.neo4j.procedure.node({id})", MapUtil.map((Object[])new Object[]{"id", nodeId}));
            Node node = (Node)res.next().get("node");
            MatcherAssert.assertThat((Object)node.getId(), (Matcher)IsEqual.equalTo((Object)nodeId));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallProcedureReturningNull() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.node(-1)");
        MatcherAssert.assertThat(res.next().get("node"), (Matcher)IsNull.nullValue());
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldCallYieldProcedureReturningNull() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.node(-1) YIELD node as node RETURN node");
        MatcherAssert.assertThat(res.next().get("node"), (Matcher)IsNull.nullValue());
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldGiveHelpfulErrorOnMissingProcedure() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("There is no procedure with the name `someProcedureThatDoesNotExist` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.");
        this.db.execute("CALL someProcedureThatDoesNotExist");
    }

    @Test
    public void shouldGiveHelpfulErrorOnExceptionMidStream() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result result = this.db.execute("CALL org.neo4j.procedure.throwsExceptionInStream");
            this.exception.expect(QueryExecutionException.class);
            this.exception.expectMessage("Failed to call procedure `org.neo4j.procedure.throwsExceptionInStream() :: (someVal :: INTEGER?)`: Kaboom");
            result.next();
        }
    }

    @Test
    public void shouldShowCauseOfError() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            this.exception.expect(QueryExecutionException.class);
            this.exception.expectMessage("Failed to invoke procedure `org.neo4j.procedure.indexOutOfBounds`: Caused by: java.lang.ArrayIndexOutOfBoundsException");
            this.db.execute("CALL org.neo4j.procedure.indexOutOfBounds");
        }
    }

    @Test
    public void shouldCallProcedureWithAccessToDB() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")}).setProperty("name", (Object)"Buddy Holly");
        }
        ignore = this.db.beginTx();
        var2_2 = null;
        try {
            Result res = this.db.execute("CALL org.neo4j.procedure.listCoolPeopleInDatabase");
            Assert.assertFalse((boolean)res.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (ignore != null) {
                if (var2_2 != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    ignore.close();
                }
            }
        }
    }

    @Test
    public void shouldLogLikeThereIsNoTomorrow() throws Throwable {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.db.shutdown();
        this.db = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)logProvider).setUserLogProvider((LogProvider)logProvider).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.plugin_dir, this.plugins.getRoot().getAbsolutePath()).setConfig(GraphDatabaseSettings.procedure_unrestricted, "org.neo4j.procedure.*").newGraphDatabase();
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.logAround()");
            while (res.hasNext()) {
                res.next();
            }
        }
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(Procedures.class);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{match.debug("1"), match.info("2"), match.warn("3"), match.error("4")});
    }

    @Test
    public void shouldDenyReadOnlyProcedureToPerformWrites() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Write operations are not allowed");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.readOnlyTryingToWrite()").next();
        }
    }

    @Test
    public void shouldAllowWriteProcedureToPerformWrites() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.writingProcedure()").close();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Assert.assertEquals((long)1L, (long)this.db.getAllNodes().stream().count());
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void readProceduresShouldPresentThemSelvesAsReadQueries() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            Result result = this.db.execute("EXPLAIN CALL org.neo4j.procedure.integrationTestMe()");
            Assert.assertEquals((Object)result.getQueryExecutionType().queryType(), (Object)QueryExecutionType.QueryType.READ_ONLY);
            tx.success();
        }
    }

    @Test
    public void readProceduresWithYieldShouldPresentThemSelvesAsReadQueries() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            Result result = this.db.execute("EXPLAIN CALL org.neo4j.procedure.integrationTestMe() YIELD someVal as v RETURN v");
            Assert.assertEquals((Object)result.getQueryExecutionType().queryType(), (Object)QueryExecutionType.QueryType.READ_ONLY);
            tx.success();
        }
    }

    @Test
    public void writeProceduresShouldPresentThemSelvesAsWriteQueries() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            Result result = this.db.execute("EXPLAIN CALL org.neo4j.procedure.createNode('n')");
            Assert.assertEquals((Object)result.getQueryExecutionType().queryType(), (Object)QueryExecutionType.QueryType.READ_WRITE);
            tx.success();
        }
    }

    @Test
    public void writeProceduresWithYieldShouldPresentThemSelvesAsWriteQueries() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            Result result = this.db.execute("EXPLAIN CALL org.neo4j.procedure.createNode('n') YIELD node as n RETURN n.prop");
            Assert.assertEquals((Object)result.getQueryExecutionType().queryType(), (Object)QueryExecutionType.QueryType.READ_WRITE);
            tx.success();
        }
    }

    @Test
    public void shouldNotBeAbleToCallWriteProcedureThroughReadProcedure() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Write operations are not allowed");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.readOnlyCallingWriteProcedure").next();
        }
    }

    @Test
    public void shouldNotBeAbleToCallReadProcedureThroughWriteProcedureInWriteOnlyTransaction() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Read operations are not allowed");
        GraphDatabaseAPI gdapi = (GraphDatabaseAPI)this.db;
        try (InternalTransaction tx = gdapi.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.writeOnly());){
            this.db.execute("CALL org.neo4j.procedure.writeProcedureCallingReadProcedure").next();
        }
    }

    @Test
    public void shouldBeAbleToCallWriteProcedureThroughWriteProcedure() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.writeProcedureCallingWriteProcedure()").close();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Assert.assertEquals((long)1L, (long)this.db.getAllNodes().stream().count());
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotBeAbleToCallSchemaProcedureThroughWriteProcedureInWriteTransaction() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Schema operations are not allowed");
        GraphDatabaseAPI gdapi = (GraphDatabaseAPI)this.db;
        try (InternalTransaction tx = gdapi.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.write());){
            this.db.execute("CALL org.neo4j.procedure.writeProcedureCallingSchemaProcedure").next();
        }
    }

    @Test
    public void shouldDenyReadOnlyProcedureToPerformSchema() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Schema operations are not allowed");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.readOnlyTryingToWriteSchema").next();
        }
    }

    @Test
    public void shouldDenyReadWriteProcedureToPerformSchema() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Schema operations are not allowed for AUTH_DISABLED with FULL restricted to TOKEN_WRITE.");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.readWriteTryingToWriteSchema").next();
        }
    }

    @Test
    public void shouldAllowSchemaProcedureToPerformSchema() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.schemaProcedure");
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            Assert.assertTrue((boolean)this.db.schema().getConstraints().iterator().hasNext());
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldAllowSchemaCallReadOnly() throws Throwable {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            nodeId = this.db.createNode().getId();
            tx.success();
        }
        var4_2 = null;
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.schemaCallReadProcedure({id})", MapUtil.map((Object[])new Object[]{"id", nodeId}));
            Node node = (Node)res.next().get("node");
            MatcherAssert.assertThat((Object)node.getId(), (Matcher)IsEqual.equalTo((Object)nodeId));
            Assert.assertFalse((boolean)res.hasNext());
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldDenySchemaProcedureToPerformWrite() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Cannot perform data updates in a transaction that has performed schema updates");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.schemaTryingToWrite").next();
        }
    }

    @Test
    public void shouldCoerceLongToDoubleAtRuntimeWhenCallingProcedure() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.squareDouble", MapUtil.map((Object[])new Object[]{"value", 4L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"result", 16.0})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCoerceListOfNumbersToDoublesAtRuntimeWhenCallingProcedure() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.avgNumberList({param})", MapUtil.map((Object[])new Object[]{"param", Arrays.asList(1L, 2L, 3L)}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"result", 2.0})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCoerceListOfMixedNumbers() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.avgDoubleList([{long}, {double}])", MapUtil.map((Object[])new Object[]{"long", 1L, "double", 2.0}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"result", 1.5})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCoerceDoubleToLongAtRuntimeWhenCallingProcedure() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Result res = this.db.execute("CALL org.neo4j.procedure.squareLong", MapUtil.map((Object[])new Object[]{"value", 4L}));
            MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"someVal", 16L})));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldBeAbleToCallVoidProcedure() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.sideEffect('PONTUS')");
            MatcherAssert.assertThat(this.db.execute("MATCH (n:PONTUS) RETURN count(n) AS c").next().get("c"), (Matcher)IsEqual.equalTo((Object)1L));
        }
    }

    @Test
    public void shouldBeAbleToCallVoidProcedureWithDefaultValue() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.sideEffectWithDefault('Person','name')");
            Result result = this.db.execute("MATCH (n:Person) RETURN n.name AS name");
            MatcherAssert.assertThat(result.next().get("name"), (Matcher)IsEqual.equalTo((Object)"Zhang Wei"));
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void shouldBeAbleToCallDelegatingVoidProcedure() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.delegatingSideEffect('SUTNOP')");
            MatcherAssert.assertThat(this.db.execute("MATCH (n:SUTNOP) RETURN count(n) AS c").next().get("c"), (Matcher)IsEqual.equalTo((Object)1L));
        }
    }

    @Test
    public void shouldBeAbleToPerformWritesOnNodesReturnedFromReadOnlyProcedure() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            long nodeId = this.db.createNode().getId();
            Node node = (Node)Iterators.single((Iterator)this.db.execute("CALL org.neo4j.procedure.node", MapUtil.map((Object[])new Object[]{"id", nodeId})).columnAs("node"));
            node.setProperty("name", (Object)"Stefan");
            tx.success();
        }
    }

    @Test
    public void shouldFailToShutdown() {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Failed to invoke procedure `org.neo4j.procedure.shutdown`: Caused by: java.lang.UnsupportedOperationException");
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.shutdown()");
        }
    }

    @Test
    public void shouldBeAbleToWriteAfterCallingReadOnlyProcedure() {
        try (Transaction ignore = this.db.beginTx();){
            this.db.execute("CALL org.neo4j.procedure.simpleArgument(12)").close();
            this.db.createNode();
        }
    }

    @Test
    public void shouldBeAbleToSpawnThreadsCreatingTransactionInProcedures() throws Throwable {
        int i;
        Runnable doIt = () -> {
            Result result = this.db.execute("CALL org.neo4j.procedure.supportedProcedure()");
            while (result.hasNext()) {
                result.next();
            }
            result.close();
        };
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(doIt);
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
        Result result = this.db.execute("MATCH () RETURN count(*) as n");
        MatcherAssert.assertThat((Object)result.hasNext(), (Matcher)IsEqual.equalTo((Object)true));
        while (result.hasNext()) {
            MatcherAssert.assertThat(result.next().get("n"), (Matcher)IsEqual.equalTo((Object)numThreads));
        }
        result.close();
        MatcherAssert.assertThat((String)"Should be no exceptions in procedures", (Object)exceptionsInProcedure.isEmpty(), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void shouldBeAbleToUseCallYieldWithPeriodicCommit() throws IOException {
        String[] lines = (String[])IntStream.rangeClosed(1, 100).boxed().map(i -> Integer.toString(i)).toArray(String[]::new);
        String url = this.createCsvFile(lines);
        Result result = this.db.execute("USING PERIODIC COMMIT 1 LOAD CSV FROM '" + url + "' AS line CALL org.neo4j.procedure.createNode(line[0]) YIELD node as n RETURN n.prop");
        for (int i2 = 1; i2 <= 100; ++i2) {
            MatcherAssert.assertThat(result.next().get("n.prop"), (Matcher)IsEqual.equalTo((Object)Integer.toString(i2)));
        }
        result.close();
        String[] dbContents = (String[])this.db.execute("MATCH (n) return n.prop").stream().map(m -> (String)m.get("n.prop")).toArray(String[]::new);
        MatcherAssert.assertThat((Object)dbContents, (Matcher)IsEqual.equalTo((Object)lines));
    }

    @Test
    public void shouldFailIfUsingPeriodicCommitWithReadOnlyQuery() throws IOException {
        String url = this.createCsvFile("13");
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Cannot use periodic commit in a non-updating query (line 1, column 1 (offset: 0))");
        this.db.execute("USING PERIODIC COMMIT 1 LOAD CSV FROM '" + url + "' AS line CALL org.neo4j.procedure.simpleArgument(toInt(line[0])) YIELD someVal as val RETURN val");
    }

    @Test
    public void shouldBeAbleToUseCallYieldWithLoadCsvAndSet() throws IOException {
        String url = this.createCsvFile("foo");
        Result result = this.db.execute("LOAD CSV FROM '" + url + "' AS line CALL org.neo4j.procedure.createNode(line[0]) YIELD node as n SET n.p = 42 RETURN n.p");
        MatcherAssert.assertThat(result.next().get("n.p"), (Matcher)IsEqual.equalTo((Object)42L));
    }

    @Test
    public void shouldCallProcedureReturningPaths() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            Node node1 = this.db.createNode();
            Node node2 = this.db.createNode();
            Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"KNOWS"));
            Result res = this.db.execute("CALL org.neo4j.procedure.nodePaths({node}) YIELD path RETURN path", MapUtil.map((Object[])new Object[]{"node", node1}));
            Assert.assertTrue((boolean)res.hasNext());
            Map value = res.next();
            Path path = (Path)value.get("path");
            MatcherAssert.assertThat((Object)path.length(), (Matcher)IsEqual.equalTo((Object)1));
            MatcherAssert.assertThat((Object)path.startNode(), (Matcher)IsEqual.equalTo((Object)node1));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)path.relationships()), (Matcher)IsEqual.equalTo(Collections.singletonList(rel)));
            MatcherAssert.assertThat((Object)path.endNode(), (Matcher)IsEqual.equalTo((Object)node2));
            Assert.assertFalse((boolean)res.hasNext());
        }
    }

    @Test
    public void shouldCallStreamCloseWhenResultExhausted() throws Throwable {
        String query = "CALL org.neo4j.procedure.onCloseProcedure(0)";
        Result res = this.db.execute(query);
        Assert.assertTrue((boolean)res.hasNext());
        res.next();
        Assert.assertFalse((boolean)onCloseCalled[0]);
        Assert.assertTrue((boolean)res.hasNext());
        res.next();
        Assert.assertTrue((boolean)onCloseCalled[0]);
    }

    @Test
    public void shouldCallStreamCloseWhenResultFiltered() throws Throwable {
        String query = "CALL org.neo4j.procedure.onCloseProcedure(1) YIELD someVal WITH someVal WHERE someVal = 1337 RETURN someVal";
        Result res = this.db.execute(query);
        Assert.assertFalse((boolean)onCloseCalled[1]);
        Assert.assertFalse((boolean)res.hasNext());
        Assert.assertTrue((boolean)onCloseCalled[1]);
    }

    private String createCsvFile(String ... lines) throws IOException {
        File file = this.plugins.newFile();
        try (PrintWriter writer = FileUtils.newFilePrintWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            for (String line : lines) {
                writer.println(line);
            }
        }
        return file.toURI().toURL().toString();
    }

    @Test
    public void shouldReturnNodeListTypedAsNodeList() {
        Result res = this.db.execute("CALL org.neo4j.procedure.nodeList() YIELD nodes RETURN extract( x IN nodes | id(x) ) as ids");
        Assert.assertTrue((boolean)res.hasNext());
        MatcherAssert.assertThat((Object)((List)res.next().get("ids")).size(), (Matcher)IsEqual.equalTo((Object)2));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldGiveNiceErrorMessageWhenAggregationFunctionInProcedureCall() {
        try (Transaction ignore = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            this.exception.expect(QueryExecutionException.class);
            this.db.execute("MATCH (n:Person) CALL org.neo4j.procedure.nodeListArgument(collect(n)) YIELD someVal RETURN someVal");
        }
    }

    @Test
    public void shouldWorkWhenUsingWithToProjectList() {
        try (Transaction ignore = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            this.db.createNode(new Label[]{Label.label((String)"Person")});
            Result res = this.db.execute("MATCH (n:Person) WITH collect(n) as persons CALL org.neo4j.procedure.nodeListArgument(persons) YIELD someVal RETURN someVal");
            MatcherAssert.assertThat(res.next().get("someVal"), (Matcher)IsEqual.equalTo((Object)2L));
        }
    }

    @Test
    public void shouldNotAllowReadProcedureInNoneTransaction() throws Throwable {
        this.exception.expect(AuthorizationViolationException.class);
        this.exception.expectMessage("Read operations are not allowed");
        GraphDatabaseAPI gdapi = (GraphDatabaseAPI)this.db;
        try (InternalTransaction tx = gdapi.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.none());){
            this.db.execute("CALL org.neo4j.procedure.integrationTestMe()");
            tx.success();
        }
    }

    @Test
    public void shouldNotAllowWriteProcedureInReadOnlyTransaction() throws Throwable {
        this.exception.expect(AuthorizationViolationException.class);
        this.exception.expectMessage("Write operations are not allowed");
        GraphDatabaseAPI gdapi = (GraphDatabaseAPI)this.db;
        try (InternalTransaction tx = gdapi.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.read());){
            this.db.execute("CALL org.neo4j.procedure.writingProcedure()");
            tx.success();
        }
    }

    @Test
    public void shouldNotAllowSchemaWriteProcedureInWriteTransaction() throws Throwable {
        this.exception.expect(AuthorizationViolationException.class);
        this.exception.expectMessage("Schema operations are not allowed");
        GraphDatabaseAPI gdapi = (GraphDatabaseAPI)this.db;
        try (InternalTransaction tx = gdapi.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.write());){
            this.db.execute("CALL org.neo4j.procedure.schemaProcedure()");
            tx.success();
        }
    }

    @Test
    public void shouldCallProcedureWithDefaultNodeArgument() throws Throwable {
        Result res = this.db.execute("CALL org.neo4j.procedure.nodeWithDefault");
        MatcherAssert.assertThat((Object)res.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"node", null})));
        Assert.assertFalse((boolean)res.hasNext());
    }

    @Test
    public void shouldIndicateDefaultValueWhenListingProcedures() throws Throwable {
        List results = this.db.execute("CALL dbms.procedures()").stream().filter(record -> record.get("name").equals("org.neo4j.procedure.nodeWithDefault")).collect(Collectors.toList());
        Assert.assertFalse((String)"Expected to find test procedure", (boolean)results.isEmpty());
        MatcherAssert.assertThat(((Map)results.get(0)).get("signature"), (Matcher)IsEqual.equalTo((Object)"org.neo4j.procedure.nodeWithDefault(node = null :: NODE?) :: (node :: NODE?)"));
    }

    @Test
    public void shouldShowDescriptionWhenListingProcedures() throws Throwable {
        List results = this.db.execute("CALL dbms.procedures()").stream().filter(record -> record.get("name").equals("org.neo4j.procedure.nodeWithDescription")).collect(Collectors.toList());
        Assert.assertFalse((String)"Expected to find test procedure", (boolean)results.isEmpty());
        MatcherAssert.assertThat(((Map)results.get(0)).get("description"), (Matcher)IsEqual.equalTo((Object)"This is a description"));
    }

    @Test
    public void shouldIndicateDefaultValueWhenListingFunctions() throws Throwable {
        List results = this.db.execute("CALL dbms.functions()").stream().filter(record -> record.get("name").equals("org.neo4j.procedure.getNodeName")).collect(Collectors.toList());
        Assert.assertFalse((String)"Expected to find test function", (boolean)results.isEmpty());
        MatcherAssert.assertThat(((Map)results.get(0)).get("signature"), (Matcher)IsEqual.equalTo((Object)"org.neo4j.procedure.getNodeName(node = null :: NODE?) :: (STRING?)"));
    }

    @Test
    public void shouldShowDescriptionWhenListingFunctions() throws Throwable {
        List results = this.db.execute("CALL dbms.functions()").stream().filter(record -> record.get("name").equals("org.neo4j.procedure.functionWithDescription")).collect(Collectors.toList());
        Assert.assertFalse((String)"Expected to find test function", (boolean)results.isEmpty());
        MatcherAssert.assertThat(((Map)results.get(0)).get("description"), (Matcher)IsEqual.equalTo((Object)"This is a description"));
    }

    @Test
    public void shouldUseGuardToDetectTransactionTermination() throws Throwable {
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Explicitly terminated by the user. ");
        this.db.execute("CALL org.neo4j.procedure.guardMe");
    }

    @Test
    public void shouldMakeTransactionToFail() throws Throwable {
        try (Transaction ignore = this.db.beginTx();){
            this.db.createNode(new Label[]{Label.label((String)"Person")});
        }
        Result result = this.db.execute("CALL org.neo4j.procedure.failingPersonCount");
        this.exception.expect(TransactionFailureException.class);
        result.next();
    }

    static {
        exceptionsInProcedure = Collections.synchronizedList(new ArrayList());
        jobs = Executors.newScheduledThreadPool(5);
    }

    public static class ClassWithFunctions {
        @UserFunction
        public String getNodeName(@Name(value="node", defaultValue="null") Node node) {
            return "nodeName";
        }

        @Description(value="This is a description")
        @UserFunction
        public long functionWithDescription() {
            return 0L;
        }
    }

    public static class ClassWithProcedures {
        @Context
        public GraphDatabaseService db;
        @Context
        public Log log;
        @Context
        public TerminationGuard guard;
        @Context
        public ProcedureTransaction procedureTransaction;

        @Procedure
        public Stream<Output> guardMe() {
            this.procedureTransaction.terminate();
            this.guard.check();
            throw new IllegalStateException("Should never have executed this!");
        }

        @Procedure
        public Stream<Output> integrationTestMe() {
            return Stream.of(new Output());
        }

        @Procedure
        public Stream<Output> failingPersonCount() {
            Result result = this.db.execute("MATCH (n:Person) RETURN count(n) as count");
            this.procedureTransaction.failure();
            return Stream.of(new Output((Long)result.next().get("count")));
        }

        @Procedure
        public Stream<Output> simpleArgument(@Name(value="name") long someValue) {
            return Stream.of(new Output(someValue));
        }

        @Procedure
        public Stream<Output> simpleArgumentWithDefault(@Name(value="name", defaultValue="42") long someValue) {
            return Stream.of(new Output(someValue));
        }

        @Procedure
        public Stream<PrimitiveOutput> defaultValues(@Name(value="string", defaultValue="a string") String string, @Name(value="integer", defaultValue="42") long integer, @Name(value="float", defaultValue="3.14") double aFloat, @Name(value="boolean", defaultValue="true") boolean aBoolean) {
            return Stream.of(new PrimitiveOutput(string, integer, aFloat, aBoolean));
        }

        @Procedure
        public Stream<Output> nodeListArgument(@Name(value="nodes") List<Node> nodes) {
            return Stream.of(new Output(nodes.size()));
        }

        @Procedure
        public Stream<Output> delegatingProcedure(@Name(value="name") long someValue) {
            return this.db.execute("CALL org.neo4j.procedure.simpleArgument", MapUtil.map((Object[])new Object[]{"name", someValue})).stream().map(row -> new Output((Long)row.get("someVal")));
        }

        @Procedure
        public Stream<Output> recursiveSum(@Name(value="order") long order) {
            if (order == 0L) {
                return Stream.of(new Output(0L));
            }
            Long prev = (Long)this.db.execute("CALL org.neo4j.procedure.recursiveSum", MapUtil.map((Object[])new Object[]{"order", order - 1L})).next().get("someVal");
            return Stream.of(new Output(order + prev));
        }

        @Procedure
        public Stream<Output> genericArguments(@Name(value="stringList") List<List<String>> stringList, @Name(value="longList") List<List<List<Long>>> longList) {
            return Stream.of(new Output(stringList.size() + longList.size()));
        }

        @Procedure
        public Stream<Output> mapArgument(@Name(value="map") Map<String, Object> map) {
            return Stream.of(new Output(map.size()));
        }

        @Procedure
        public Stream<MapOutput> mapWithNullDefault(@Name(value="map", defaultValue="null") Map<String, Object> map) {
            return Stream.of(new MapOutput(map));
        }

        @Procedure
        public Stream<MapOutput> mapWithOtherDefault(@Name(value="map", defaultValue="{default: true}") Map<String, Object> map) {
            return Stream.of(new MapOutput(map));
        }

        @Procedure
        public Stream<ListOutput> listWithDefault(@Name(value="list", defaultValue="[42, 1337]") List<Long> list) {
            return Stream.of(new ListOutput(list));
        }

        @Procedure
        public Stream<ListOutput> genericListWithDefault(@Name(value="list", defaultValue="[[42, 1337]]") List<List<Long>> list) {
            return Stream.of(new ListOutput(list == null ? null : list.get(0)));
        }

        @Procedure
        public Stream<NodeOutput> node(@Name(value="id") long id) {
            NodeOutput nodeOutput = new NodeOutput();
            if (id < 0L) {
                nodeOutput.setNode(null);
            } else {
                nodeOutput.setNode(this.db.getNodeById(id));
            }
            return Stream.of(nodeOutput);
        }

        @Procedure
        public Stream<DoubleOutput> squareDouble(@Name(value="value") double value) {
            DoubleOutput output = new DoubleOutput(value * value);
            return Stream.of(output);
        }

        @Procedure
        public Stream<DoubleOutput> avgNumberList(@Name(value="list") List<Number> list) {
            double sum = ((Number)list.stream().reduce((l, r) -> l.doubleValue() + r.doubleValue()).orElse(0.0)).doubleValue();
            int count = list.size();
            DoubleOutput output = new DoubleOutput(sum / (double)count);
            return Stream.of(output);
        }

        @Procedure
        public Stream<DoubleOutput> avgDoubleList(@Name(value="list") List<Double> list) {
            double sum = list.stream().reduce((l, r) -> l + r).orElse(0.0);
            int count = list.size();
            DoubleOutput output = new DoubleOutput(sum / (double)count);
            return Stream.of(output);
        }

        @Procedure
        public Stream<Output> squareLong(@Name(value="value") long value) {
            Output output = new Output(value * value);
            return Stream.of(output);
        }

        @Procedure
        public Stream<Output> throwsExceptionInStream() {
            return Stream.generate(() -> {
                throw new RuntimeException("Kaboom");
            });
        }

        @Procedure
        public Stream<Output> indexOutOfBounds() {
            int[] ints = new int[]{1, 2, 3};
            int foo = ints[4];
            return Stream.of(new Output());
        }

        @Procedure
        public Stream<MyOutputRecord> listCoolPeopleInDatabase() {
            return this.db.findNodes(Label.label((String)"Person")).stream().map(n -> new MyOutputRecord((String)n.getProperty("name")));
        }

        @Procedure
        public Stream<Output> logAround() {
            this.log.debug("1");
            this.log.info("2");
            this.log.warn("3");
            this.log.error("4");
            return Stream.empty();
        }

        @Procedure
        public Stream<Output> readOnlyTryingToWrite() {
            this.db.createNode();
            return Stream.empty();
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<Output> writingProcedure() {
            this.db.createNode();
            return Stream.empty();
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<NodeOutput> createNode(@Name(value="value") String value) {
            Node node = this.db.createNode();
            node.setProperty("prop", (Object)value);
            NodeOutput out = new NodeOutput();
            out.setNode(node);
            return Stream.of(out);
        }

        @Procedure
        public Stream<Output> readOnlyCallingWriteProcedure() {
            return this.db.execute("CALL org.neo4j.procedure.writingProcedure").stream().map(row -> new Output(0L));
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<Output> writeProcedureCallingWriteProcedure() {
            return this.db.execute("CALL org.neo4j.procedure.writingProcedure").stream().map(row -> new Output(0L));
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<Output> writeProcedureCallingReadProcedure() {
            return this.db.execute("CALL org.neo4j.procedure.integrationTestMe").stream().map(row -> new Output(0L));
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<Output> writeProcedureCallingSchemaProcedure() {
            return this.db.execute("CALL org.neo4j.procedure.schemaProcedure").stream().map(row -> new Output(0L));
        }

        @Procedure(mode=Mode.WRITE)
        public void sideEffect(@Name(value="value") String value) {
            this.db.createNode(new Label[]{Label.label((String)value)});
        }

        @Procedure(mode=Mode.WRITE)
        public void sideEffectWithDefault(@Name(value="label") String label, @Name(value="propertyKey") String propertyKey, @Name(value="value", defaultValue="Zhang Wei") String value) {
            this.db.createNode(new Label[]{Label.label((String)label)}).setProperty(propertyKey, (Object)value);
        }

        @Procedure
        public void shutdown() {
            this.db.shutdown();
        }

        @Procedure(mode=Mode.WRITE)
        public void delegatingSideEffect(@Name(value="value") String value) {
            this.db.execute("CALL org.neo4j.procedure.sideEffect", MapUtil.map((Object[])new Object[]{"value", value}));
        }

        @Procedure(mode=Mode.WRITE)
        public void supportedProcedure() throws ExecutionException, InterruptedException {
            jobs.submit(() -> {
                try (Transaction tx = this.db.beginTx();){
                    this.db.createNode();
                    tx.success();
                }
                catch (Exception e) {
                    exceptionsInProcedure.add(e);
                }
            }).get();
        }

        @Procedure
        public Stream<PathOutputRecord> nodePaths(@Name(value="node") Node node) {
            return this.db.execute("WITH {node} AS node MATCH p=(node)-[*]->() RETURN p", MapUtil.map((Object[])new Object[]{"node", node})).stream().map(record -> new PathOutputRecord(record.getOrDefault("p", null)));
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<NodeOutput> nodeWithDefault(@Name(value="node", defaultValue="null") Node node) {
            return Stream.of(new NodeOutput(node));
        }

        @Description(value="This is a description")
        @Procedure(mode=Mode.WRITE)
        public Stream<NodeOutput> nodeWithDescription(@Name(value="node") Node node) {
            return Stream.of(new NodeOutput(node));
        }

        @Procedure(mode=Mode.WRITE)
        public Stream<NodeListRecord> nodeList() {
            ArrayList<Node> nodesList = new ArrayList<Node>();
            nodesList.add(this.db.createNode());
            nodesList.add(this.db.createNode());
            return Stream.of(new NodeListRecord(nodesList));
        }

        @Procedure
        public void readOnlyTryingToWriteSchema() {
            this.db.execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
        }

        @Procedure(mode=Mode.WRITE)
        public void readWriteTryingToWriteSchema() {
            this.db.execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
        }

        @Procedure(mode=Mode.SCHEMA)
        public void schemaProcedure() {
            this.db.execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
        }

        @Procedure(mode=Mode.SCHEMA)
        public Stream<NodeOutput> schemaCallReadProcedure(@Name(value="id") long id) {
            return this.db.execute("CALL org.neo4j.procedure.node(" + id + ")").stream().map(record -> {
                NodeOutput n = new NodeOutput();
                n.setNode((Node)record.get("node"));
                return n;
            });
        }

        @Procedure(mode=Mode.SCHEMA)
        public void schemaTryingToWrite() {
            this.db.execute("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE");
            this.db.createNode();
        }

        @Procedure(name="org.neo4j.procedure.onCloseProcedure")
        public Stream<Output> onCloseProcedure(@Name(value="index") long index) {
            ProcedureIT.onCloseCalled[(int)index] = false;
            return (Stream)Stream.of(1L, 2L).map(Output::new).onClose(() -> {
                ProcedureIT.onCloseCalled[(int)index] = true;
            });
        }
    }

    public static class NodeListRecord {
        public List<Node> nodes;

        public NodeListRecord(List<Node> nodes) {
            this.nodes = nodes;
        }
    }

    public static class PathOutputRecord {
        public Path path;

        public PathOutputRecord(Path path) {
            this.path = path;
        }
    }

    public static class MyOutputRecord {
        public String name;

        public MyOutputRecord(String name) {
            this.name = name;
        }
    }

    public static class NodeOutput {
        public Node node;

        public NodeOutput() {
        }

        public NodeOutput(Node node) {
            this.node = node;
        }

        void setNode(Node node) {
            this.node = node;
        }
    }

    public static class DoubleOutput {
        public double result;

        public DoubleOutput() {
        }

        public DoubleOutput(double result) {
            this.result = result;
        }
    }

    public static class ListOutput {
        public List<Long> list;

        public ListOutput(List<Long> list) {
            this.list = list;
        }
    }

    public static class MapOutput {
        public Map<String, Object> map;

        public MapOutput(Map<String, Object> map) {
            this.map = map;
        }
    }

    public static class PrimitiveOutput {
        public String string;
        public long integer;
        public double aFloat;
        public boolean aBoolean;

        public PrimitiveOutput(String string, long integer, double aFloat, boolean aBoolean) {
            this.string = string;
            this.integer = integer;
            this.aFloat = aFloat;
            this.aBoolean = aBoolean;
        }
    }

    public static class Output {
        public long someVal = 1337L;

        public Output() {
        }

        public Output(long someVal) {
            this.someVal = someVal;
        }
    }
}

