/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.test.rule.concurrent.ThreadingRule;

public class ListQueriesProcedureInClusterIT {
    private static final int THIRTY_SECONDS_TIMEOUT = 30;
    private final ClusterRule clusterRule = new ClusterRule(this.getClass()).withNumberOfCoreMembers(3).withNumberOfReadReplicas(1);
    private final VerboseTimeout timeout = VerboseTimeout.builder().withTimeout(1000L, TimeUnit.SECONDS).build();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.clusterRule).around((TestRule)this.timeout);
    private Cluster cluster;
    @Rule
    public final ThreadingRule threads = new ThreadingRule();

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void listQueriesWillNotIncludeQueriesFromOtherServersInCluster() throws Exception {
        Label testLabel = Label.label((String)"testLabel");
        String propertyName = "number";
        String CORE_QUERY = "MATCH (n:" + testLabel.name() + ") WHERE n.number = 10 SET n.number = n.number - 1";
        CountDownLatch resourceLocked = new CountDownLatch(1);
        CountDownLatch listQueriesLatchOnCore = new CountDownLatch(1);
        CountDownLatch executedCoreQueryLatch = new CountDownLatch(1);
        ReadReplicaGraphDatabase replicaDb = this.cluster.findAnyReadReplica().database();
        Node[] node = new Node[1];
        CoreClusterMember leader = this.cluster.coreTx((leaderDb, tx) -> {
            node[0] = leaderDb.createNode(new Label[]{testLabel});
            node[0].setProperty(propertyName, (Object)10);
            tx.success();
            tx.close();
        });
        this.createTestIndex(testLabel, propertyName);
        CoreGraphDatabase leaderDb2 = leader.database();
        Result matchAllResult = leaderDb2.execute("MATCH (n) RETURN n");
        Assert.assertTrue((String)"setup should have created a node", (boolean)matchAllResult.hasNext());
        matchAllResult.close();
        this.acquireLocksAndSetupCountdownLatch(resourceLocked, listQueriesLatchOnCore, node[0]);
        resourceLocked.await();
        this.threads.executeAndAwait(this.executeQueryOnLeader(CORE_QUERY, executedCoreQueryLatch), null, ThreadingRule.waitingWhileIn(GraphDatabaseFacade.class, (String)"execute"), 30L, TimeUnit.SECONDS);
        Optional<Map<String, Object>> coreQueryListing1 = this.getQueryListing(CORE_QUERY, (GraphDatabaseFacade)leaderDb2);
        Optional<Map<String, Object>> replicaQueryListing = this.getQueryListing(CORE_QUERY, (GraphDatabaseFacade)replicaDb);
        Optional<Map<String, Object>> coreQueryListing2 = this.getQueryListing(CORE_QUERY, (GraphDatabaseFacade)leaderDb2);
        Assert.assertTrue((String)"query should be visible on core", (boolean)coreQueryListing1.isPresent());
        MatcherAssert.assertThat((Object)coreQueryListing1.get().get("activeLockCount"), (Matcher)Is.is((Object)1L));
        Assert.assertFalse((String)"query should not be visible on replica", (boolean)replicaQueryListing.isPresent());
        Assert.assertTrue((String)"query should be visible on core after it being determined not present on replicas", (boolean)coreQueryListing2.isPresent());
        listQueriesLatchOnCore.countDown();
        executedCoreQueryLatch.await();
        Assert.assertFalse((boolean)this.getQueryListing(CORE_QUERY, (GraphDatabaseFacade)leaderDb2).isPresent());
    }

    private void createTestIndex(Label testLabel, String propertyName) throws Exception {
        this.cluster.coreTx((leaderDb, tx) -> {
            leaderDb.schema().indexFor(testLabel).on(propertyName).create();
            tx.success();
        });
        this.cluster.coreTx((leaderDb, tx) -> {
            leaderDb.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        });
    }

    private ThrowingFunction<Void, Void, Exception> executeQueryOnLeader(String CORE_QUERY, CountDownLatch executedCoreQueryLatch) {
        return db -> {
            this.cluster.coreTx((coreDb, tx) -> coreDb.execute(CORE_QUERY));
            executedCoreQueryLatch.countDown();
            return null;
        };
    }

    private void acquireLocksAndSetupCountdownLatch(CountDownLatch resourceLocked, CountDownLatch listQueriesLatch, Node node) {
        this.threads.execute(param -> {
            this.cluster.coreTx((leaderDb, tx) -> {
                tx.acquireWriteLock((PropertyContainer)node);
                resourceLocked.countDown();
                try {
                    listQueriesLatch.await();
                }
                catch (InterruptedException e) {
                    throw new AssertionError("failure in locking node", e);
                }
            });
            return null;
        }, null);
    }

    private Optional<Map<String, Object>> getQueryListing(String query, GraphDatabaseFacade db) {
        try (Result rows = db.execute("CALL dbms.listQueries()");){
            while (rows.hasNext()) {
                Map row = rows.next();
                if (!query.equals(row.get("query"))) continue;
                Optional<Map<String, Object>> optional = Optional.of(row);
                return optional;
            }
        }
        return Optional.empty();
    }
}

