/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.auth;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Rule;
import org.neo4j.auth.FlatFileStressBase;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class FlatFilePredictableStressIT
extends FlatFileStressBase {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Override
    FileSystemAbstraction getFileSystem() {
        return this.fsRule.get();
    }

    @Override
    ExecutorService setupWorkload(int n) {
        ExecutorService service = Executors.newFixedThreadPool(2 * n);
        for (int i = 0; i < n; ++i) {
            service.submit(new IrrationalUserAdmin(i));
            service.submit(new IrrationalRoleAdmin(i));
        }
        return service;
    }

    private class IrrationalRoleAdmin
    extends FlatFileStressBase.IrrationalAdmin {
        private final String username;
        private final String roleName;
        private boolean exists;

        IrrationalRoleAdmin(int number) {
            super(FlatFilePredictableStressIT.this);
            this.username = "user" + number;
            this.roleName = "role" + number;
            this.exists = false;
            this.setActions(this::createRole, this::deleteRole, this::assignRole, this::unAssignRole);
        }

        public String toString() {
            return "IrrationalRoleAdmin " + this.roleName;
        }

        private void createRole() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.newRole(this.roleName, new String[]{this.username});
                    this.exists = true;
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validRoleExists(e) || this.userDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void deleteRole() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.deleteRole(this.roleName);
                    this.exists = false;
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validRoleDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void assignRole() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.addRoleToUser(this.roleName, "neo4j");
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validRoleDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void unAssignRole() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.removeRoleFromUser(this.roleName, "neo4j");
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validRoleDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private boolean validRoleExists(InvalidArgumentsException e) {
            return this.exists && e.getMessage().contains("The specified role '" + this.roleName + "' already exists");
        }

        private boolean validRoleDoesNotExist(InvalidArgumentsException e) {
            return !this.exists && e.getMessage().contains("Role '" + this.roleName + "' does not exist");
        }

        private boolean userDoesNotExist(InvalidArgumentsException e) {
            return e.getMessage().contains("User '" + this.username + "' does not exist");
        }
    }

    private class IrrationalUserAdmin
    extends FlatFileStressBase.IrrationalAdmin {
        private final String username;
        private String password;
        private boolean exists;
        private final String[] PREDEFINED_ROLES;

        IrrationalUserAdmin(int number) {
            super(FlatFilePredictableStressIT.this);
            this.PREDEFINED_ROLES = new String[]{"reader", "publisher", "architect", "admin"};
            this.username = "user" + number;
            this.password = this.deviousPassword();
            this.exists = false;
            this.setActions(this::createUser, this::deleteUser, this::changePassword, this::suspend, this::activate, this::assignRole, this::unAssignRole);
        }

        public String toString() {
            return "IrrationalUserAdmin " + this.username;
        }

        private void createUser() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.newUser(this.username, this.password, false);
                    this.exists = true;
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.exists && e.getMessage().contains("The specified user '" + this.username + "' already exists")) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void deleteUser() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.deleteUser(this.username);
                    this.exists = false;
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validUserDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void changePassword() {
            block3: {
                String newPassword = this.deviousPassword();
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.setUserPassword(this.username, newPassword, false);
                    this.password = newPassword;
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validUserDoesNotExist(e) || this.validSamePassword(newPassword, e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void suspend() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.suspendUser(this.username);
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validUserDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void activate() {
            block3: {
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.activateUser(this.username, false);
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validUserDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void assignRole() {
            block3: {
                String role = this.randomRole();
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.addRoleToUser(role, this.username);
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validUserDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private void unAssignRole() {
            block3: {
                String role = this.randomRole();
                try {
                    FlatFilePredictableStressIT.this.flatFileRealm.removeRoleFromUser(role, this.username);
                }
                catch (IOException e) {
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
                catch (InvalidArgumentsException e) {
                    if (this.validUserDoesNotExist(e)) break block3;
                    FlatFilePredictableStressIT.this.errors.add(e);
                }
            }
        }

        private String deviousPassword() {
            return this.random.nextBoolean() ? "123" : "321";
        }

        private String randomRole() {
            return this.PREDEFINED_ROLES[this.random.nextInt(this.PREDEFINED_ROLES.length)];
        }

        private boolean validSamePassword(String newPassword, InvalidArgumentsException e) {
            return newPassword.equals(this.password) && e.getMessage().contains("Old password and new password cannot be the same.");
        }

        private boolean validUserDoesNotExist(InvalidArgumentsException e) {
            return !this.exists && e.getMessage().contains("User '" + this.username + "' does not exist");
        }
    }
}

