/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storeupgrade;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.Unzip;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Enclosed.class)
public class StoreUpgradeIntegrationTest {
    private static final List<Store[]> STORES23 = Arrays.asList({new Store("0.A.6-empty.zip", 0L, 1L, StoreUpgradeIntegrationTest.selectivities(new double[0]), StoreUpgradeIntegrationTest.indexCounts(new long[0][]))}, {new Store("0.A.6-data.zip", 174L, 30L, StoreUpgradeIntegrationTest.selectivities(1.0, 1.0, 1.0), StoreUpgradeIntegrationTest.indexCounts(StoreUpgradeIntegrationTest.counts(0L, 38L, 38L, 38L), StoreUpgradeIntegrationTest.counts(0L, 1L, 1L, 1L), StoreUpgradeIntegrationTest.counts(0L, 133L, 133L, 133L)))});
    private static final List<Store[]> STORES300 = Arrays.asList({new Store("E.H.0-empty.zip", 0L, 1L, StoreUpgradeIntegrationTest.selectivities(new double[0]), StoreUpgradeIntegrationTest.indexCounts(new long[0][]), "high_limit")}, {new Store("E.H.0-data.zip", 174L, 30L, StoreUpgradeIntegrationTest.selectivities(1.0, 1.0, 1.0), StoreUpgradeIntegrationTest.indexCounts(StoreUpgradeIntegrationTest.counts(0L, 38L, 38L, 38L), StoreUpgradeIntegrationTest.counts(0L, 1L, 1L, 1L), StoreUpgradeIntegrationTest.counts(0L, 133L, 133L, 133L)), "high_limit")});

    private static void checkInstance(Store store, GraphDatabaseAPI db) throws KernelException {
        StoreUpgradeIntegrationTest.checkProvidedParameters(store, db);
        StoreUpgradeIntegrationTest.checkGlobalNodeCount(store, db);
        StoreUpgradeIntegrationTest.checkLabelCounts(db);
        StoreUpgradeIntegrationTest.checkIndexCounts(store, db);
    }

    private static void checkIndexCounts(Store store, GraphDatabaseAPI db) throws KernelException {
        KernelAPI kernel = (KernelAPI)db.getDependencyResolver().resolveDependency(KernelAPI.class);
        try (KernelTransaction tx = kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());
             Statement statement = tx.acquireStatement();){
            Iterator indexes = IndexDescriptor.sortByType(StoreUpgradeIntegrationTest.getAllIndexes(statement));
            Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
            int i = 0;
            while (indexes.hasNext()) {
                IndexDescriptor descriptor = (IndexDescriptor)indexes.next();
                StoreUpgradeIntegrationTest.awaitOnline(statement.readOperations(), descriptor);
                StoreUpgradeIntegrationTest.assertDoubleLongEquals(store.indexCounts[i][0], store.indexCounts[i][1], statement.readOperations().indexUpdatesAndSize(descriptor, register));
                StoreUpgradeIntegrationTest.assertDoubleLongEquals(store.indexCounts[i][2], store.indexCounts[i][3], statement.readOperations().indexSample(descriptor, register));
                double selectivity = statement.readOperations().indexUniqueValuesSelectivity(descriptor);
                Assert.assertEquals((double)store.indexSelectivity[i], (double)selectivity, (double)1.0E-7);
                ++i;
            }
        }
    }

    private static Iterator<IndexDescriptor> getAllIndexes(Statement statement) {
        return statement.readOperations().indexesGetAll();
    }

    private static void checkLabelCounts(GraphDatabaseAPI db) {
        try (Transaction ignored = db.beginTx();){
            HashMap<Label, Long> counts = new HashMap<Label, Long>();
            for (Node node : db.getAllNodes()) {
                for (Label label : node.getLabels()) {
                    Long count = (Long)counts.get(label);
                    if (count != null) {
                        counts.put(label, count + 1L);
                        continue;
                    }
                    counts.put(label, 1L);
                }
            }
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            Statement statement = bridge.get();
            for (Map.Entry entry : counts.entrySet()) {
                Assert.assertEquals((long)((Long)entry.getValue()), (long)statement.readOperations().countsForNode(statement.readOperations().labelGetForName(((Label)entry.getKey()).name())));
            }
        }
    }

    private static void checkGlobalNodeCount(Store store, GraphDatabaseAPI db) {
        try (Transaction ignored = db.beginTx();){
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            Statement statement = bridge.get();
            Assert.assertThat((Object)statement.readOperations().countsForNode(-1), (Matcher)Matchers.is((Object)store.expectedNodeCount));
        }
    }

    private static void checkProvidedParameters(Store store, GraphDatabaseAPI db) {
        try (Transaction ignored = db.beginTx();){
            long nodeCount = Iterables.count((Iterable)db.getAllNodes());
            Assert.assertThat((Object)nodeCount, (Matcher)Matchers.is((Object)store.expectedNodeCount));
            long indexCount = Iterables.count((Iterable)db.schema().getIndexes());
            Assert.assertThat((Object)indexCount, (Matcher)Matchers.is((Object)store.indexes()));
            TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
            long lastCommittedTxId = txIdStore.getLastCommittedTransactionId();
            try (Statement statement = ((ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true).acquireStatement();){
                long countsTxId = ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getCounts().txId();
                Assert.assertEquals((long)lastCommittedTxId, (long)countsTxId);
                Assert.assertThat((Object)lastCommittedTxId, (Matcher)Matchers.is((Object)store.lastTxId));
            }
        }
    }

    private static void assertDoubleLongEquals(long expectedFirst, long expectedSecond, Register.DoubleLongRegister register) {
        long first = register.readFirst();
        long second = register.readSecond();
        String msg = String.format("Expected (%d,%d), got (%d,%d)", expectedFirst, expectedSecond, first, second);
        Assert.assertEquals((String)msg, (long)expectedFirst, (long)first);
        Assert.assertEquals((String)msg, (long)expectedSecond, (long)second);
    }

    private static double[] selectivities(double ... selectivity) {
        return selectivity;
    }

    private static long[][] indexCounts(long[] ... counts) {
        return counts;
    }

    private static long[] counts(long upgrade, long size, long unique, long sampleSize) {
        return new long[]{upgrade, size, unique, sampleSize};
    }

    private static IndexDescriptor awaitOnline(ReadOperations readOperations, IndexDescriptor index) throws KernelException {
        long start = System.currentTimeMillis();
        long end = start + 20000L;
        while (System.currentTimeMillis() < end) {
            switch (readOperations.indexGetState(index)) {
                case ONLINE: {
                    return index;
                }
                case FAILED: {
                    throw new IllegalStateException("Index failed instead of becoming ONLINE");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new IllegalStateException("Index did not become ONLINE within reasonable time");
    }

    private static class Store {
        private final String resourceName;
        final long expectedNodeCount;
        final long lastTxId;
        private final double[] indexSelectivity;
        final long[][] indexCounts;
        private final String formatFamily;

        private Store(String resourceName, long expectedNodeCount, long lastTxId, double[] indexSelectivity, long[][] indexCounts) {
            this(resourceName, expectedNodeCount, lastTxId, indexSelectivity, indexCounts, "standard");
        }

        private Store(String resourceName, long expectedNodeCount, long lastTxId, double[] indexSelectivity, long[][] indexCounts, String formatFamily) {
            this.resourceName = resourceName;
            this.expectedNodeCount = expectedNodeCount;
            this.lastTxId = lastTxId;
            this.indexSelectivity = indexSelectivity;
            this.indexCounts = indexCounts;
            this.formatFamily = formatFamily;
        }

        File prepareDirectory(File targetDir) throws IOException {
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                throw new IOException("Could not create directory " + targetDir);
            }
            Unzip.unzip(this.getClass(), (String)this.resourceName, (File)targetDir);
            new File(targetDir, "debug.log").delete();
            return targetDir;
        }

        public String toString() {
            return "Store: " + this.resourceName;
        }

        long indexes() {
            return this.indexCounts.length;
        }

        String getFormatFamily() {
            return this.formatFamily;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class StoreUpgrade22Test {
        @Parameterized.Parameter(value=0)
        public Store store;
        @Rule
        public TestDirectory testDir = TestDirectory.testDirectory();

        @Parameterized.Parameters(name="{0}")
        public static Collection<Store[]> stores() {
            return Iterables.asCollection((Iterable)Iterables.concat((Iterable[])new Iterable[]{STORES23, STORES300}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void shouldBeAbleToUpgradeAStoreWithoutIdFilesAsBackups() throws Throwable {
            File[] idFiles;
            File dir = this.store.prepareDirectory(this.testDir.graphDbDir());
            for (File idFile : idFiles = dir.listFiles((dir1, name) -> name.endsWith(".id"))) {
                Assert.assertTrue((boolean)idFile.delete());
            }
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(dir);
            builder.setConfig(GraphDatabaseSettings.allow_store_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.record_format, this.store.getFormatFamily());
            GraphDatabaseService db = builder.newGraphDatabase();
            try {
                StoreUpgradeIntegrationTest.checkInstance(this.store, (GraphDatabaseAPI)db);
            }
            finally {
                db.shutdown();
            }
            StoreAssertions.assertConsistentStore((File)dir);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class StoreUpgradeFailingTest {
        @Rule
        public TestDirectory testDir = TestDirectory.testDirectory();
        @Parameterized.Parameter(value=0)
        public String ignored;
        @Parameterized.Parameter(value=1)
        public String dbFileName;

        @Parameterized.Parameters(name="{0}")
        public static Collection<String[]> parameters() {
            return Arrays.asList({"on a not cleanly shutdown database", "0.A.3-to-be-recovered.zip"}, {"on a 1.9 store", "0.A.0-db.zip"}, {"on a 2.0 store", "0.A.1-db.zip"}, {"on a 2.1 store", "0.A.3-data.zip"}, {"on a 2.2 store", "0.A.5-data.zip"});
        }

        @Test
        public void migrationShouldFail() throws Throwable {
            File dir = Unzip.unzip(this.getClass(), (String)this.dbFileName, (File)this.testDir.graphDbDir());
            new File(dir, "debug.log").delete();
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(dir);
            builder.setConfig(GraphDatabaseSettings.allow_store_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
            try {
                builder.newGraphDatabase();
                Assert.fail((String)"It should have failed.");
            }
            catch (RuntimeException ex) {
                Assert.assertTrue((boolean)(ex.getCause() instanceof LifecycleException));
                Throwable realException = ex.getCause().getCause();
                Assert.assertTrue((String)"Unexpected exception", (boolean)Exceptions.contains((Throwable)realException, (Class[])new Class[]{StoreUpgrader.UnexpectedUpgradingStoreVersionException.class}));
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class StoreUpgradeTest {
        @Parameterized.Parameter(value=0)
        public Store store;
        @Rule
        public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
        @Rule
        public TestDirectory testDir = TestDirectory.testDirectory();

        @Parameterized.Parameters(name="{0}")
        public static Collection<Store[]> stores() {
            return Iterables.asCollection((Iterable)Iterables.concat((Iterable[])new Iterable[]{STORES23, STORES300}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void embeddedDatabaseShouldStartOnOlderStoreWhenUpgradeIsEnabled() throws Throwable {
            File dir = this.store.prepareDirectory(this.testDir.graphDbDir());
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(dir);
            builder.setConfig(GraphDatabaseSettings.allow_store_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
            builder.setConfig(GraphDatabaseSettings.logs_directory, this.testDir.directory("logs").getAbsolutePath());
            GraphDatabaseService db = builder.newGraphDatabase();
            try {
                StoreUpgradeIntegrationTest.checkInstance(this.store, (GraphDatabaseAPI)db);
            }
            finally {
                db.shutdown();
            }
            StoreAssertions.assertConsistentStore((File)dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void serverDatabaseShouldStartOnOlderStoreWhenUpgradeIsEnabled() throws Throwable {
            File rootDir = this.testDir.directory();
            File storeDir = (File)Config.defaults((Setting)DatabaseManagementSystemSettings.data_directory, (String)rootDir.toString()).get(DatabaseManagementSystemSettings.database_path);
            this.store.prepareDirectory(storeDir);
            File configFile = new File(rootDir, "neo4j.conf");
            Properties props = new Properties();
            props.putAll((Map<?, ?>)ServerTestUtils.getDefaultRelativeProperties());
            props.setProperty(DatabaseManagementSystemSettings.data_directory.name(), rootDir.getAbsolutePath());
            props.setProperty(GraphDatabaseSettings.logs_directory.name(), rootDir.getAbsolutePath());
            props.setProperty(GraphDatabaseSettings.allow_store_upgrade.name(), "true");
            props.setProperty(GraphDatabaseSettings.pagecache_memory.name(), "8m");
            props.setProperty(new HttpConnector((String)"http").type.name(), "HTTP");
            props.setProperty(new HttpConnector((String)"http").enabled.name(), "true");
            try (FileWriter writer = new FileWriter(configFile);){
                props.store(writer, "");
            }
            CommunityBootstrapper bootstrapper = new CommunityBootstrapper();
            try {
                bootstrapper.start(rootDir.getAbsoluteFile(), Optional.of(configFile), Collections.emptyMap());
                Assert.assertTrue((boolean)bootstrapper.isRunning());
                StoreUpgradeIntegrationTest.checkInstance(this.store, (GraphDatabaseAPI)bootstrapper.getServer().getDatabase().getGraph());
            }
            finally {
                bootstrapper.stop();
            }
            StoreAssertions.assertConsistentStore((File)storeDir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void migratingOlderDataAndThanStartAClusterUsingTheNewerDataShouldWork() throws Throwable {
            HighlyAvailableGraphDatabase slave;
            HighlyAvailableGraphDatabase master;
            File dir = this.store.prepareDirectory(this.testDir.graphDbDir());
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(dir);
            builder.setConfig(GraphDatabaseSettings.allow_store_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
            builder.setConfig(GraphDatabaseSettings.logs_directory, this.testDir.directory("logs").getAbsolutePath());
            GraphDatabaseService db = builder.newGraphDatabase();
            try {
                StoreUpgradeIntegrationTest.checkInstance(this.store, (GraphDatabaseAPI)db);
            }
            finally {
                db.shutdown();
            }
            StoreAssertions.assertConsistentStore((File)dir);
            File haDir = new File(dir.getParentFile(), "ha-stuff");
            FileUtils.deleteRecursively((File)haDir);
            ClusterManager clusterManager = new ClusterManager.Builder(haDir).withSeedDir(dir).withCluster(ClusterManager.clusterOfSize((int)2)).build();
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
            try {
                cluster.await(ClusterManager.allSeesAllAsAvailable());
                master = cluster.getMaster();
                StoreUpgradeIntegrationTest.checkInstance(this.store, (GraphDatabaseAPI)master);
                slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
                StoreUpgradeIntegrationTest.checkInstance(this.store, (GraphDatabaseAPI)slave);
            }
            finally {
                clusterManager.safeShutdown();
            }
            StoreAssertions.assertConsistentStore((File)master.getStoreDir());
            StoreAssertions.assertConsistentStore((File)slave.getStoreDir());
        }
    }
}

