/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.proc.JarBuilder;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.test.TestGraphDatabaseFactory;

public class UserAggregationFunctionIT {
    @Rule
    public TemporaryFolder plugins = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private GraphDatabaseService db;

    @Test
    public void shouldHandleSingleStringArgumentAggregationFunction() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE ({ prop:'foo'})");
            this.db.execute("CREATE ({ prop:'foo'})");
            this.db.execute("CREATE ({ prop:'bar'})");
            this.db.execute("CREATE ({prop:'baz'})");
            this.db.execute("CREATE ()");
            tx.success();
        }
        Result result = this.db.execute("MATCH (n) RETURN org.neo4j.procedure.count(n.prop) AS count");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"count", 4L})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldHandleSingleStringArgumentAggregationFunctionAndGroupingKey() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE ({prop1:42, prop2:'foo'})");
            this.db.execute("CREATE ({prop1:42, prop2:'foo'})");
            this.db.execute("CREATE ({prop1:42, prop2:'bar'})");
            this.db.execute("CREATE ({prop1:1337, prop2:'baz'})");
            this.db.execute("CREATE ({prop1:1337})");
            tx.success();
        }
        Result result = this.db.execute("MATCH (n) RETURN n.prop1, org.neo4j.procedure.count(n.prop2) AS count");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"n.prop1", 1337L, "count", 1L})));
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"n.prop1", 42L, "count", 3L})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldFailNicelyWhenInvalidRuntimeType() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE ({ prop:'foo'})");
            this.db.execute("CREATE ({ prop:'foo'})");
            this.db.execute("CREATE ({ prop:'bar'})");
            this.db.execute("CREATE ({prop:42})");
            this.db.execute("CREATE ()");
            tx.success();
        }
        this.exception.expect(QueryExecutionException.class);
        this.exception.expectMessage("Can't coerce `42` to String");
        this.db.execute("MATCH (n) RETURN org.neo4j.procedure.count(n.prop) AS count");
    }

    @Test
    public void shouldHandleNodeArgumentAggregationFunction() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE ({ level:42})");
            this.db.execute("CREATE ({ level:1337})");
            this.db.execute("CREATE ({ level:0})");
            this.db.execute("CREATE ()");
            tx.success();
        }
        Result result = this.db.execute("MATCH (n) WITH org.neo4j.procedure.findBestNode(n) AS best RETURN best.level AS level");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"level", 1337L})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldHandleRelationshipArgumentAggregationFunction() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE ()-[:T {level:42}]->()");
            this.db.execute("CREATE ()-[:T {level:1337}]->()");
            this.db.execute("CREATE ()-[:T {level:2}]->()");
            this.db.execute("CREATE ()-[:T]->()");
            tx.success();
        }
        Result result = this.db.execute("MATCH ()-[r]->() WITH org.neo4j.procedure.findBestRel(r) AS best RETURN best.level AS level");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"level", 1337L})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldHandlePathArgumentAggregationFunction() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE ()-[:T]->()");
            this.db.execute("CREATE ()-[:T]->()-[:T]->()");
            this.db.execute("CREATE ()-[:T]->()-[:T]->()-[:T]->()");
            tx.success();
        }
        Result result = this.db.execute("MATCH p=()-[:T*]->() WITH org.neo4j.procedure.longestPath(p) AS longest RETURN length(longest) AS len");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"len", 3L})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldHandleNumberArgumentAggregationFunction() {
        Result result = this.db.execute("UNWIND [43, 42.5, 41.9, 1337] AS num RETURN org.neo4j.procedure.near42(num) AS closest");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"closest", 41.9})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldHandleDoubleArgumentAggregationFunction() {
        Result result = this.db.execute("UNWIND [43, 42.5, 41.9, 1337] AS num RETURN org.neo4j.procedure.doubleAggregator(num) AS closest");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"closest", 41.9})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldHandleLongArgumentAggregationFunction() {
        Result result = this.db.execute("UNWIND [43, 42.5, 41.9, 1337] AS num RETURN org.neo4j.procedure.longAggregator(num) AS closest");
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"closest", 42L})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldHandleNoArgumentBooleanAggregationFunction() {
        MatcherAssert.assertThat((Object)this.db.execute("UNWIND [1,2] AS num RETURN org.neo4j.procedure.boolAggregator() AS wasCalled").next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"wasCalled", true})));
        MatcherAssert.assertThat((Object)this.db.execute("UNWIND [] AS num RETURN org.neo4j.procedure.boolAggregator() AS wasCalled").next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"wasCalled", false})));
    }

    @Test
    public void shouldBeAbleToUseAdbInFunction() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try (Transaction tx = this.db.beginTx();){
            nodes.add(this.db.createNode());
            nodes.add(this.db.createNode());
            nodes.add(this.db.createNode());
            nodes.add(this.db.createNode());
            tx.success();
        }
        Result result = this.db.execute("UNWIND $ids AS ids WITH org.neo4j.procedure.collectNode(ids) AS nodes RETURN nodes", MapUtil.map((Object[])new Object[]{"ids", nodes.stream().map(Node::getId).collect(Collectors.toList())}));
        MatcherAssert.assertThat((Object)result.next(), (Matcher)IsEqual.equalTo((Object)MapUtil.map((Object[])new Object[]{"nodes", nodes})));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Before
    public void setUp() throws IOException {
        new JarBuilder().createJarFor(this.plugins.newFile("myFunctions.jar"), new Class[]{ClassWithFunctions.class});
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.plugin_dir, this.plugins.getRoot().getAbsolutePath()).newGraphDatabase();
    }

    @After
    public void tearDown() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    public static class ClassWithFunctions {
        @Context
        public GraphDatabaseService db;
        @Context
        public Log log;

        @UserAggregationFunction
        public CountAggregator count() {
            return new CountAggregator();
        }

        @UserAggregationFunction
        public RelAggregator findBestRel() {
            return new RelAggregator();
        }

        @UserAggregationFunction
        public LongestPathAggregator longestPath() {
            return new LongestPathAggregator();
        }

        @UserAggregationFunction
        public NodeAggregator findBestNode() {
            return new NodeAggregator();
        }

        @UserAggregationFunction
        public DoubleAggregator doubleAggregator() {
            return new DoubleAggregator();
        }

        @UserAggregationFunction
        public LongAggregator longAggregator() {
            return new LongAggregator();
        }

        @UserAggregationFunction
        public BoolAggregator boolAggregator() {
            return new BoolAggregator();
        }

        @UserAggregationFunction
        public ClosestTo42Aggregator near42() {
            return new ClosestTo42Aggregator();
        }

        @UserAggregationFunction
        public NodeFromIdAggregator collectNode() {
            return new NodeFromIdAggregator(this.db);
        }

        public static class NodeFromIdAggregator {
            private final List<Long> ids = new ArrayList<Long>();
            private final GraphDatabaseService gds;

            public NodeFromIdAggregator(GraphDatabaseService gds) {
                this.gds = gds;
            }

            @UserAggregationUpdate
            public void update(@Name(value="id") long id) {
                this.ids.add(id);
            }

            @UserAggregationResult
            public List<Node> result() {
                return this.ids.stream().map(arg_0 -> ((GraphDatabaseService)this.gds).getNodeById(arg_0)).collect(Collectors.toList());
            }
        }

        public static class BoolAggregator {
            private boolean wasCalled;

            @UserAggregationUpdate
            public void update() {
                this.wasCalled = true;
            }

            @UserAggregationResult
            public boolean result() {
                return this.wasCalled;
            }
        }

        public static class CountAggregator {
            private long count;

            @UserAggregationUpdate
            public void update(@Name(value="in") String in) {
                if (in != null) {
                    ++this.count;
                }
            }

            @UserAggregationResult
            public long result() {
                return this.count;
            }
        }

        public static class LongAggregator {
            private Long closest;

            @UserAggregationUpdate
            public void update(@Name(value="long") Long number) {
                if (number != null) {
                    if (this.closest == null) {
                        this.closest = number;
                    } else if (Math.abs(number - 42L) < Math.abs(this.closest - 42L)) {
                        this.closest = number;
                    }
                }
            }

            @UserAggregationResult
            public Long result() {
                return this.closest;
            }
        }

        public static class DoubleAggregator {
            private Double closest;

            @UserAggregationUpdate
            public void update(@Name(value="double") Double number) {
                if (number != null) {
                    if (this.closest == null) {
                        this.closest = number;
                    } else if (Math.abs(number - 42.0) < Math.abs(this.closest - 42.0)) {
                        this.closest = number;
                    }
                }
            }

            @UserAggregationResult
            public Double result() {
                return this.closest;
            }
        }

        public static class ClosestTo42Aggregator {
            private Number closest;

            @UserAggregationUpdate
            public void update(@Name(value="number") Number number) {
                if (number != null) {
                    if (this.closest == null) {
                        this.closest = number;
                    } else if (Math.abs(number.doubleValue() - 42.0) < Math.abs(this.closest.doubleValue() - 42.0)) {
                        this.closest = number;
                    }
                }
            }

            @UserAggregationResult
            public Number result() {
                return this.closest;
            }
        }

        public static class LongestPathAggregator {
            private Path aggregatePath;
            private int longest;

            @UserAggregationUpdate
            public void update(@Name(value="path") Path path) {
                if (path != null && path.length() > this.longest) {
                    this.longest = path.length();
                    this.aggregatePath = path;
                }
            }

            @UserAggregationResult
            public Path result() {
                return this.aggregatePath;
            }
        }

        public static class RelAggregator {
            private Relationship aggregateRel;

            @UserAggregationUpdate
            public void update(@Name(value="rel") Relationship rel) {
                if (rel != null) {
                    long level = (Long)rel.getProperty("level", (Object)0L);
                    if (this.aggregateRel == null) {
                        this.aggregateRel = rel;
                    } else if (level > (Long)this.aggregateRel.getProperty("level", (Object)0L)) {
                        this.aggregateRel = rel;
                    }
                }
            }

            @UserAggregationResult
            public Relationship result() {
                return this.aggregateRel;
            }
        }

        public static class NodeAggregator {
            private Node aggregateNode;

            @UserAggregationUpdate
            public void update(@Name(value="node") Node node) {
                if (node != null) {
                    long level = (Long)node.getProperty("level", (Object)0L);
                    if (this.aggregateNode == null) {
                        this.aggregateNode = node;
                    } else if (level > (Long)this.aggregateNode.getProperty("level", (Object)0L)) {
                        this.aggregateNode = node;
                    }
                }
            }

            @UserAggregationResult
            public Node result() {
                return this.aggregateNode;
            }
        }
    }
}

