/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.storemigration.LogFiles;
import org.neo4j.test.ha.ClusterRule;

@RunWith(value=Enclosed.class)
public class HAClusterStartupIT {
    private static void createSomeData(GraphDatabaseService oldMaster) {
        try (Transaction tx = oldMaster.beginTx();){
            oldMaster.createNode();
            tx.success();
        }
    }

    private static void deleteAllFilesOn(HighlyAvailableGraphDatabase instance) throws IOException {
        FileUtils.deleteRecursively((File)instance.getStoreDirectory());
    }

    private static void deleteAllLogsOn(HighlyAvailableGraphDatabase instance) {
        HAClusterStartupIT.deleteAllLogsOn(instance.getStoreDirectory());
    }

    private static void deleteAllLogsOn(File storeDirectory) {
        File[] files = storeDirectory.listFiles(LogFiles.FILENAME_FILTER);
        Assert.assertNotNull((Object)files);
        for (File file : files) {
            FileUtils.deleteFile((File)file);
        }
    }

    private static void restartingTheClusterShouldWork(ClusterRule clusterRule) throws Exception {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        try {
            cluster.await(ClusterManager.allSeesAllAsAvailable(), 180);
        }
        finally {
            clusterRule.shutdownCluster();
        }
        HAClusterStartupIT.assertAllStoreConsistent(cluster);
    }

    private static void assertAllStoreConsistent(ClusterManager.ManagedCluster cluster) throws ConsistencyCheckIncompleteException, IOException {
        for (HighlyAvailableGraphDatabase slave : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            StoreAssertions.assertConsistentStore((File)slave.getStoreDirectory());
        }
    }

    public static class ClusterWithSeed {
        @Rule
        public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withCluster(ClusterManager.clusterOfSize((int)3)).withSeedDir(ClusterWithSeed.dbWithOutLogs());

        @Test
        public void aClusterShouldStartAndRunWhenSeededWithAStoreHavingNoLogicalLogFiles() throws Throwable {
            HAClusterStartupIT.restartingTheClusterShouldWork(this.clusterRule);
        }

        private static File dbWithOutLogs() {
            File seedDir;
            try {
                seedDir = Files.createTempDirectory("seed-database", new FileAttribute[0]).toFile();
                seedDir.deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            GraphDatabaseService db = null;
            try {
                db = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabase(seedDir);
                HAClusterStartupIT.createSomeData(db);
            }
            finally {
                if (db != null) {
                    db.shutdown();
                }
            }
            HAClusterStartupIT.deleteAllLogsOn(seedDir);
            return seedDir;
        }
    }

    public static class SimpleCluster {
        @Rule
        public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withCluster(ClusterManager.clusterOfSize((int)3));
        private HighlyAvailableGraphDatabase oldMaster;
        private HighlyAvailableGraphDatabase oldSlave1;
        private HighlyAvailableGraphDatabase oldSlave2;

        @Before
        public void setup() throws Throwable {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            try {
                cluster.await(ClusterManager.allSeesAllAsAvailable());
                this.oldMaster = cluster.getMaster();
                HAClusterStartupIT.createSomeData((GraphDatabaseService)this.oldMaster);
                cluster.sync(new HighlyAvailableGraphDatabase[0]);
                this.oldSlave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
                this.oldSlave2 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{this.oldSlave1});
            }
            finally {
                this.clusterRule.shutdownCluster();
            }
            HAClusterStartupIT.assertAllStoreConsistent(cluster);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void allClusterNodesShouldSupportTheBuiltInProcedures() throws Throwable {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            try {
                for (HighlyAvailableGraphDatabase gdb : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                    Result result = gdb.execute("CALL dbms.procedures()");
                    Assert.assertTrue((boolean)result.hasNext());
                    result.close();
                    InternalTransaction tx = gdb.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)EnterpriseSecurityContext.AUTH_DISABLED);
                    Throwable throwable = null;
                    try {
                        Result result2 = gdb.execute(tx, "CALL dbms.listQueries()", Collections.emptyMap());
                        Assert.assertTrue((boolean)result2.hasNext());
                        result2.close();
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
            }
            finally {
                cluster.shutdown();
            }
        }

        @Test
        public void aSlaveWithoutAnyGraphDBFilesShouldBeAbleToJoinACluster() throws Throwable {
            HAClusterStartupIT.deleteAllFilesOn(this.oldSlave1);
            HAClusterStartupIT.restartingTheClusterShouldWork(this.clusterRule);
        }

        @Test
        public void bothSlavesWithoutAnyGraphDBFilesShouldBeAbleToJoinACluster() throws Throwable {
            HAClusterStartupIT.deleteAllFilesOn(this.oldSlave1);
            HAClusterStartupIT.deleteAllFilesOn(this.oldSlave2);
            HAClusterStartupIT.restartingTheClusterShouldWork(this.clusterRule);
        }

        @Test
        public void theMasterWithoutAnyGraphDBFilesShouldBeAbleToJoinACluster() throws Throwable {
            HAClusterStartupIT.deleteAllFilesOn(this.oldMaster);
            HAClusterStartupIT.restartingTheClusterShouldWork(this.clusterRule);
        }

        @Test
        public void aSlaveWithoutLogicalLogFilesShouldBeAbleToJoinACluster() throws Throwable {
            HAClusterStartupIT.deleteAllLogsOn(this.oldSlave1);
            HAClusterStartupIT.restartingTheClusterShouldWork(this.clusterRule);
        }

        @Test
        public void bothSlaveWithoutLogicalLogFilesShouldBeAbleToJoinACluster() throws Throwable {
            HAClusterStartupIT.deleteAllLogsOn(this.oldSlave1);
            HAClusterStartupIT.deleteAllLogsOn(this.oldSlave2);
            HAClusterStartupIT.restartingTheClusterShouldWork(this.clusterRule);
        }
    }
}

