/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.time.Clock;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.bolt.GraphDatabaseFactoryWithCustomBoltKernelExtension;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.MonitoredWorkerFactory;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.bolt.v1.transport.BoltProtocolV1;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class BoltFailuresIT {
    private static final int TEST_TIMEOUT = 20000;
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory();
    private GraphDatabaseService db;
    private Driver driver;
    private Session session;

    @After
    public void shutdownDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.session, this.driver});
    }

    @Test(timeout=20000L)
    public void throwsWhenWorkerCreationFails() {
        WorkerFactory workerFactory = (WorkerFactory)Mockito.mock(WorkerFactory.class);
        Mockito.when((Object)workerFactory.newWorker((BoltConnectionDescriptor)Matchers.anyObject(), (Runnable)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException("Oh!")});
        BoltKernelExtensionWithWorkerFactory extension = new BoltKernelExtensionWithWorkerFactory(workerFactory);
        this.db = this.startDbWithBolt(new GraphDatabaseFactoryWithCustomBoltKernelExtension(extension));
        try {
            this.driver = BoltFailuresIT.createDriver();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    @Test(timeout=20000L)
    public void throwsWhenMonitoredWorkerCreationFails() {
        ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
        sessionMonitor.throwInSessionStarted();
        Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
        this.db = this.startDbWithBolt(new GraphDatabaseFactory().setMonitors(monitors));
        try {
            this.driver = BoltFailuresIT.createDriver();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    @Test(timeout=20000L)
    public void throwsWhenInitMessageReceiveFails() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInMessageReceived, false);
    }

    @Test(timeout=20000L)
    public void throwsWhenInitMessageProcessingFailsToStart() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInProcessingStarted, false);
    }

    @Test(timeout=20000L)
    public void throwsWhenInitMessageProcessingFailsToComplete() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInProcessingDone, true);
    }

    @Test(timeout=20000L)
    public void throwsWhenRunMessageReceiveFails() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInMessageReceived);
    }

    @Test(timeout=20000L)
    public void throwsWhenRunMessageProcessingFailsToStart() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInProcessingStarted);
    }

    @Test(timeout=20000L)
    public void throwsWhenRunMessageProcessingFailsToComplete() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInProcessingDone);
    }

    @Test
    public void boltServerLogsRealErrorWhenDriverIsClosedWithRunningTransactions() throws Exception {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider();
        this.db = this.startTestDb((LogProvider)internalLogProvider);
        this.db.execute("CREATE (:Node)").close();
        org.neo4j.graphdb.Transaction tx = this.db.beginTx();
        Node node = (Node)Iterators.single((Iterator)this.db.findNodes(Label.label((String)"Node")));
        tx.acquireWriteLock((PropertyContainer)node);
        Driver driver = BoltFailuresIT.createDriver();
        Future<?> writeThroughDriverFuture = this.updateAllNodesAsync(driver);
        this.awaitNumberOfActiveQueriesToBe(1);
        driver.close();
        BoltFailuresIT.expectFailure(writeThroughDriverFuture);
        this.awaitNumberOfActiveQueriesToBe(0);
        internalLogProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(BoltProtocolV1.class).warn(org.hamcrest.Matchers.startsWith((String)"Unable to send error back to the client"), org.hamcrest.Matchers.instanceOf(TransactionTerminatedException.class))});
    }

    private void throwsWhenInitMessageFails(Consumer<ThrowingSessionMonitor> monitorSetup, boolean shouldBeAbleToBeginTransaction) {
        block27: {
            ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
            monitorSetup.accept(sessionMonitor);
            Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
            this.db = this.startTestDb(monitors);
            try {
                this.driver = GraphDatabase.driver((String)"bolt://localhost", (Config)Config.build().withoutEncryption().toConfig());
                if (shouldBeAbleToBeginTransaction) {
                    try (Session session = this.driver.session();
                         Transaction tx = session.beginTransaction();){
                        tx.run("CREATE ()").consume();
                        break block27;
                    }
                }
                Assert.fail((String)"Exception expected");
            }
            catch (Exception e) {
                Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(ServiceUnavailableException.class));
            }
        }
    }

    private void throwsWhenRunMessageFails(Consumer<ThrowingSessionMonitor> monitorSetup) {
        ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
        Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
        this.db = this.startTestDb(monitors);
        this.driver = BoltFailuresIT.createDriver();
        Session session = this.driver.session();
        Transaction tx = session.beginTransaction();
        monitorSetup.accept(sessionMonitor);
        tx.run("CREATE ()");
        try {
            tx.close();
            session.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    private GraphDatabaseService startTestDb(Monitors monitors) {
        return this.startDbWithBolt((GraphDatabaseFactory)BoltFailuresIT.newDbFactory().setMonitors(monitors));
    }

    private GraphDatabaseService startTestDb(LogProvider internalLogProvider) {
        return this.startDbWithBolt((GraphDatabaseFactory)BoltFailuresIT.newDbFactory().setInternalLogProvider(internalLogProvider));
    }

    private GraphDatabaseService startDbWithBolt(GraphDatabaseFactory dbFactory) {
        return dbFactory.newEmbeddedDatabaseBuilder(this.dir.graphDbDir()).setConfig(GraphDatabaseSettings.boltConnector((String)"0").type, GraphDatabaseSettings.Connector.ConnectorType.BOLT.name()).setConfig(GraphDatabaseSettings.boltConnector((String)"0").enabled, "true").setConfig(GraphDatabaseSettings.auth_enabled, "false").newGraphDatabase();
    }

    private void awaitNumberOfActiveQueriesToBe(int value) throws TimeoutException {
        Predicates.await(() -> {
            Result listQueriesResult = this.db.execute("CALL dbms.listQueries()");
            return Iterators.count((Iterator)listQueriesResult) == (long)(value + 1);
        }, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private Future<?> updateAllNodesAsync(Driver driver) {
        return CompletableFuture.runAsync(() -> {
            try (Session session = driver.session();){
                session.run("MATCH (n) SET n.prop = 42").consume();
            }
        });
    }

    private static void expectFailure(Future<?> future) throws TimeoutException, InterruptedException {
        try {
            future.get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Exception expected");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private static TestEnterpriseGraphDatabaseFactory newDbFactory() {
        return new TestEnterpriseGraphDatabaseFactory();
    }

    private static Driver createDriver() {
        return GraphDatabase.driver((String)"bolt://localhost", (Config)Config.build().withoutEncryption().toConfig());
    }

    private static Monitors newMonitorsSpy(ThrowingSessionMonitor sessionMonitor) {
        Monitors monitors = (Monitors)Mockito.spy((Object)new Monitors());
        Mockito.when((Object)monitors.newMonitor(MonitoredWorkerFactory.SessionMonitor.class, new String[0])).thenReturn((Object)sessionMonitor);
        Mockito.when((Object)monitors.hasListeners(MonitoredWorkerFactory.SessionMonitor.class)).thenReturn((Object)true);
        return monitors;
    }

    private static class ThrowingSessionMonitor
    implements MonitoredWorkerFactory.SessionMonitor {
        volatile boolean throwInSessionStarted;
        volatile boolean throwInMessageReceived;
        volatile boolean throwInProcessingStarted;
        volatile boolean throwInProcessingDone;

        private ThrowingSessionMonitor() {
        }

        public void sessionStarted() {
            this.throwIfNeeded(this.throwInSessionStarted);
        }

        public void messageReceived() {
            this.throwIfNeeded(this.throwInMessageReceived);
        }

        public void processingStarted(long queueTime) {
            this.throwIfNeeded(this.throwInProcessingStarted);
        }

        public void processingDone(long processingTime) {
            this.throwIfNeeded(this.throwInProcessingDone);
        }

        void throwInSessionStarted() {
            this.throwInSessionStarted = true;
        }

        void throwInMessageReceived() {
            this.throwInMessageReceived = true;
        }

        void throwInProcessingStarted() {
            this.throwInProcessingStarted = true;
        }

        void throwInProcessingDone() {
            this.throwInProcessingDone = true;
        }

        void throwIfNeeded(boolean shouldThrow) {
            if (shouldThrow) {
                throw new RuntimeException();
            }
        }
    }

    private static class BoltKernelExtensionWithWorkerFactory
    extends BoltKernelExtension {
        final WorkerFactory workerFactory;

        BoltKernelExtensionWithWorkerFactory(WorkerFactory workerFactory) {
            this.workerFactory = workerFactory;
        }

        protected WorkerFactory createWorkerFactory(BoltFactory boltFactory, JobScheduler scheduler, BoltKernelExtension.Dependencies dependencies, LogService logService, Clock clock) {
            return this.workerFactory;
        }
    }
}

