/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.junit.Neo4jRule;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;

public class BoltQueryLoggingIT {
    @Rule
    public final Neo4jRule neo4j;

    public BoltQueryLoggingIT() throws IOException {
        String tmpDir = ServerTestUtils.createTempDir().getAbsolutePath();
        this.neo4j = new Neo4jRule().withConfig(ServerSettings.http_logging_enabled, "true").withConfig(ServerSettings.certificates_directory.name(), tmpDir).withConfig(GraphDatabaseSettings.auth_enabled, "false").withConfig(GraphDatabaseSettings.logs_directory, tmpDir).withConfig(GraphDatabaseSettings.log_queries, "true").withConfig(new BoltConnector((String)"bolt").type, "BOLT").withConfig(new BoltConnector((String)"bolt").enabled, "true").withConfig(new BoltConnector((String)"bolt").address, "localhost:8776").withConfig(new BoltConnector((String)"bolt").encryption_level, "DISABLED");
    }

    @Test
    public void shouldLogQueriesViaBolt() throws IOException {
        Socket socket = new Socket("localhost", 8776);
        DataInputStream dataIn = new DataInputStream(socket.getInputStream());
        DataOutputStream dataOut = new DataOutputStream(socket.getOutputStream());
        BoltQueryLoggingIT.send(dataOut, new byte[]{96, 96, -80, 23, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        BoltQueryLoggingIT.receive(dataIn, new byte[]{0, 0, 0, 1});
        BoltQueryLoggingIT.send(dataOut, "00 40 B1 01  8C 4D 79 43  6C 69 65 6E  74 2F 31 2E\n30 A3 86 73  63 68 65 6D  65 85 62 61  73 69 63 89\n70 72 69 6E  63 69 70 61  6C 85 6E 65  6F 34 6A 8B\n63 72 65 64  65 6E 74 69  61 6C 73 86  73 65 63 72\n65 74 00 00");
        this.receiveSuccess(dataIn);
        for (int i = 0; i < 5; ++i) {
            BoltQueryLoggingIT.send(dataOut, "00 13 b2 10  8f 52 45 54  55 52 4e 20  31 20 41 53 20 6e 75 6d  a0 00 00");
            this.receiveSuccess(dataIn);
            BoltQueryLoggingIT.send(dataOut, "00 02 B0 3F  00 00");
            BoltQueryLoggingIT.receive(dataIn, "00 04 b1 71  91 01 00 00");
            this.receiveSuccess(dataIn);
        }
        Path queriesLog = ((File)this.neo4j.getConfig().get(GraphDatabaseSettings.log_queries_filename)).toPath();
        List<String> lines = Files.readAllLines(queriesLog);
        MatcherAssert.assertThat(lines, (Matcher)Matchers.hasSize((int)5));
        for (String line : lines) {
            Assert.assertTrue((boolean)line.contains("INFO"));
            Assert.assertTrue((boolean)line.contains("ms: bolt-session\tbolt\tneo4j\tMyClient/1.0"));
            Assert.assertTrue((boolean)line.contains("client/127.0.0.1:"));
            Assert.assertTrue((boolean)line.contains("client/127.0.0.1:"));
            Assert.assertTrue((boolean)line.contains("server/127.0.0.1:8776"));
            Assert.assertTrue((boolean)line.contains(" - RETURN 1 AS num - {}"));
        }
        BoltQueryLoggingIT.send(dataOut, "00 02 b0 0f 00 00");
        BoltQueryLoggingIT.receive(dataIn, "00 03 b1 70  a0 00 00");
        socket.close();
    }

    private static void send(DataOutputStream dataOut, String toSend) throws IOException {
        BoltQueryLoggingIT.send(dataOut, BoltQueryLoggingIT.hexBytes(toSend));
    }

    private static void send(DataOutputStream dataOut, byte[] bytesToSend) throws IOException {
        dataOut.write(bytesToSend);
        dataOut.flush();
    }

    private void receiveSuccess(DataInputStream dataIn) throws IOException {
        short bytes = dataIn.readShort();
        MatcherAssert.assertThat((Object)dataIn.readUnsignedByte(), (Matcher)Matchers.equalTo((Object)177));
        MatcherAssert.assertThat((Object)dataIn.readUnsignedByte(), (Matcher)Matchers.equalTo((Object)112));
        dataIn.skipBytes(bytes);
    }

    private static void receive(DataInputStream dataIn, String expected) throws IOException {
        BoltQueryLoggingIT.receive(dataIn, BoltQueryLoggingIT.hexBytes(expected));
    }

    private static void receive(DataInputStream dataIn, byte[] expectedBytes) throws IOException {
        byte[] actualBytes = BoltQueryLoggingIT.read(dataIn, expectedBytes.length);
        MatcherAssert.assertThat((Object)actualBytes, (Matcher)Matchers.equalTo((Object)expectedBytes));
    }

    private static byte[] hexBytes(String input) {
        String[] pieces = input.trim().split("\\s+");
        byte[] result = new byte[pieces.length];
        for (int i = 0; i < pieces.length; ++i) {
            result[i] = BoltQueryLoggingIT.hexByte(pieces[i]);
        }
        return result;
    }

    private static byte hexByte(String s) {
        int hi = Character.digit(s.charAt(0), 16) << 4;
        int lo = Character.digit(s.charAt(1), 16);
        return (byte)(hi | lo);
    }

    private static byte[] read(DataInputStream dataIn, int howMany) throws IOException {
        int read;
        assert (howMany > 0);
        byte[] buffer = new byte[howMany];
        for (int offset = 0; offset < howMany; offset += read) {
            read = dataIn.read(buffer, offset, howMany - offset);
            if (read != 0) continue;
            Thread.yield();
        }
        return buffer;
    }
}

