/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.time.Clock;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.bolt.GraphDatabaseFactoryWithCustomBoltKernelExtension;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.MonitoredWorkerFactory;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.TestDirectory;

public class BoltFailuresIT {
    private static final int TEST_TIMEOUT = 20000;
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory();
    private GraphDatabaseService db;
    private Driver driver;
    private Session session;

    @After
    public void shutdownDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.session, this.driver});
    }

    @Test(timeout=20000L)
    public void throwsWhenWorkerCreationFails() {
        WorkerFactory workerFactory = (WorkerFactory)Mockito.mock(WorkerFactory.class);
        Mockito.when((Object)workerFactory.newWorker((BoltConnectionDescriptor)org.mockito.Matchers.anyObject(), (Runnable)org.mockito.Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException("Oh!")});
        BoltKernelExtensionWithWorkerFactory extension = new BoltKernelExtensionWithWorkerFactory(workerFactory);
        this.db = this.startDbWithBolt(new GraphDatabaseFactoryWithCustomBoltKernelExtension(extension));
        this.driver = BoltFailuresIT.createDriver();
        this.session = this.driver.session();
        try {
            this.session.beginTransaction();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    @Test(timeout=20000L)
    public void throwsWhenMonitoredWorkerCreationFails() {
        ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
        sessionMonitor.throwInSessionStarted();
        Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
        this.db = this.startDbWithBolt(new GraphDatabaseFactory().setMonitors(monitors));
        this.driver = BoltFailuresIT.createDriver();
        this.session = this.driver.session();
        try {
            this.session.beginTransaction();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    @Test(timeout=20000L)
    public void throwsWhenInitMessageReceiveFails() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInMessageReceived, false);
    }

    @Test(timeout=20000L)
    public void throwsWhenInitMessageProcessingFailsToStart() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInProcessingStarted, false);
    }

    @Test(timeout=20000L)
    public void throwsWhenInitMessageProcessingFailsToComplete() {
        this.throwsWhenInitMessageFails(ThrowingSessionMonitor::throwInProcessingDone, true);
    }

    @Test(timeout=20000L)
    public void throwsWhenRunMessageReceiveFails() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInMessageReceived);
    }

    @Test(timeout=20000L)
    public void throwsWhenRunMessageProcessingFailsToStart() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInProcessingStarted);
    }

    @Test(timeout=20000L)
    public void throwsWhenRunMessageProcessingFailsToComplete() {
        this.throwsWhenRunMessageFails(ThrowingSessionMonitor::throwInProcessingDone);
    }

    private void throwsWhenInitMessageFails(Consumer<ThrowingSessionMonitor> monitorSetup, boolean shouldBeAbleToBeginTransaction) {
        ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
        monitorSetup.accept(sessionMonitor);
        Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
        this.db = this.startTestDb(monitors);
        this.driver = BoltFailuresIT.createDriver();
        try (Session session = this.driver.session();
             Transaction tx = session.beginTransaction();){
            if (shouldBeAbleToBeginTransaction) {
                tx.run("CREATE ()").consume();
            } else {
                Assert.fail((String)"Exception expected");
            }
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    private void throwsWhenRunMessageFails(Consumer<ThrowingSessionMonitor> monitorSetup) {
        ThrowingSessionMonitor sessionMonitor = new ThrowingSessionMonitor();
        Monitors monitors = BoltFailuresIT.newMonitorsSpy(sessionMonitor);
        this.db = this.startTestDb(monitors);
        this.driver = BoltFailuresIT.createDriver();
        Session session = this.driver.session();
        Transaction tx = session.beginTransaction();
        monitorSetup.accept(sessionMonitor);
        tx.run("CREATE ()");
        try {
            tx.close();
            session.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        }
    }

    private GraphDatabaseService startTestDb(Monitors monitors) {
        return this.startDbWithBolt(new GraphDatabaseFactory().setMonitors(monitors));
    }

    private GraphDatabaseService startDbWithBolt(GraphDatabaseFactory dbFactory) {
        return dbFactory.newEmbeddedDatabaseBuilder(this.dir.graphDbDir()).setConfig(GraphDatabaseSettings.boltConnector((String)"0").type, GraphDatabaseSettings.Connector.ConnectorType.BOLT.name()).setConfig(GraphDatabaseSettings.boltConnector((String)"0").enabled, "true").setConfig(GraphDatabaseSettings.auth_enabled, "false").newGraphDatabase();
    }

    private static Driver createDriver() {
        return GraphDatabase.driver((String)"bolt://localhost");
    }

    private static Monitors newMonitorsSpy(ThrowingSessionMonitor sessionMonitor) {
        Monitors monitors = (Monitors)Mockito.spy((Object)new Monitors());
        Mockito.when((Object)monitors.newMonitor(MonitoredWorkerFactory.SessionMonitor.class, new String[0])).thenReturn((Object)sessionMonitor);
        Mockito.when((Object)monitors.hasListeners(MonitoredWorkerFactory.SessionMonitor.class)).thenReturn((Object)true);
        return monitors;
    }

    private static class ThrowingSessionMonitor
    implements MonitoredWorkerFactory.SessionMonitor {
        volatile boolean throwInSessionStarted;
        volatile boolean throwInMessageReceived;
        volatile boolean throwInProcessingStarted;
        volatile boolean throwInProcessingDone;

        private ThrowingSessionMonitor() {
        }

        public void sessionStarted() {
            this.throwIfNeeded(this.throwInSessionStarted);
        }

        public void messageReceived() {
            this.throwIfNeeded(this.throwInMessageReceived);
        }

        public void processingStarted(long queueTime) {
            this.throwIfNeeded(this.throwInProcessingStarted);
        }

        public void processingDone(long processingTime) {
            this.throwIfNeeded(this.throwInProcessingDone);
        }

        void throwInSessionStarted() {
            this.throwInSessionStarted = true;
        }

        void throwInMessageReceived() {
            this.throwInMessageReceived = true;
        }

        void throwInProcessingStarted() {
            this.throwInProcessingStarted = true;
        }

        void throwInProcessingDone() {
            this.throwInProcessingDone = true;
        }

        void throwIfNeeded(boolean shouldThrow) {
            if (shouldThrow) {
                throw new RuntimeException();
            }
        }
    }

    private static class BoltKernelExtensionWithWorkerFactory
    extends BoltKernelExtension {
        final WorkerFactory workerFactory;

        BoltKernelExtensionWithWorkerFactory(WorkerFactory workerFactory) {
            this.workerFactory = workerFactory;
        }

        protected WorkerFactory createWorkerFactory(BoltFactory boltFactory, JobScheduler scheduler, BoltKernelExtension.Dependencies dependencies, LogService logService, Clock clock) {
            return this.workerFactory;
        }
    }
}

