/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.auth;

import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseSecurityModule;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.RoleRepository;

abstract class FlatFileStressBase {
    private final long ONE_SECOND = 1000L;
    protected long TIMEOUT_IN_SECONDS = 10L;
    protected int N = 10;
    protected int ERROR_LIMIT = 100;
    InternalFlatFileRealm flatFileRealm;
    private UserRepository userRepository;
    private RoleRepository roleRepository;
    private volatile boolean keepRunning = true;
    final Set<Throwable> errors = ConcurrentHashMap.newKeySet();

    FlatFileStressBase() {
    }

    @Before
    public void setup() throws Throwable {
        Config config = Config.defaults();
        NullLogProvider logProvider = NullLogProvider.getInstance();
        NoopJobScheduler jobScheduler = new NoopJobScheduler();
        this.userRepository = CommunitySecurityModule.getUserRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)this.getFileSystem());
        this.roleRepository = EnterpriseSecurityModule.getRoleRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)this.getFileSystem());
        this.flatFileRealm = new InternalFlatFileRealm(this.userRepository, this.roleRepository, (PasswordPolicy)new BasicPasswordPolicy(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clock.systemUTC(), 3), (JobScheduler)jobScheduler, (UserRepository)CommunitySecurityModule.getInitialUserRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)this.getFileSystem()), EnterpriseSecurityModule.getDefaultAdminRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)this.getFileSystem()));
        this.flatFileRealm.init();
        this.flatFileRealm.start();
    }

    abstract FileSystemAbstraction getFileSystem();

    @After
    public void teardown() throws Throwable {
        this.flatFileRealm.stop();
        this.flatFileRealm.shutdown();
    }

    @Test
    public void shouldMaintainConsistency() throws InterruptedException, IOException {
        ExecutorService service = this.setupWorkload(this.N);
        int t = 0;
        while ((long)t < this.TIMEOUT_IN_SECONDS) {
            Thread.sleep(1000L);
            if (this.errors.size() > this.ERROR_LIMIT) break;
            ++t;
        }
        this.keepRunning = false;
        service.shutdown();
        service.awaitTermination(5L, TimeUnit.SECONDS);
        String msg = String.join((CharSequence)System.lineSeparator(), this.errors.stream().map(Throwable::getMessage).collect(Collectors.toList()));
        MatcherAssert.assertThat((String)msg, this.errors, (Matcher)Matchers.empty());
        ListSnapshot users = this.userRepository.getPersistedSnapshot();
        ListSnapshot roles = this.roleRepository.getPersistedSnapshot();
        Assert.assertTrue((String)"User and role repositories are no longer consistent", (boolean)RoleRepository.validate((List)users.values(), (List)roles.values()));
    }

    abstract ExecutorService setupWorkload(int var1);

    private class NoopJobScheduler
    extends LifecycleAdapter
    implements JobScheduler {
        private NoopJobScheduler() {
        }

        public Executor executor(JobScheduler.Group group) {
            return null;
        }

        public ThreadFactory threadFactory(JobScheduler.Group group) {
            return null;
        }

        public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
            return null;
        }

        public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job, Map<String, String> metadata) {
            return null;
        }

        public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
            return null;
        }

        public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
            return null;
        }

        public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
            return null;
        }
    }

    abstract class IrrationalAdmin
    implements Runnable {
        final Random random = new Random();
        Runnable[] actions;

        IrrationalAdmin() {
        }

        @Override
        public void run() {
            while (FlatFileStressBase.this.keepRunning) {
                this.randomAction().run();
            }
        }

        private Runnable randomAction() {
            return this.actions[this.random.nextInt(this.actions.length)];
        }

        void setActions(Runnable ... actions) {
            this.actions = actions;
        }
    }
}

