/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.integration.TransactionMatchers;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.server.HTTP;

@RunWith(value=Parameterized.class)
public class TransactionTerminationIT {
    private static final Label LABEL = Label.label((String)"Foo");
    private static final String PROPERTY = "bar";
    @Parameterized.Parameter
    public String lockManagerName;
    private final CleanupRule cleanupRule = new CleanupRule();
    private final ClusterRule clusterRule = new ClusterRule(this.getClass()).withCluster(ClusterManager.clusterOfSize((int)3)).withSharedSetting(HaSettings.ha_server, ":6001-6005").withSharedSetting(HaSettings.tx_push_factor, "2").withSharedSetting(HaSettings.lock_read_timeout, "1m");
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)SuppressOutput.suppressAll()).around((TestRule)this.cleanupRule).around((TestRule)this.clusterRule);

    @Parameterized.Parameters(name="lockManager = {0}")
    public static Iterable<Object[]> lockManagerNames() {
        return Arrays.asList({"forseti"}, {"community"});
    }

    @Test
    public void terminateSingleInstanceRestTransactionThatWaitsForLock() throws Exception {
        ServerControls server = (ServerControls)this.cleanupRule.add((AutoCloseable)TestServerBuilders.newInProcessBuilder().withConfig(GraphDatabaseSettings.auth_enabled, "false").withConfig(GraphDatabaseFacadeFactory.Configuration.lock_manager, this.lockManagerName).newServer());
        GraphDatabaseService db = server.graph();
        HTTP.Builder http = HTTP.withBaseUri((String)server.httpURI().toString());
        long value1 = 1L;
        long value2 = 2L;
        TransactionTerminationIT.createNode(db);
        HTTP.Response tx1 = TransactionTerminationIT.startTx(http);
        HTTP.Response tx2 = TransactionTerminationIT.startTx(http);
        TransactionTerminationIT.assertNumberOfActiveTransactions(2, db);
        HTTP.Response update1 = TransactionTerminationIT.executeUpdateStatement(tx1, value1, http);
        org.junit.Assert.assertThat((Object)update1.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        org.junit.Assert.assertThat((Object)update1, (Matcher)TransactionMatchers.containsNoErrors());
        CountDownLatch latch = new CountDownLatch(1);
        Future<?> tx2Result = TransactionTerminationIT.executeInSeparateThread("tx2", () -> {
            latch.countDown();
            HTTP.Response update2 = TransactionTerminationIT.executeUpdateStatement(tx2, value2, http);
            TransactionTerminationIT.assertTxWasTerminated(update2);
        });
        TransactionTerminationIT.await(latch);
        TransactionTerminationIT.sleepForAWhile();
        TransactionTerminationIT.terminate(tx2, http);
        TransactionTerminationIT.commit(tx1, http);
        HTTP.Response update3 = TransactionTerminationIT.executeUpdateStatement(tx2, value2, http);
        org.junit.Assert.assertThat((Object)update3.status(), (Matcher)CoreMatchers.equalTo((Object)404));
        tx2Result.get(1L, TimeUnit.MINUTES);
        TransactionTerminationIT.assertNodeExists(db, (Object)value1);
    }

    @Test
    public void terminateSlaveTransactionThatWaitsForLockOnMaster() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startCluster();
        String masterValue = "master";
        String slaveValue = "slave";
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.createNode(cluster);
        CountDownLatch masterTxStarted = new CountDownLatch(1);
        CountDownLatch masterTxCommit = new CountDownLatch(1);
        Future<?> masterTx = TransactionTerminationIT.setPropertyInSeparateThreadAndWaitBeforeCommit("masterTx", (GraphDatabaseService)master, masterValue, masterTxStarted, masterTxCommit);
        TransactionTerminationIT.await(masterTxStarted);
        AtomicReference<Transaction> slaveTxReference = new AtomicReference<Transaction>();
        CountDownLatch slaveTxStarted = new CountDownLatch(1);
        Future<?> slaveTx = TransactionTerminationIT.setPropertyInSeparateThreadAndAttemptToCommit("slaveTx", (GraphDatabaseService)slave, slaveValue, slaveTxStarted, slaveTxReference);
        slaveTxStarted.await();
        TransactionTerminationIT.sleepForAWhile();
        this.terminate(slaveTxReference);
        this.assertTxWasTerminated(slaveTx);
        masterTxCommit.countDown();
        org.junit.Assert.assertNull(masterTx.get());
        TransactionTerminationIT.assertNodeExists(cluster, (Object)masterValue);
    }

    @Test
    public void terminateMasterTransactionThatWaitsForLockAcquiredBySlave() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startCluster();
        String masterValue = "master";
        String slaveValue = "slave";
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.createNode(cluster);
        CountDownLatch slaveTxStarted = new CountDownLatch(1);
        CountDownLatch slaveTxCommit = new CountDownLatch(1);
        Future<?> slaveTx = TransactionTerminationIT.setPropertyInSeparateThreadAndWaitBeforeCommit("slaveTx", (GraphDatabaseService)slave, slaveValue, slaveTxStarted, slaveTxCommit);
        TransactionTerminationIT.await(slaveTxStarted);
        AtomicReference<Transaction> masterTxReference = new AtomicReference<Transaction>();
        CountDownLatch masterTxStarted = new CountDownLatch(1);
        Future<?> masterTx = TransactionTerminationIT.setPropertyInSeparateThreadAndAttemptToCommit("masterTx", (GraphDatabaseService)master, masterValue, masterTxStarted, masterTxReference);
        masterTxStarted.await();
        TransactionTerminationIT.sleepForAWhile();
        this.terminate(masterTxReference);
        this.assertTxWasTerminated(masterTx);
        slaveTxCommit.countDown();
        org.junit.Assert.assertNull(slaveTx.get());
        TransactionTerminationIT.assertNodeExists(cluster, (Object)slaveValue);
    }

    private static void createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{LABEL});
            tx.success();
        }
    }

    private void createNode(ClusterManager.ManagedCluster cluster) throws InterruptedException {
        TransactionTerminationIT.createNode((GraphDatabaseService)cluster.getMaster());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
    }

    private static void assertNodeExists(GraphDatabaseService db, Object value) {
        try (Transaction tx = db.beginTx();){
            Node node = TransactionTerminationIT.findNode(db);
            org.junit.Assert.assertTrue((boolean)node.hasProperty(PROPERTY));
            org.junit.Assert.assertEquals((Object)value, (Object)node.getProperty(PROPERTY));
            tx.success();
        }
    }

    private static void assertNodeExists(ClusterManager.ManagedCluster cluster, Object value) throws Exception {
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        TransactionTerminationIT.assertNodeExists((GraphDatabaseService)cluster.getMaster(), value);
    }

    private static Node findNode(GraphDatabaseService db) {
        return (Node)Iterators.single((Iterator)db.findNodes(LABEL));
    }

    private static HTTP.Response startTx(HTTP.Builder http) {
        HTTP.Response tx = http.POST("db/data/transaction");
        org.junit.Assert.assertThat((Object)tx.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        org.junit.Assert.assertThat((Object)tx, (Matcher)TransactionMatchers.containsNoErrors());
        return tx;
    }

    private static void commit(HTTP.Response tx, HTTP.Builder http) throws JsonParseException {
        http.POST(tx.stringFromContent("commit"));
    }

    private static void terminate(HTTP.Response tx, HTTP.Builder http) {
        http.DELETE(tx.location());
    }

    private void terminate(AtomicReference<Transaction> txReference) {
        Transaction tx = txReference.get();
        org.junit.Assert.assertNotNull((Object)tx);
        tx.terminate();
    }

    private static HTTP.Response executeUpdateStatement(HTTP.Response tx, long value, HTTP.Builder http) {
        String updateQuery = "MATCH (n:" + LABEL + ") SET n." + PROPERTY + "=" + value;
        HTTP.RawPayload json = HTTP.RawPayload.quotedJson((String)("{'statements': [{'statement':'" + updateQuery + "'}]}"));
        return http.POST(tx.location(), json);
    }

    private static void assertNumberOfActiveTransactions(int expectedCount, GraphDatabaseService db) throws InterruptedException {
        ThrowingSupplier txCount = () -> TransactionTerminationIT.activeTxCount(db);
        Assert.assertEventually((String)"Wrong active tx count", (ThrowingSupplier)txCount, (Matcher)CoreMatchers.equalTo((Object)expectedCount), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static int activeTxCount(GraphDatabaseService db) {
        DependencyResolver resolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        KernelTransactions kernelTransactions = (KernelTransactions)resolver.resolveDependency(KernelTransactions.class);
        return kernelTransactions.activeTransactions().size();
    }

    private static void assertTxWasTerminated(HTTP.Response txResponse) {
        org.junit.Assert.assertEquals((long)200L, (long)txResponse.status());
        org.junit.Assert.assertThat((Object)txResponse, (Matcher)TransactionMatchers.hasErrors((Status[])new Status[]{Status.Statement.ExecutionFailed}));
        org.junit.Assert.assertThat((Object)txResponse.rawContent(), (Matcher)Matchers.containsString((String)LockClientStoppedException.class.getSimpleName()));
    }

    private void assertTxWasTerminated(Future<?> txFuture) throws InterruptedException {
        try {
            txFuture.get();
            org.junit.Assert.fail((String)"Exception expected");
        }
        catch (ExecutionException e) {
            org.junit.Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    private static void sleepForAWhile() throws InterruptedException {
        Thread.sleep(2000L);
    }

    private static void await(CountDownLatch latch) {
        try {
            org.junit.Assert.assertTrue((boolean)latch.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Future<?> setPropertyInSeparateThreadAndWaitBeforeCommit(String threadName, GraphDatabaseService db, Object value, CountDownLatch txStarted, CountDownLatch txCommit) {
        return TransactionTerminationIT.executeInSeparateThread(threadName, () -> {
            try (Transaction tx = db.beginTx();){
                Node node = TransactionTerminationIT.findNode(db);
                node.setProperty(PROPERTY, value);
                txStarted.countDown();
                TransactionTerminationIT.await(txCommit);
                tx.success();
            }
        });
    }

    private static Future<?> setPropertyInSeparateThreadAndAttemptToCommit(String threadName, GraphDatabaseService db, Object value, CountDownLatch txStarted, AtomicReference<Transaction> txReference) {
        return TransactionTerminationIT.executeInSeparateThread(threadName, () -> {
            try (Transaction tx = db.beginTx();){
                txReference.set(tx);
                Node node = TransactionTerminationIT.findNode(db);
                txStarted.countDown();
                node.setProperty(PROPERTY, value);
                tx.success();
            }
        });
    }

    private static Future<?> executeInSeparateThread(String threadName, Runnable runnable) {
        return Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.named((String)threadName)).submit(runnable);
    }

    private ClusterManager.ManagedCluster startCluster() throws Exception {
        this.clusterRule.withSharedSetting(GraphDatabaseFacadeFactory.Configuration.lock_manager, this.lockManagerName);
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        return cluster;
    }
}

