/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.internal.Ports;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.GuardTimeoutException;
import org.neo4j.kernel.guard.TimeoutGuard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.HTTP;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class TransactionGuardIntegrationTest {
    @ClassRule
    public static CleanupRule cleanupRule = new CleanupRule();
    @ClassRule
    public static TestDirectory testDirectory = TestDirectory.testDirectory();
    private static final FakeClock fakeClock = Clocks.fakeClock();
    private TickingGuard tickingGuard = new TickingGuard((Clock)fakeClock, (Log)NullLog.getInstance(), 1L, TimeUnit.SECONDS);
    private static GraphDatabaseAPI databaseWithTimeout;
    private static GraphDatabaseAPI databaseWithTimeoutAndGuard;
    private static GraphDatabaseAPI databaseWithoutTimeout;
    private static CommunityNeoServer neoServer;
    private static int boltPortCustomGuard;
    private static int boltPortDatabaseWithTimeout;

    @Test
    public void terminateLongRunningTransaction() {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx();){
            fakeClock.forward(3L, TimeUnit.SECONDS);
            transaction.success();
            database.createNode();
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (GuardTimeoutException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Transaction timeout."));
            Assert.assertEquals((Object)e.status(), (Object)Status.Transaction.TransactionTimedOut);
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningTransactionWithPeriodicCommit() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeoutCustomGuard();
        try {
            URL url = this.prepareTestImportFile(8);
            database.execute("USING PERIODIC COMMIT 5 LOAD CSV FROM '" + url + "' AS line CREATE ();");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (GuardTimeoutException guardTimeoutException) {
            // empty catch block
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateTransactionWithCustomTimeoutWithoutConfiguredDefault() {
        GraphDatabaseAPI database = this.startDatabaseWithoutTimeout();
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx(27L, TimeUnit.SECONDS);){
            fakeClock.forward(26L, TimeUnit.SECONDS);
            database.createNode();
            transaction.failure();
        }
        try {
            transaction = database.beginTx(27L, TimeUnit.SECONDS);
            var3_4 = null;
            try {
                fakeClock.forward(28L, TimeUnit.SECONDS);
                database.createNode();
                Assert.fail((String)"Transaction should be already terminated.");
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var3_4 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (GuardTimeoutException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Transaction timeout."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningQueryTransaction() {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx();){
            fakeClock.forward(3L, TimeUnit.SECONDS);
            transaction.success();
            database.execute("create (n)");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (GuardTimeoutException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Transaction timeout."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningQueryWithCustomTimeoutWithoutConfiguredDefault() {
        GraphDatabaseAPI database = this.startDatabaseWithoutTimeout();
        try (org.neo4j.graphdb.Transaction transaction = database.beginTx(5L, TimeUnit.SECONDS);){
            fakeClock.forward(4L, TimeUnit.SECONDS);
            database.execute("create (n)");
            transaction.failure();
        }
        try {
            transaction = database.beginTx(6L, TimeUnit.SECONDS);
            var3_4 = null;
            try {
                fakeClock.forward(7L, TimeUnit.SECONDS);
                transaction.success();
                database.execute("create (n)");
                Assert.fail((String)"Transaction should be already terminated.");
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (transaction != null) {
                    if (var3_4 != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        catch (GuardTimeoutException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Transaction timeout."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningShellQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        GraphDatabaseShellServer shellServer = this.getGraphDatabaseShellServer(database);
        try {
            SameJvmClient client = this.getShellClient(shellServer);
            CollectingOutput commandOutput = new CollectingOutput();
            this.execute(shellServer, commandOutput, client.getId(), "begin Transaction");
            fakeClock.forward(3L, TimeUnit.SECONDS);
            this.execute(shellServer, commandOutput, client.getId(), "create (n);");
            this.execute(shellServer, commandOutput, client.getId(), "commit");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Transaction timeout."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningShellPeriodicCommitQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeoutCustomGuard();
        GraphDatabaseShellServer shellServer = this.getGraphDatabaseShellServer(database);
        try {
            SameJvmClient client = this.getShellClient(shellServer);
            CollectingOutput commandOutput = new CollectingOutput();
            URL url = this.prepareTestImportFile(8);
            this.execute(shellServer, commandOutput, client.getId(), "USING PERIODIC COMMIT 5 LOAD CSV FROM '" + url + "' AS line CREATE ();");
            Assert.fail((String)"Transaction should be already terminated.");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Transaction timeout."));
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningRestTransactionalEndpointQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        CommunityNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        String transactionEndPoint = HTTP.POST((String)this.transactionUri(neoServer)).location();
        fakeClock.forward(3L, TimeUnit.SECONDS);
        HTTP.Response response = HTTP.POST((String)transactionEndPoint, (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)200L, (long)response.status());
        HTTP.Response commitResponse = HTTP.POST((String)(transactionEndPoint + "/commit"));
        Assert.assertEquals((String)"Transaction should be already closed and not found.", (long)404L, (long)commitResponse.status());
        Assert.assertEquals((String)"Transaction should be forcefully closed.", (Object)Status.Transaction.TransactionNotFound.code().serialize(), (Object)commitResponse.get("errors").findValue("code").asText());
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningRestTransactionalEndpointWithCustomTimeoutQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        CommunityNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        long customTimeout = TimeUnit.SECONDS.toMillis(10L);
        HTTP.Response beginResponse = HTTP.withHeaders((String[])new String[]{"max-execution-time", String.valueOf(customTimeout)}).POST(this.transactionUri(neoServer), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)201L, (long)beginResponse.status());
        String transactionEndPoint = beginResponse.location();
        fakeClock.forward(3L, TimeUnit.SECONDS);
        HTTP.Response response = HTTP.POST((String)transactionEndPoint, (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)200L, (long)response.status());
        fakeClock.forward(11L, TimeUnit.SECONDS);
        response = HTTP.POST((String)transactionEndPoint, (HTTP.RawPayload)HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assert.assertEquals((String)"Response should be successful.", (long)200L, (long)response.status());
        HTTP.Response commitResponse = HTTP.POST((String)(transactionEndPoint + "/commit"));
        Assert.assertEquals((String)"Transaction should be already closed and not found.", (long)404L, (long)commitResponse.status());
        Assert.assertEquals((String)"Transaction should be forcefully closed.", (Object)Status.Transaction.TransactionNotFound.code().serialize(), (Object)commitResponse.get("errors").findValue("code").asText());
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningDriverQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeout();
        CommunityNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        org.neo4j.driver.v1.Config driverConfig = this.getDriverConfig();
        try (Driver driver = GraphDatabase.driver((String)("bolt://localhost:" + boltPortDatabaseWithTimeout), (org.neo4j.driver.v1.Config)driverConfig);
             Session session = driver.session();){
            Transaction transaction = session.beginTransaction();
            transaction.run("create (n)").consume();
            transaction.success();
            fakeClock.forward(3L, TimeUnit.SECONDS);
            try {
                transaction.run("create (n)").consume();
                Assert.fail((String)"Transaction should be already terminated by execution guard.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    @Test
    public void terminateLongRunningDriverPeriodicCommitQuery() throws Exception {
        GraphDatabaseAPI database = this.startDatabaseWithTimeoutCustomGuard();
        CommunityNeoServer neoServer = this.startNeoServer((GraphDatabaseFacade)database);
        org.neo4j.driver.v1.Config driverConfig = this.getDriverConfig();
        try (Driver driver = GraphDatabase.driver((String)("bolt://localhost:" + boltPortCustomGuard), (org.neo4j.driver.v1.Config)driverConfig);
             Session session = driver.session();){
            URL url = this.prepareTestImportFile(8);
            session.run("USING PERIODIC COMMIT 5 LOAD CSV FROM '" + url + "' AS line CREATE ();").consume();
            Assert.fail((String)"Transaction should be already terminated by execution guard.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertDatabaseDoesNotHaveNodes(database);
    }

    private GraphDatabaseAPI startDatabaseWithTimeoutCustomGuard() {
        if (databaseWithTimeoutAndGuard == null) {
            boltPortCustomGuard = this.findFreePort();
            Map<Setting<?>, String> configMap = this.getSettingsWithTimeoutAndBolt(boltPortCustomGuard);
            databaseWithTimeoutAndGuard = this.startCustomGuardedDatabase(testDirectory.directory("dbWithoutTimeoutAndGuard"), configMap);
        }
        return databaseWithTimeoutAndGuard;
    }

    private GraphDatabaseAPI startDatabaseWithTimeout() {
        if (databaseWithTimeout == null) {
            boltPortDatabaseWithTimeout = this.findFreePort();
            Map<Setting<?>, String> configMap = this.getSettingsWithTimeoutAndBolt(boltPortDatabaseWithTimeout);
            databaseWithTimeout = this.startCustomDatabase(testDirectory.directory("dbWithTimeout"), configMap);
        }
        return databaseWithTimeout;
    }

    private GraphDatabaseAPI startDatabaseWithoutTimeout() {
        if (databaseWithoutTimeout == null) {
            Map<Setting<?>, String> configMap = this.getSettingsWithoutTransactionTimeout();
            databaseWithoutTimeout = this.startCustomDatabase(testDirectory.directory("dbWithoutTimeout"), configMap);
        }
        return databaseWithoutTimeout;
    }

    private org.neo4j.driver.v1.Config getDriverConfig() {
        return org.neo4j.driver.v1.Config.build().withEncryptionLevel(Config.EncryptionLevel.NONE).toConfig();
    }

    private CommunityNeoServer startNeoServer(GraphDatabaseFacade database) throws IOException {
        if (neoServer == null) {
            GuardingServerBuilder serverBuilder = new GuardingServerBuilder(database);
            BoltConnector boltConnector = new BoltConnector("bolt");
            serverBuilder.withProperty(boltConnector.type.name(), "BOLT").withProperty(boltConnector.enabled.name(), "true").withProperty(boltConnector.encryption_level.name(), BoltConnector.EncryptionLevel.DISABLED.name()).withProperty(GraphDatabaseSettings.auth_enabled.name(), "false");
            neoServer = serverBuilder.build();
            cleanupRule.add((Object)neoServer);
            neoServer.start();
        }
        return neoServer;
    }

    private Map<Setting<?>, String> getSettingsWithTimeoutAndBolt(int boltPort) {
        BoltConnector boltConnector = new BoltConnector("bolt");
        return MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.transaction_timeout, "2s", boltConnector.address, "localhost:" + boltPort, boltConnector.type, "BOLT", boltConnector.enabled, "true", boltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED.name(), GraphDatabaseSettings.auth_enabled, "false"});
    }

    private Map<Setting<?>, String> getSettingsWithoutTransactionTimeout() {
        return MapUtil.genericMap((Object[])new Object[0]);
    }

    private String transactionUri(CommunityNeoServer neoServer) {
        return neoServer.baseUri().toString() + "db/data/transaction";
    }

    private URL prepareTestImportFile(int lines) throws IOException {
        File tempFile = File.createTempFile("testImport", ".csv");
        try (PrintWriter writer = FileUtils.newFilePrintWriter((File)tempFile, (Charset)StandardCharsets.UTF_8);){
            for (int i = 0; i < lines; ++i) {
                writer.println("a,b,c");
            }
        }
        return tempFile.toURI().toURL();
    }

    private int findFreePort() {
        return this.freePort(8000, 8100);
    }

    private int freePort(int startRange, int endRange) {
        try {
            return Ports.findFreePort((String)"localhost", (int[])new int[]{startRange, endRange}).getPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find an available port: " + e.getMessage(), e);
        }
    }

    private Response execute(GraphDatabaseShellServer shellServer, CollectingOutput output, Serializable clientId, String command) throws ShellException {
        return shellServer.interpretLine(clientId, command, (Output)output);
    }

    private SameJvmClient getShellClient(GraphDatabaseShellServer shellServer) throws ShellException, RemoteException {
        SameJvmClient client = new SameJvmClient(new HashMap(), (ShellServer)shellServer, (Output)new CollectingOutput(), (CtrlCHandler)InterruptSignalHandler.getHandler());
        cleanupRule.add((Object)client);
        return client;
    }

    private GraphDatabaseShellServer getGraphDatabaseShellServer(GraphDatabaseAPI database) throws RemoteException {
        GraphDatabaseShellServer shellServer = new GraphDatabaseShellServer(database);
        cleanupRule.add((Object)shellServer);
        return shellServer;
    }

    private void assertDatabaseDoesNotHaveNodes(GraphDatabaseAPI database) {
        try (org.neo4j.graphdb.Transaction ignored = database.beginTx();){
            Assert.assertEquals((long)0L, (long)database.getAllNodes().stream().count());
        }
    }

    private GraphDatabaseAPI startCustomGuardedDatabase(File storeDir, Map<Setting<?>, String> configMap) {
        CustomClockGuardedCommunityFacadeFactory guardCommunityFacadeFactory = new CustomClockGuardedCommunityFacadeFactory();
        GraphDatabaseBuilder databaseBuilder = new CustomGuardTestTestGraphDatabaseFactory(guardCommunityFacadeFactory).newImpermanentDatabaseBuilder(storeDir);
        configMap.forEach((arg_0, arg_1) -> ((GraphDatabaseBuilder)databaseBuilder).setConfig(arg_0, arg_1));
        GraphDatabaseAPI database = (GraphDatabaseAPI)databaseBuilder.newGraphDatabase();
        cleanupRule.add((Object)database);
        return database;
    }

    private GraphDatabaseAPI startCustomDatabase(File storeDir, Map<Setting<?>, String> configMap) {
        CustomClockCommunityFacadeFactory customClockCommunityFacadeFactory = new CustomClockCommunityFacadeFactory();
        GraphDatabaseBuilder databaseBuilder = new CustomGuardTestTestGraphDatabaseFactory(customClockCommunityFacadeFactory).newImpermanentDatabaseBuilder(storeDir);
        configMap.forEach((arg_0, arg_1) -> ((GraphDatabaseBuilder)databaseBuilder).setConfig(arg_0, arg_1));
        GraphDatabaseAPI database = (GraphDatabaseAPI)databaseBuilder.newGraphDatabase();
        cleanupRule.add((Object)database);
        return database;
    }

    private class TickingGuard
    extends TimeoutGuard {
        private final FakeClock clock;
        private final long delta;
        private final TimeUnit unit;

        TickingGuard(Clock clock, Log log, long delta, TimeUnit unit) {
            super(clock, log);
            this.clock = (FakeClock)clock;
            this.delta = delta;
            this.unit = unit;
        }

        public void check(KernelStatement statement) {
            super.check(statement);
            this.clock.forward(this.delta, this.unit);
        }
    }

    private class GuardedCustomClockDataSourceModule
    extends CustomClockDataSourceModule {
        GuardedCustomClockDataSourceModule(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryEngine) {
            super(platformModule, editionModule, queryEngine);
        }

        protected TimeoutGuard createGuard(Clock clock, LogService logging) {
            return TransactionGuardIntegrationTest.this.tickingGuard;
        }
    }

    private class CustomClockGuardedCommunityFacadeFactory
    extends CustomClockCommunityFacadeFactory {
        CustomClockGuardedCommunityFacadeFactory() {
        }

        @Override
        protected DataSourceModule createDataSource(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryEngine) {
            return new GuardedCustomClockDataSourceModule(platformModule, editionModule, queryEngine);
        }
    }

    private class CustomClockDataSourceModule
    extends DataSourceModule {
        CustomClockDataSourceModule(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryEngine) {
            super(platformModule, editionModule, queryEngine);
        }
    }

    private class CustomClockCommunityFacadeFactory
    extends GraphDatabaseFacadeFactory {
        CustomClockCommunityFacadeFactory() {
            super(DatabaseInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
            return new PlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade){

                protected SystemNanoClock createClock() {
                    return fakeClock;
                }
            };
        }

        protected DataSourceModule createDataSource(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryEngine) {
            return new CustomClockDataSourceModule(platformModule, editionModule, queryEngine);
        }
    }

    private class CustomGuardTestTestGraphDatabaseFactory
    extends TestGraphDatabaseFactory {
        private GraphDatabaseFacadeFactory customFacadeFactory;

        CustomGuardTestTestGraphDatabaseFactory(GraphDatabaseFacadeFactory customFacadeFactory) {
            this.customFacadeFactory = customFacadeFactory;
        }

        protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final File storeDir, final TestGraphDatabaseFactoryState state) {
            return new GraphDatabaseBuilder.DatabaseCreator(){

                public GraphDatabaseService newDatabase(Map<String, String> config) {
                    return this.newDatabase(Config.embeddedDefaults(config));
                }

                public GraphDatabaseService newDatabase(Config config) {
                    return CustomGuardTestTestGraphDatabaseFactory.this.customFacadeFactory.newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
                }
            };
        }
    }

    private class GuardingServerBuilder
    extends CommunityServerBuilder {
        private GraphDatabaseFacade graphDatabaseFacade;
        final LifecycleManagingDatabase.GraphFactory PRECREATED_FACADE_FACTORY;

        protected GuardingServerBuilder(GraphDatabaseFacade graphDatabaseAPI) {
            super((LogProvider)NullLogProvider.getInstance());
            this.PRECREATED_FACADE_FACTORY = (config, dependencies) -> this.graphDatabaseFacade;
            this.graphDatabaseFacade = graphDatabaseAPI;
        }

        protected CommunityNeoServer build(Optional<File> configFile, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new GuardTestServer(config, dependencies, (LogProvider)NullLogProvider.getInstance());
        }

        private class GuardTestServer
        extends CommunityNeoServer {
            GuardTestServer(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
                super(config, LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)GuardingServerBuilder.this.PRECREATED_FACADE_FACTORY), dependencies, logProvider);
            }
        }
    }
}

