/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.function.Function;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.tooling.Distribution;
import org.neo4j.tooling.SimpleDataGeneratorBatch;
import org.neo4j.unsafe.impl.batchimport.IdRangeInput;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputNodeDeserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputRelationshipDeserialization;

public class SimpleDataGenerator
extends SourceTraceability.Adapter {
    private final Header nodeHeader;
    private final Header relationshipHeader;
    private final long randomSeed;
    private final long nodeCount;
    private final Distribution<String> labels;
    private final Distribution<String> relationshipTypes;
    private final Groups groups = new Groups();
    private final IdType idType;
    private final String className = ((Object)((Object)this)).getClass().getSimpleName();
    private final float factorNodeDuplicates;
    private final float factorBadRelationships;

    public SimpleDataGenerator(Header nodeHeader, Header relationshipHeader, long randomSeed, long nodeCount, int labelCount, int relationshipTypeCount, IdType idType, float factorNodeDuplicates, float factorBadRelationships) {
        this.nodeHeader = nodeHeader;
        this.relationshipHeader = relationshipHeader;
        this.randomSeed = randomSeed;
        this.nodeCount = nodeCount;
        this.idType = idType;
        this.factorNodeDuplicates = factorNodeDuplicates;
        this.factorBadRelationships = factorBadRelationships;
        this.labels = new Distribution<String>(SimpleDataGenerator.tokens("Label", labelCount));
        this.relationshipTypes = new Distribution<String>(SimpleDataGenerator.tokens("TYPE", relationshipTypeCount));
    }

    public Function<IdRangeInput.Range, InputNode[]> nodes() {
        return batch -> new SimpleDataGeneratorBatch<InputNode>(this.nodeHeader, batch.getStart(), this.randomSeed + batch.getStart(), this.nodeCount, this.labels, this.relationshipTypes, (Deserialization<InputNode>)new InputNodeDeserialization(this.nodeHeader, (SourceTraceability)this, this.groups, this.idType.idsAreExternal()), (T[])new InputNode[batch.getSize()], this.factorNodeDuplicates, this.factorBadRelationships).get();
    }

    public Function<IdRangeInput.Range, InputRelationship[]> relationships() {
        return batch -> new SimpleDataGeneratorBatch<InputRelationship>(this.relationshipHeader, batch.getStart(), this.randomSeed + batch.getStart(), this.nodeCount, this.labels, this.relationshipTypes, (Deserialization<InputRelationship>)new InputRelationshipDeserialization(this.relationshipHeader, (SourceTraceability)this, this.groups), (T[])new InputRelationship[batch.getSize()], this.factorNodeDuplicates, this.factorBadRelationships).get();
    }

    private static String[] tokens(String prefix, int count) {
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = prefix + (i + 1);
        }
        return result;
    }

    public String sourceDescription() {
        return this.className;
    }
}

