/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.tooling.CsvOutput;
import org.neo4j.tooling.DataGeneratorInput;
import org.neo4j.tooling.ImportTool;
import org.neo4j.tooling.SimpleDataGenerator;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class QuickImport {
    private QuickImport() {
    }

    public static void main(String[] arguments) throws IOException {
        final Args args = Args.parse((String[])arguments);
        long nodeCount = Settings.parseLongWithUnit((String)args.get("nodes", null));
        long relationshipCount = Settings.parseLongWithUnit((String)args.get("relationships", null));
        int labelCount = args.getNumber("labels", (Number)4).intValue();
        int relationshipTypeCount = args.getNumber("relationship-types", (Number)4).intValue();
        File dir = new File(args.get(ImportTool.Options.STORE_DIR.key()));
        long randomSeed = args.getNumber("random-seed", (Number)System.currentTimeMillis()).longValue();
        org.neo4j.unsafe.impl.batchimport.input.csv.Configuration config = org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS;
        Extractors extractors = new Extractors(config.arrayDelimiter());
        IdType idType = IdType.valueOf((String)args.get("id-type", IdType.INTEGER.name()));
        Header nodeHeader = QuickImport.parseNodeHeader(args, idType, extractors);
        Header relationshipHeader = QuickImport.parseRelationshipHeader(args, idType, extractors);
        String dbConfigFileName = args.get(ImportTool.Options.DATABASE_CONFIG.key(), null);
        Config dbConfig = dbConfigFileName != null ? new Config.Builder().withFile(new File(dbConfigFileName)).build() : Config.defaults();
        final boolean highIo = args.getBoolean(ImportTool.Options.HIGH_IO.key());
        FormattedLogProvider sysoutLogProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
        final long pageCacheMemory = args.getNumber("pagecache-memory", (Number)Configuration.MAX_PAGE_CACHE_MEMORY).longValue();
        Configuration importConfig = new Configuration(){

            public int maxNumberOfProcessors() {
                return args.getNumber(ImportTool.Options.PROCESSORS.key(), (Number)DEFAULT.maxNumberOfProcessors()).intValue();
            }

            public int denseNodeThreshold() {
                return args.getNumber(GraphDatabaseSettings.dense_node_threshold.name(), (Number)DEFAULT.denseNodeThreshold()).intValue();
            }

            public boolean parallelRecordReadsWhenWriting() {
                return highIo;
            }

            public long pageCacheMemory() {
                return pageCacheMemory;
            }
        };
        float factorBadNodeData = args.getNumber("factor-bad-node-data", (Number)0).floatValue();
        float factorBadRelationshipData = args.getNumber("factor-bad-relationship-data", (Number)0).floatValue();
        SimpleDataGenerator generator = new SimpleDataGenerator(nodeHeader, relationshipHeader, randomSeed, nodeCount, labelCount, relationshipTypeCount, idType, factorBadNodeData, factorBadRelationshipData);
        DataGeneratorInput input = new DataGeneratorInput(nodeCount, relationshipCount, generator.nodes(), generator.relationships(), idType, Collector.EMPTY);
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            CsvOutput consumer = args.getBoolean("to-csv") ? new CsvOutput(dir, nodeHeader, relationshipHeader, config) : new ParallelBatchImporter(dir, (FileSystemAbstraction)fileSystem, importConfig, (LogService)new SimpleLogService((LogProvider)sysoutLogProvider, (LogProvider)sysoutLogProvider), ExecutionMonitors.defaultVisible(), dbConfig);
            consumer.doImport(input);
        }
    }

    private static Header parseNodeHeader(Args args, IdType idType, Extractors extractors) {
        String definition = args.get("node-header", null);
        if (definition == null) {
            return DataGeneratorInput.bareboneNodeHeader(idType, extractors);
        }
        org.neo4j.unsafe.impl.batchimport.input.csv.Configuration config = org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS;
        return DataFactories.defaultFormatNodeFileHeader().create(QuickImport.seeker(definition, config), config, idType);
    }

    private static Header parseRelationshipHeader(Args args, IdType idType, Extractors extractors) {
        String definition = args.get("relationship-header", null);
        if (definition == null) {
            return DataGeneratorInput.bareboneRelationshipHeader(idType, extractors);
        }
        org.neo4j.unsafe.impl.batchimport.input.csv.Configuration config = org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS;
        return DataFactories.defaultFormatRelationshipFileHeader().create(QuickImport.seeker(definition, config), config, idType);
    }

    private static CharSeeker seeker(String definition, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration config) {
        return CharSeekers.charSeeker((CharReadable)Readables.wrap((Reader)new StringReader(definition)), (org.neo4j.csv.reader.Configuration)new Configuration.Overridden((org.neo4j.csv.reader.Configuration)config){

            public int bufferSize() {
                return 10000;
            }
        }, (boolean)false);
    }
}

