/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.csv.reader.IllegalMultilineFieldException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.tooling.ImportTool;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class ImportToolTest {
    private static final int MAX_LABEL_ID = 4;
    private static final int RELATIONSHIP_COUNT = 10000;
    private static final int NODE_COUNT = 100;
    private static final IntPredicate TRUE = i -> true;
    @Rule
    public final EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule().startLazily();
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppress((SuppressOutput.Suppressible[])SuppressOutput.System.values());
    private int dataIndex;

    @Test
    public void usageMessageIncludeExample() throws Exception {
        SuppressOutput.Voice outputVoice = this.suppressOutput.getOutputVoice();
        ImportToolTest.importTool("?");
        Assert.assertTrue((String)("Usage message should include example section, but was:" + outputVoice), (boolean)outputVoice.containsMessage("Example:"));
    }

    @Test
    public void usageMessagePrintedOnEmptyInputParameters() throws Exception {
        SuppressOutput.Voice outputVoice = this.suppressOutput.getOutputVoice();
        ImportToolTest.importTool(new String[0]);
        Assert.assertTrue((String)("Output should include usage section, but was:" + outputVoice), (boolean)outputVoice.containsMessage("Example:"));
    }

    @Test
    public void shouldImportWithAsManyDefaultsAsAvailable() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath(), "--relationships", this.relationshipData(true, config, nodeIds, TRUE, true).getAbsolutePath());
        this.verifyData();
    }

    @Test
    public void shouldImportWithHeadersBeingInSeparateFiles() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.TABS;
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--delimiter", "TAB", "--array-delimiter", String.valueOf(config.arrayDelimiter()), "--nodes", this.nodeHeader(config).getAbsolutePath() + "," + this.nodeData(false, config, nodeIds, TRUE).getAbsolutePath(), "--relationships", this.relationshipHeader(config).getAbsolutePath() + "," + this.relationshipData(false, config, nodeIds, TRUE, true).getAbsolutePath());
        this.verifyData();
    }

    @Test
    public void import4097Labels() throws Exception {
        File header = this.file(this.fileName("4097labels-header.csv"));
        try (PrintStream writer = new PrintStream(header);){
            writer.println(":LABEL");
        }
        File data = this.file(this.fileName("4097labels.csv"));
        try (PrintStream writer = new PrintStream(data);){
            for (int i = 0; i < 4096; ++i) {
                writer.println("SIMPLE" + i);
            }
            writer.println("FIRST 4096|SECOND 4096|");
        }
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--delimiter", "TAB", "--array-delimiter", "|", "--nodes", header.getAbsolutePath() + "," + data.getAbsolutePath());
        var4_6 = null;
        try (Transaction tx = this.dbRule.beginTx();){
            long nodeCount = Iterables.count((Iterable)this.dbRule.getAllNodes());
            Assert.assertEquals((long)4097L, (long)nodeCount);
            tx.success();
            ResourceIterator nodes = this.dbRule.findNodes(Label.label((String)"FIRST 4096"));
            Assert.assertEquals((long)1L, (long)Iterators.asList((Iterator)nodes).size());
            nodes = this.dbRule.findNodes(Label.label((String)"SECOND 4096"));
            Assert.assertEquals((long)1L, (long)Iterators.asList((Iterator)nodes).size());
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldIgnoreWhitespaceAroundIntegers() throws Exception {
        List<String> values = Arrays.asList("17", "    21", "99   ", "  34  ", "-34", "        -12", "-92 ");
        File data = this.file(this.fileName("whitespace.csv"));
        try (PrintStream writer = new PrintStream(data);){
            writer.println(":LABEL,name,s:short,b:byte,i:int,l:long,f:float,d:double");
            for (String value : values) {
                writer.print("PERSON,'" + value + "'");
                for (int j = 0; j < 6; ++j) {
                    writer.print("," + value);
                }
                writer.println();
            }
        }
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--quote", "'", "--nodes", data.getAbsolutePath());
        int nodeCount = 0;
        Transaction tx = this.dbRule.beginTx();
        Object object = null;
        try {
            for (Node node : this.dbRule.getAllNodes()) {
                ++nodeCount;
                String name = (String)node.getProperty("name");
                String expected = name.trim();
                Assert.assertEquals((long)7L, (long)node.getAllProperties().size());
                for (String key : node.getPropertyKeys()) {
                    if (key.equals("name")) continue;
                    if (key.equals("f") || key.equals("d")) {
                        expected = String.valueOf(Double.parseDouble(expected));
                    }
                    Assert.assertEquals((String)("Wrong value for " + key), (Object)expected, (Object)node.getProperty(key).toString());
                }
            }
            tx.success();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)values.size(), (long)nodeCount);
    }

    @Test
    public void shouldIgnoreWhitespaceAroundDecimalNumbers() throws Exception {
        List<String> values = Arrays.asList("1.0", "   3.5", "45.153    ", "   925.12   ", "-2.121", "   -3.745", "-412.153    ", "   -5.12   ");
        File data = this.file(this.fileName("whitespace.csv"));
        try (PrintStream writer = new PrintStream(data);){
            writer.println(":LABEL,name,f:float,d:double");
            for (String value : values) {
                writer.print("PERSON,'" + value + "'");
                for (int j = 0; j < 2; ++j) {
                    writer.print("," + value);
                }
                writer.println();
            }
        }
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--quote", "'", "--nodes", data.getAbsolutePath());
        int nodeCount = 0;
        Transaction tx = this.dbRule.beginTx();
        Object object = null;
        try {
            for (Node node : this.dbRule.getAllNodes()) {
                ++nodeCount;
                String name = (String)node.getProperty("name");
                double expected = Double.parseDouble(name.trim());
                Assert.assertEquals((long)3L, (long)node.getAllProperties().size());
                for (String key : node.getPropertyKeys()) {
                    if (key.equals("name")) continue;
                    Assert.assertTrue((String)("Wrong value for " + key), (expected == Double.valueOf(node.getProperty(key).toString()) ? 1 : 0) != 0);
                }
            }
            tx.success();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)values.size(), (long)nodeCount);
    }

    @Test
    public void shouldIgnoreWhitespaceAroundBooleans() throws Exception {
        File data = this.file(this.fileName("whitespace.csv"));
        try (PrintStream writer = new PrintStream(data);){
            writer.println(":LABEL,name,adult:boolean");
            writer.println("PERSON,'t1',true");
            writer.println("PERSON,'t2',  true");
            writer.println("PERSON,'t3',true  ");
            writer.println("PERSON,'t4',  true  ");
            writer.println("PERSON,'f1',false");
            writer.println("PERSON,'f2',  false");
            writer.println("PERSON,'f3',false  ");
            writer.println("PERSON,'f4',  false  ");
            writer.println("PERSON,'f5',  truebutactuallyfalse  ");
            writer.println("PERSON,'f6',  non true things are interpreted as false  ");
        }
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--quote", "'", "--nodes", data.getAbsolutePath());
        var3_3 = null;
        try (Transaction tx = this.dbRule.beginTx();){
            for (Node node : this.dbRule.getAllNodes()) {
                String name = (String)node.getProperty("name");
                if (name.startsWith("t")) {
                    Assert.assertTrue((String)("Wrong value on " + name), (boolean)((Boolean)node.getProperty("adult")));
                    continue;
                }
                Assert.assertFalse((String)("Wrong value on " + name), (boolean)((Boolean)node.getProperty("adult")));
            }
            long nodeCount = Iterables.count((Iterable)this.dbRule.getAllNodes());
            Assert.assertEquals((long)10L, (long)nodeCount);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldIgnoreWhitespaceInAndAroundIntegerArrays() throws Exception {
        String[] values = new String[]{"   17", "21", "99   ", "  34  ", "-34", "        -12", "-92 "};
        File data = this.writeArrayCsv(new String[]{"s:short[]", "b:byte[]", "i:int[]", "l:long[]", "f:float[]", "d:double[]"}, values);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--quote", "'", "--nodes", data.getAbsolutePath());
        String iExpected = this.joinStringArray(values);
        String fExpected = Arrays.stream(values).map(String::trim).map(Double::valueOf).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
        int nodeCount = 0;
        try (Transaction tx = this.dbRule.beginTx();){
            for (Node node : this.dbRule.getAllNodes()) {
                ++nodeCount;
                Assert.assertEquals((long)6L, (long)node.getAllProperties().size());
                for (String key : node.getPropertyKeys()) {
                    Object things = node.getProperty(key);
                    String result = "";
                    String expected = iExpected;
                    switch (key) {
                        case "s": {
                            result = Arrays.toString((short[])things);
                            break;
                        }
                        case "b": {
                            result = Arrays.toString((byte[])things);
                            break;
                        }
                        case "i": {
                            result = Arrays.toString((int[])things);
                            break;
                        }
                        case "l": {
                            result = Arrays.toString((long[])things);
                            break;
                        }
                        case "f": {
                            result = Arrays.toString((float[])things);
                            expected = fExpected;
                            break;
                        }
                        case "d": {
                            result = Arrays.toString((double[])things);
                            expected = fExpected;
                            break;
                        }
                    }
                    Assert.assertEquals((Object)expected, (Object)result);
                }
            }
            tx.success();
        }
        Assert.assertEquals((long)1L, (long)nodeCount);
    }

    @Test
    public void shouldIgnoreWhitespaceInAndAroundDecimalArrays() throws Exception {
        String[] values = new String[]{"1.0", "   3.5", "45.153    ", "   925.12   ", "-2.121", "   -3.745", "-412.153    ", "   -5.12   "};
        File data = this.writeArrayCsv(new String[]{"f:float[]", "d:double[]"}, values);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--quote", "'", "--nodes", data.getAbsolutePath());
        String expected = this.joinStringArray(values);
        int nodeCount = 0;
        try (Transaction tx = this.dbRule.beginTx();){
            for (Node node : this.dbRule.getAllNodes()) {
                ++nodeCount;
                Assert.assertEquals((long)2L, (long)node.getAllProperties().size());
                for (String key : node.getPropertyKeys()) {
                    Object things = node.getProperty(key);
                    String result = "";
                    switch (key) {
                        case "f": {
                            result = Arrays.toString((float[])things);
                            break;
                        }
                        case "d": {
                            result = Arrays.toString((double[])things);
                            break;
                        }
                    }
                    Assert.assertEquals((Object)expected, (Object)result);
                }
            }
            tx.success();
        }
        Assert.assertEquals((long)1L, (long)nodeCount);
    }

    @Test
    public void shouldIgnoreWhitespaceInAndAroundBooleanArrays() throws Exception {
        String[] values = new String[]{"true", "  true", "true   ", "  true  ", " false ", "false ", " false", "false ", " false"};
        String expected = this.joinStringArray(values);
        File data = this.writeArrayCsv(new String[]{"b:boolean[]"}, values);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--quote", "'", "--nodes", data.getAbsolutePath());
        int nodeCount = 0;
        try (Transaction tx = this.dbRule.beginTx();){
            for (Node node : this.dbRule.getAllNodes()) {
                ++nodeCount;
                Assert.assertEquals((long)1L, (long)node.getAllProperties().size());
                for (String key : node.getPropertyKeys()) {
                    Object things = node.getProperty(key);
                    String result = Arrays.toString((boolean[])things);
                    Assert.assertEquals((Object)expected, (Object)result);
                }
            }
            tx.success();
        }
        Assert.assertEquals((long)1L, (long)nodeCount);
    }

    @Test
    public void shouldFailIfHeaderHasLessColumnsThanData() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.TABS;
        int extraColumns = 3;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--delimiter", "TAB", "--array-delimiter", String.valueOf(config.arrayDelimiter()), "--nodes", this.nodeHeader(config).getAbsolutePath() + "," + this.nodeData(false, config, nodeIds, TRUE, Charset.defaultCharset(), extraColumns).getAbsolutePath(), "--relationships", this.relationshipHeader(config).getAbsolutePath() + "," + this.relationshipData(false, config, nodeIds, TRUE, true).getAbsolutePath());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InputException e) {
            Assert.assertFalse((boolean)this.suppressOutput.getErrorVoice().containsMessage(((Object)((Object)e)).getClass().getName()));
            Assert.assertTrue((boolean)e.getMessage().contains("Extra column not present in header on line"));
        }
    }

    @Test
    public void shouldWarnIfHeaderHasLessColumnsThanDataWhenToldTo() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.TABS;
        File bad = this.badFile();
        int extraColumns = 3;
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--bad", bad.getAbsolutePath(), "--bad-tolerance", Integer.toString(nodeIds.size() * extraColumns), "--ignore-extra-columns", "--delimiter", "TAB", "--array-delimiter", String.valueOf(config.arrayDelimiter()), "--nodes", this.nodeHeader(config).getAbsolutePath() + "," + this.nodeData(false, config, nodeIds, TRUE, Charset.defaultCharset(), extraColumns).getAbsolutePath(), "--relationships", this.relationshipHeader(config).getAbsolutePath() + "," + this.relationshipData(false, config, nodeIds, TRUE, true).getAbsolutePath());
        String badContents = FileUtils.readTextFile((File)bad, (Charset)Charset.defaultCharset());
        Assert.assertTrue((boolean)badContents.contains("Extra column not present in header on line"));
    }

    @Test
    public void shouldImportSplitInputFiles() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeHeader(config).getAbsolutePath() + "," + this.nodeData(false, config, nodeIds, this.lines(0, 50)).getAbsolutePath(), "--nodes", this.nodeData(true, config, nodeIds, this.lines(50, 75)).getAbsolutePath() + "," + this.nodeData(false, config, nodeIds, this.lines(75, 100)).getAbsolutePath(), "--relationships", this.relationshipHeader(config).getAbsolutePath() + "," + this.relationshipData(false, config, nodeIds, TRUE, true).getAbsolutePath());
        this.verifyData();
    }

    @Test
    public void shouldImportMultipleInputsWithAddedLabelsAndDefaultRelationshipType() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        Object[] firstLabels = new String[]{"AddedOne", "AddedTwo"};
        Object[] secondLabels = new String[]{"AddedThree"};
        String firstType = "TYPE_1";
        String secondType = "TYPE_2";
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes:" + ArrayUtil.join((Object[])firstLabels, (String)":"), this.nodeData(true, config, nodeIds, this.lines(0, 50)).getAbsolutePath(), "--nodes:" + ArrayUtil.join((Object[])secondLabels, (String)":"), this.nodeData(true, config, nodeIds, this.lines(50, 100)).getAbsolutePath(), "--relationships:TYPE_1", this.relationshipData(true, config, nodeIds, this.lines(0, 5000), false).getAbsolutePath(), "--relationships:TYPE_2", this.relationshipData(true, config, nodeIds, this.lines(5000, 10000), false).getAbsolutePath());
        this.verifyData((Validator<Node>)((Validator)arg_0 -> this.lambda$shouldImportMultipleInputsWithAddedLabelsAndDefaultRelationshipType$1((String[])firstLabels, (String[])secondLabels, arg_0)), (Validator<Relationship>)((Validator)relationship -> {
            if (relationship.getId() < 5000L) {
                Assert.assertEquals((Object)"TYPE_1", (Object)relationship.getType().name());
            } else {
                Assert.assertEquals((Object)"TYPE_2", (Object)relationship.getType().name());
            }
        }));
    }

    @Test
    public void shouldImportOnlyNodes() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath());
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            int nodeCount = 0;
            for (Node node : db.getAllNodes()) {
                Assert.assertTrue((boolean)node.hasProperty("name"));
                ++nodeCount;
                Assert.assertFalse((boolean)node.hasRelationship());
            }
            Assert.assertEquals((long)100L, (long)nodeCount);
            tx.success();
        }
    }

    @Test
    public void shouldImportGroupsOfOverlappingIds() throws Exception {
        List<String> groupOneNodeIds = Arrays.asList("1", "2", "3");
        List<String> groupTwoNodeIds = Arrays.asList("4", "5", "2");
        List<RelationshipDataLine> rels = Arrays.asList(ImportToolTest.relationship("1", "4", "TYPE"), ImportToolTest.relationship("2", "5", "TYPE"), ImportToolTest.relationship("3", "2", "TYPE"));
        Configuration config = Configuration.COMMAS;
        String groupOne = "Actor";
        String groupTwo = "Movie";
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeHeader(config, groupOne) + "," + this.nodeData(false, config, groupOneNodeIds, TRUE), "--nodes", this.nodeHeader(config, groupTwo) + "," + this.nodeData(false, config, groupTwoNodeIds, TRUE), "--relationships", this.relationshipHeader(config, groupOne, groupTwo, true) + "," + this.relationshipData(false, config, rels.iterator(), TRUE, true));
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            int nodeCount = 0;
            for (Node node : db.getAllNodes()) {
                Assert.assertTrue((boolean)node.hasProperty("name"));
                ++nodeCount;
                Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)node.getRelationships()));
            }
            Assert.assertEquals((long)6L, (long)nodeCount);
            tx.success();
        }
    }

    @Test
    public void shouldNotBeAbleToMixSpecifiedAndUnspecifiedGroups() throws Exception {
        List<String> groupOneNodeIds = Arrays.asList("1", "2", "3");
        List<String> groupTwoNodeIds = Arrays.asList("4", "5", "2");
        Configuration config = Configuration.COMMAS;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeHeader(config, "MyGroup").getAbsolutePath() + "," + this.nodeData(false, config, groupOneNodeIds, TRUE).getAbsolutePath(), "--nodes", this.nodeHeader(config).getAbsolutePath() + "," + this.nodeData(false, config, groupTwoNodeIds, TRUE).getAbsolutePath());
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            ImportToolTest.assertExceptionContains(e, "Mixing specified", IllegalStateException.class);
        }
    }

    @Test
    public void shouldImportWithoutTypeSpecifiedInRelationshipHeaderbutWithDefaultTypeInArgument() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        String type = this.randomType();
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath(), "--relationships:" + type, this.relationshipData(true, config, nodeIds, TRUE, false).getAbsolutePath());
        this.verifyData();
    }

    @Test
    public void shouldIncludeSourceInformationInNodeIdCollisionError() throws Exception {
        List<String> nodeIds = Arrays.asList("a", "b", "c", "d", "e", "f", "a", "g");
        Configuration config = Configuration.COMMAS;
        File nodeHeaderFile = this.nodeHeader(config);
        File nodeData1 = this.nodeData(false, config, nodeIds, this.lines(0, 4));
        File nodeData2 = this.nodeData(false, config, nodeIds, this.lines(4, nodeIds.size()));
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", nodeHeaderFile.getAbsolutePath() + "," + nodeData1.getAbsolutePath() + "," + nodeData2.getAbsolutePath());
            Assert.fail((String)"Should have failed with duplicate node IDs");
        }
        catch (Exception e) {
            ImportToolTest.assertExceptionContains(e, nodeData1.getPath() + ":" + 1, DuplicateInputIdException.class);
            ImportToolTest.assertExceptionContains(e, nodeData2.getPath() + ":" + 3, DuplicateInputIdException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSkipDuplicateNodesIfToldTo() throws Exception {
        List<String> nodeIds = Arrays.asList("a", "b", "c", "d", "e", "f", "a", "g");
        Configuration config = Configuration.COMMAS;
        File nodeHeaderFile = this.nodeHeader(config);
        File nodeData1 = this.nodeData(false, config, nodeIds, this.lines(0, 4));
        File nodeData2 = this.nodeData(false, config, nodeIds, this.lines(4, nodeIds.size()));
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--skip-duplicate-nodes", "--nodes", nodeHeaderFile.getAbsolutePath() + "," + nodeData1.getAbsolutePath() + "," + nodeData2.getAbsolutePath());
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            ResourceIterator nodes = db.getAllNodes().iterator();
            Iterator expectedIds = FilteringIterator.noDuplicates(nodeIds.iterator());
            while (expectedIds.hasNext()) {
                Assert.assertTrue((boolean)nodes.hasNext());
                Assert.assertEquals(expectedIds.next(), (Object)((Node)nodes.next()).getProperty("id"));
            }
            Assert.assertFalse((boolean)nodes.hasNext());
            for (int i = 0; i < 4; ++i) {
                Label label = Label.label((String)this.labelName(i));
                try (ResourceIterator nodesByLabel = db.findNodes(label);){
                    while (nodesByLabel.hasNext()) {
                        Assert.assertTrue((boolean)((Node)nodesByLabel.next()).hasLabel(label));
                    }
                    continue;
                }
            }
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void shouldLogRelationshipsReferringToMissingNode() throws Exception {
        List<String> nodeIds = Arrays.asList("a", "b", "c");
        Configuration config = Configuration.COMMAS;
        File nodeData = this.nodeData(true, config, nodeIds, TRUE);
        List<RelationshipDataLine> relationships = Arrays.asList(ImportToolTest.relationship("a", "b", "TYPE", "aa"), ImportToolTest.relationship("c", "bogus", "TYPE", "bb"), ImportToolTest.relationship("b", "c", "KNOWS", "cc"), ImportToolTest.relationship("c", "a", "KNOWS", "dd"), ImportToolTest.relationship("missing", "a", "KNOWS", "ee"));
        File relationshipData1 = this.relationshipData(true, config, relationships.iterator(), this.lines(0, 2), true);
        File relationshipData2 = this.relationshipData(false, config, relationships.iterator(), this.lines(2, 5), true);
        File bad = this.badFile();
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", nodeData.getAbsolutePath(), "--bad", bad.getAbsolutePath(), "--bad-tolerance", "2", "--relationships", relationshipData1.getAbsolutePath() + "," + relationshipData2.getAbsolutePath());
        String badContents = FileUtils.readTextFile((File)bad, (Charset)Charset.defaultCharset());
        Assert.assertTrue((String)"Didn't contain first bad relationship", (boolean)badContents.contains(relationshipData1.getAbsolutePath() + ":3"));
        Assert.assertTrue((String)"Didn't contain second bad relationship", (boolean)badContents.contains(relationshipData2.getAbsolutePath() + ":3"));
        this.verifyRelationships(relationships);
    }

    @Test
    public void skipLoggingOfBadEntries() throws Exception {
        List<String> nodeIds = Arrays.asList("a", "b", "c");
        Configuration config = Configuration.COMMAS;
        File nodeData = this.nodeData(true, config, nodeIds, TRUE);
        List<RelationshipDataLine> relationships = Arrays.asList(ImportToolTest.relationship("a", "b", "TYPE", "aa"), ImportToolTest.relationship("c", "bogus", "TYPE", "bb"), ImportToolTest.relationship("b", "c", "KNOWS", "cc"), ImportToolTest.relationship("c", "a", "KNOWS", "dd"), ImportToolTest.relationship("missing", "a", "KNOWS", "ee"));
        File relationshipData1 = this.relationshipData(true, config, relationships.iterator(), this.lines(0, 2), true);
        File relationshipData2 = this.relationshipData(false, config, relationships.iterator(), this.lines(2, 5), true);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", nodeData.getAbsolutePath(), "--bad-tolerance", "2", "--skip-bad-entries-logging", "true", "--relationships", relationshipData1.getAbsolutePath() + "," + relationshipData2.getAbsolutePath());
        Assert.assertFalse((boolean)this.badFile().exists());
        this.verifyRelationships(relationships);
    }

    @Test
    public void shouldFailIfTooManyBadRelationships() throws Exception {
        List<String> nodeIds = Arrays.asList("a", "b", "c");
        Configuration config = Configuration.COMMAS;
        File nodeData = this.nodeData(true, config, nodeIds, TRUE);
        List<RelationshipDataLine> relationships = Arrays.asList(ImportToolTest.relationship("a", "b", "TYPE"), ImportToolTest.relationship("c", "bogus", "TYPE"), ImportToolTest.relationship("b", "c", "KNOWS"), ImportToolTest.relationship("c", "a", "KNOWS"), ImportToolTest.relationship("missing", "a", "KNOWS"));
        File relationshipData1 = this.relationshipData(true, config, relationships.iterator(), this.lines(0, 2), true);
        File relationshipData2 = this.relationshipData(false, config, relationships.iterator(), this.lines(2, 5), true);
        File bad = this.badFile();
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", nodeData.getAbsolutePath(), "--bad", bad.getAbsolutePath(), "--bad-tolerance", "1", "--relationships", relationshipData1.getAbsolutePath() + "," + relationshipData2.getAbsolutePath());
        }
        catch (Exception e) {
            ImportToolTest.assertExceptionContains(e, relationshipData2.getAbsolutePath() + ":3", InputException.class);
        }
    }

    @Test
    public void shouldBeAbleToDisableSkippingOfBadRelationships() throws Exception {
        List<String> nodeIds = Arrays.asList("a", "b", "c");
        Configuration config = Configuration.COMMAS;
        File nodeData = this.nodeData(true, config, nodeIds, TRUE);
        List<RelationshipDataLine> relationships = Arrays.asList(ImportToolTest.relationship("a", "b", "TYPE"), ImportToolTest.relationship("c", "bogus", "TYPE"));
        File relationshipData1 = this.relationshipData(true, config, relationships.iterator(), this.lines(0, 2), true);
        File relationshipData2 = this.relationshipData(false, config, relationships.iterator(), this.lines(2, 5), true);
        File bad = this.badFile();
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", nodeData.getAbsolutePath(), "--bad", bad.getAbsolutePath(), "--stacktrace", "--skip-bad-relationships", "false", "--relationships", relationshipData1.getAbsolutePath() + "," + relationshipData2.getAbsolutePath());
        }
        catch (Exception e) {
            ImportToolTest.assertExceptionContains(e, relationshipData1.getAbsolutePath() + ":3", InputException.class);
        }
    }

    @Test
    public void shouldHandleAdditiveLabelsWithSpaces() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        Label label1 = Label.label((String)"My First Label");
        Label label2 = Label.label((String)"My Other Label");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes:My First Label:My Other Label", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath(), "--relationships", this.relationshipData(true, config, nodeIds, TRUE, true).getAbsolutePath());
        this.verifyData((Validator<Node>)((Validator)node -> {
            Assert.assertTrue((boolean)node.hasLabel(label1));
            Assert.assertTrue((boolean)node.hasLabel(label2));
        }), (Validator<Relationship>)Validators.emptyValidator());
    }

    @Test
    public void shouldImportFromInputDataEncodedWithSpecificCharset() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        Charset charset = Charset.forName("UTF-16");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--input-encoding", charset.name(), "--nodes", this.nodeData(true, config, nodeIds, TRUE, charset).getAbsolutePath(), "--relationships", this.relationshipData(true, config, nodeIds, TRUE, true, charset).getAbsolutePath());
        this.verifyData();
    }

    @Test
    public void shouldDisallowImportWithoutNodesInput() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.COMMAS;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--relationships", this.relationshipData(true, config, nodeIds, TRUE, true).getAbsolutePath());
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No node input"));
        }
    }

    @Test
    public void shouldBeAbleToImportAnonymousNodes() throws Exception {
        List<String> nodeIds = Arrays.asList("1", "", "", "", "3", "", "", "", "", "", "5");
        Configuration config = Configuration.COMMAS;
        List<RelationshipDataLine> relationshipData = Arrays.asList(ImportToolTest.relationship("1", "3", "KNOWS"));
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath(), "--relationships", this.relationshipData(true, config, relationshipData.iterator(), TRUE, true).getAbsolutePath());
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            ResourceIterable allNodes = db.getAllNodes();
            int anonymousCount = 0;
            for (String id : nodeIds) {
                if (id.isEmpty()) {
                    ++anonymousCount;
                    continue;
                }
                Assert.assertNotNull((Object)Iterators.single((Iterator)Iterators.filter(this.nodeFilter(id), allNodes.iterator())));
            }
            Assert.assertEquals((long)anonymousCount, (long)Iterators.count((Iterator)Iterators.filter(this.nodeFilter(""), allNodes.iterator())));
            tx.success();
        }
    }

    @Test
    public void shouldDisallowMultilineFieldsByDefault() throws Exception {
        File data = this.data(":ID,name", "1,\"This is a line with\nnewlines in\"");
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath());
        }
        catch (Exception e) {
            ImportToolTest.assertExceptionContains(e, "Multi-line", IllegalMultilineFieldException.class);
        }
    }

    @Test
    public void shouldNotTrimStringsByDefault() throws Exception {
        String name = "  This is a line with leading and trailing whitespaces   ";
        File data = this.data(":ID,name", "1,\"" + name + "\"");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath());
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            ResourceIterator allNodes = db.getAllNodes().iterator();
            Node node = (Node)Iterators.single((Iterator)allNodes);
            allNodes.close();
            Assert.assertEquals((Object)name, (Object)node.getProperty("name"));
            tx.success();
        }
    }

    @Test
    public void shouldTrimStringsIfConfiguredTo() throws Exception {
        String name = "  This is a line with leading and trailing whitespaces   ";
        File data = this.data(":ID,name", "1,\"" + name + "\"");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--trim-strings", "true");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            ResourceIterator allNodes = db.getAllNodes().iterator();
            Node node = (Node)Iterators.single((Iterator)allNodes);
            allNodes.close();
            Assert.assertEquals((Object)name.trim(), (Object)node.getProperty("name"));
            tx.success();
        }
    }

    @Test
    public void shouldPrintReferenceLinkOnDataImportErrors() throws Exception {
        CharSequence[] versionParts = Version.getNeo4jVersion().split("-");
        versionParts[0] = versionParts[0].substring(0, 3);
        String docsVersion = String.join((CharSequence)"-", versionParts);
        this.shouldPrintReferenceLinkAsPartOfErrorMessage(this.nodeIds(), Iterators.iterator((Object)new RelationshipDataLine("1", "", "type", "name")), "Relationship missing mandatory field 'END_ID', read more about relationship format in the manual:  https://neo4j.com/docs/operations-manual/" + docsVersion + "/tools/import/file-header-format/#import-tool-header-format-rels");
        this.shouldPrintReferenceLinkAsPartOfErrorMessage(this.nodeIds(), Iterators.iterator((Object)new RelationshipDataLine("", "1", "type", "name")), "Relationship missing mandatory field 'START_ID', read more about relationship format in the manual:  https://neo4j.com/docs/operations-manual/" + docsVersion + "/tools/import/file-header-format/#import-tool-header-format-rels");
        this.shouldPrintReferenceLinkAsPartOfErrorMessage(this.nodeIds(), Iterators.iterator((Object)new RelationshipDataLine("1", "2", "", "name")), "Relationship missing mandatory field 'TYPE', read more about relationship format in the manual:  https://neo4j.com/docs/operations-manual/" + docsVersion + "/tools/import/file-header-format/#import-tool-header-format-rels");
        this.shouldPrintReferenceLinkAsPartOfErrorMessage(Arrays.asList("1", "1"), Iterators.iterator((Object)new RelationshipDataLine("1", "2", "type", "name")), "Duplicate input ids that would otherwise clash can be put into separate id space, read more about how to use id spaces in the manual: https://neo4j.com/docs/operations-manual/" + docsVersion + "/tools/import/file-header-format/#import-tool-id-spaces");
    }

    @Test
    public void shouldCollectUnlimitedNumberOfBadEntries() throws Exception {
        List<String> nodeIds = Collections.nCopies(10000, "A");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, Configuration.COMMAS, nodeIds, TRUE).getAbsolutePath(), "--skip-duplicate-nodes", "--bad-tolerance", "true");
    }

    private void shouldPrintReferenceLinkAsPartOfErrorMessage(List<String> nodeIds, Iterator<RelationshipDataLine> relationshipDataLines, String message) throws Exception {
        Configuration config = Configuration.COMMAS;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath(), "--skip-bad-relationships", "false", "--relationships", this.relationshipData(true, config, relationshipDataLines, TRUE, true).getAbsolutePath());
            Assert.fail((String)" Should fail during import.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)this.suppressOutput.getErrorVoice().containsMessage(message));
        }
        for (StoreType storeType : StoreType.values()) {
            if (!storeType.isRecordStore()) continue;
            new File(this.dbRule.getStoreDirFile(), "neostore" + storeType.getStoreName()).delete();
        }
    }

    @Test
    public void shouldAllowMultilineFieldsWhenEnabled() throws Exception {
        File data = this.data(":ID,name", "1,\"This is a line with\nnewlines in\"");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--multiline-fields", "true");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            ResourceIterator allNodes = db.getAllNodes().iterator();
            Node node = (Node)Iterators.single((Iterator)allNodes);
            allNodes.close();
            Assert.assertEquals((Object)"This is a line with\nnewlines in", (Object)node.getProperty("name"));
            tx.success();
        }
    }

    @Test
    public void shouldSkipEmptyFiles() throws Exception {
        File data = this.data("");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath());
        GraphDatabaseAPI graphDatabaseService = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = graphDatabaseService.beginTx();){
            ResourceIterator allNodes = graphDatabaseService.getAllNodes().iterator();
            Assert.assertFalse((String)"Expected database to be empty", (boolean)allNodes.hasNext());
            tx.success();
        }
    }

    @Test
    public void shouldIgnoreEmptyQuotedStringsIfConfiguredTo() throws Exception {
        File data = this.data(":ID,one,two,three", "1,\"\",,value");
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--ignore-empty-strings", "true");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Node node = (Node)Iterables.single((Iterable)db.getAllNodes());
            Assert.assertEquals((Object)"three", (Object)Iterables.single((Iterable)node.getPropertyKeys()));
            tx.success();
        }
    }

    @Test
    public void shouldPrintUserFriendlyMessageAboutUnsupportedMultilineFields() throws Exception {
        File data = this.data(":ID,name", "1,\"one\ntwo\nthree\"", "2,four");
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--multiline-fields", "false");
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertTrue((boolean)this.suppressOutput.getErrorVoice().containsMessage("Detected field which spanned multiple lines"));
            Assert.assertTrue((boolean)this.suppressOutput.getErrorVoice().containsMessage("multiline-fields"));
        }
    }

    @Test
    public void shouldAcceptRawAsciiCharacterCodeAsQuoteConfiguration() throws Exception {
        char weirdDelimiter = '\u0001';
        String name1 = weirdDelimiter + "Weird" + weirdDelimiter;
        String name2 = "Start " + weirdDelimiter + "middle thing" + weirdDelimiter + " end!";
        File data = this.data(":ID,name", "1," + name1, "2," + name2);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--quote", String.valueOf(weirdDelimiter));
        Set names = Iterators.asSet((Object[])new String[]{"Weird", name2});
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                String name = (String)node.getProperty("name");
                Assert.assertTrue((String)("Didn't expect node with name '" + name + "'"), (boolean)names.remove(name));
            }
            Assert.assertTrue((boolean)names.isEmpty());
            tx.success();
        }
    }

    @Test
    public void shouldAcceptSpecialTabCharacterAsDelimiterConfiguration() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.TABS;
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--delimiter", "\\t", "--array-delimiter", String.valueOf(config.arrayDelimiter()), "--nodes", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath(), "--relationships", this.relationshipData(true, config, nodeIds, TRUE, true).getAbsolutePath());
        this.verifyData();
    }

    @Test
    public void shouldReportBadDelimiterConfiguration() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.TABS;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--delimiter", "\\bogus", "--array-delimiter", String.valueOf(config.arrayDelimiter()), "--nodes", this.nodeData(true, config, nodeIds, TRUE).getAbsolutePath(), "--relationships", this.relationshipData(true, config, nodeIds, TRUE, true).getAbsolutePath());
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"bogus"));
        }
    }

    @Test
    public void shouldFailAndReportStartingLineForUnbalancedQuoteInMiddle() throws Exception {
        int unbalancedStartLine = 10;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeDataWithMissingQuote(2 * unbalancedStartLine, unbalancedStartLine).getAbsolutePath());
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)String.format("See line %d", unbalancedStartLine)));
        }
    }

    @Test
    public void shouldAcceptRawEscapedAsciiCodeAsQuoteConfiguration() throws Exception {
        char weirdDelimiter = '\u0001';
        String name1 = weirdDelimiter + "Weird" + weirdDelimiter;
        String name2 = "Start " + weirdDelimiter + "middle thing" + weirdDelimiter + " end!";
        File data = this.data(":ID,name", "1," + name1, "2," + name2);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--quote", "\\1");
        Set names = Iterators.asSet((Object[])new String[]{"Weird", name2});
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                String name = (String)node.getProperty("name");
                Assert.assertTrue((String)("Didn't expect node with name '" + name + "'"), (boolean)names.remove(name));
            }
            Assert.assertTrue((boolean)names.isEmpty());
            tx.success();
        }
    }

    @Test
    public void shouldFailAndReportStartingLineForUnbalancedQuoteAtEnd() throws Exception {
        int unbalancedStartLine = 10;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeDataWithMissingQuote(unbalancedStartLine, unbalancedStartLine).getAbsolutePath());
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)String.format("See line %d", unbalancedStartLine)));
        }
    }

    @Test
    public void shouldBeEquivalentToUseRawAsciiOrCharacterAsQuoteConfiguration1() throws Exception {
        char weirdDelimiter = '~';
        String weirdStringDelimiter = "\\126";
        String name1 = weirdDelimiter + "Weird" + weirdDelimiter;
        String name2 = "Start " + weirdDelimiter + "middle thing" + weirdDelimiter + " end!";
        File data = this.data(":ID,name", "1," + name1, "2," + name2);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--quote", weirdStringDelimiter);
        Assert.assertEquals((Object)"~", (Object)("" + weirdDelimiter));
        Assert.assertEquals((long)"~".charAt(0), (long)weirdDelimiter);
        Set names = Iterators.asSet((Object[])new String[]{"Weird", name2});
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                String name = (String)node.getProperty("name");
                Assert.assertTrue((String)("Didn't expect node with name '" + name + "'"), (boolean)names.remove(name));
            }
            Assert.assertTrue((boolean)names.isEmpty());
            tx.success();
        }
    }

    @Test
    public void shouldFailAndReportStartingLineForUnbalancedQuoteWithMultilinesEnabled() throws Exception {
        int unbalancedStartLine = 10;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--multiline-fields", "true", "--nodes", this.nodeDataWithMissingQuote(2 * unbalancedStartLine, unbalancedStartLine).getAbsolutePath());
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)String.format("started on line %d", unbalancedStartLine)));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)String.format("line:%d", 2 * unbalancedStartLine + 1)));
        }
    }

    private File nodeDataWithMissingQuote(int totalLines, int unbalancedStartLine) throws Exception {
        String[] lines = new String[totalLines + 1];
        lines[0] = "ID,:LABEL";
        for (int i = 1; i <= totalLines; ++i) {
            StringBuilder line = new StringBuilder(String.format("%d,", i));
            if (i == unbalancedStartLine) {
                line.append("\"Secret Agent");
            } else {
                line.append("Agent");
            }
            lines[i] = line.toString();
        }
        return this.data(lines);
    }

    @Test
    public void shouldBeEquivalentToUseRawAsciiOrCharacterAsQuoteConfiguration2() throws Exception {
        char weirdDelimiter = '~';
        String weirdStringDelimiter = "~";
        String name1 = weirdDelimiter + "Weird" + weirdDelimiter;
        String name2 = "Start " + weirdDelimiter + "middle thing" + weirdDelimiter + " end!";
        File data = this.data(":ID,name", "1," + name1, "2," + name2);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", data.getAbsolutePath(), "--quote", weirdStringDelimiter);
        Assert.assertEquals((Object)weirdStringDelimiter, (Object)("" + weirdDelimiter));
        Assert.assertEquals((long)weirdStringDelimiter.charAt(0), (long)weirdDelimiter);
        Set names = Iterators.asSet((Object[])new String[]{"Weird", name2});
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                String name = (String)node.getProperty("name");
                Assert.assertTrue((String)("Didn't expect node with name '" + name + "'"), (boolean)names.remove(name));
            }
            Assert.assertTrue((boolean)names.isEmpty());
            tx.success();
        }
    }

    @Test
    public void shouldRespectDbConfig() throws Exception {
        int arrayBlockSize = 10;
        int stringBlockSize = 12;
        File dbConfig = this.file("neo4j.properties");
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.array_block_size.name(), String.valueOf(arrayBlockSize), GraphDatabaseSettings.string_block_size.name(), String.valueOf(stringBlockSize)}), (File)dbConfig);
        List<String> nodeIds = this.nodeIds();
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--db-config", dbConfig.getAbsolutePath(), "--nodes", this.nodeData(true, Configuration.COMMAS, nodeIds, value -> true).getAbsolutePath());
        NeoStores stores = ((RecordStorageEngine)this.dbRule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        int headerSize = Standard.LATEST_RECORD_FORMATS.dynamic().getRecordHeaderSize();
        Assert.assertEquals((long)(arrayBlockSize + headerSize), (long)stores.getPropertyStore().getArrayStore().getRecordSize());
        Assert.assertEquals((long)(stringBlockSize + headerSize), (long)stores.getPropertyStore().getStringStore().getRecordSize());
    }

    @Test
    public void useProvidedAdditionalConfig() throws Exception {
        int arrayBlockSize = 10;
        int stringBlockSize = 12;
        File dbConfig = this.file("neo4j.properties");
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.array_block_size.name(), String.valueOf(arrayBlockSize), GraphDatabaseSettings.string_block_size.name(), String.valueOf(stringBlockSize)}), (File)dbConfig);
        List<String> nodeIds = this.nodeIds();
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--additional-config", dbConfig.getAbsolutePath(), "--nodes", this.nodeData(true, Configuration.COMMAS, nodeIds, value -> true).getAbsolutePath());
        NeoStores stores = ((RecordStorageEngine)this.dbRule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        int headerSize = Standard.LATEST_RECORD_FORMATS.dynamic().getRecordHeaderSize();
        Assert.assertEquals((long)(arrayBlockSize + headerSize), (long)stores.getPropertyStore().getArrayStore().getRecordSize());
        Assert.assertEquals((long)(stringBlockSize + headerSize), (long)stores.getPropertyStore().getStringStore().getRecordSize());
    }

    @Test
    public void combineProvidedDbAndAdditionalConfig() throws Exception {
        int arrayBlockSize = 10;
        int stringBlockSize = 12;
        File dbConfig = this.file("neo4j.properties");
        File additionalConfig = this.file("additional.properties");
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.string_block_size.name(), String.valueOf(stringBlockSize)}), (File)dbConfig);
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.array_block_size.name(), String.valueOf(arrayBlockSize)}), (File)additionalConfig);
        List<String> nodeIds = this.nodeIds();
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--db-config", dbConfig.getAbsolutePath(), "--additional-config", additionalConfig.getAbsolutePath(), "--nodes", this.nodeData(true, Configuration.COMMAS, nodeIds, value -> true).getAbsolutePath());
        NeoStores stores = ((RecordStorageEngine)this.dbRule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        int headerSize = Standard.LATEST_RECORD_FORMATS.dynamic().getRecordHeaderSize();
        Assert.assertEquals((long)(arrayBlockSize + headerSize), (long)stores.getPropertyStore().getArrayStore().getRecordSize());
        Assert.assertEquals((long)(stringBlockSize + headerSize), (long)stores.getPropertyStore().getStringStore().getRecordSize());
    }

    @Test
    public void shouldPrintStackTraceOnInputExceptionIfToldTo() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.TABS;
        int extraColumns = 3;
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeHeader(config).getAbsolutePath() + "," + this.nodeData(false, config, nodeIds, TRUE, Charset.defaultCharset(), extraColumns).getAbsolutePath(), "--stacktrace");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InputException e) {
            Assert.assertTrue((boolean)this.suppressOutput.getErrorVoice().containsMessage(((Object)((Object)e)).getClass().getName()));
            Assert.assertTrue((boolean)e.getMessage().contains("Extra column not present in header on line"));
        }
    }

    @Test
    public void shouldDisableLegacyStyleQuotingIfToldTo() throws Exception {
        String nodeId = "me";
        String labelName = "Alive";
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(":ID,name,:LABEL");
        lines.add(nodeId + ",\"abc\"\"def\\\"\"ghi\"," + labelName);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.data(lines.toArray(new String[lines.size()])).getAbsolutePath(), "--legacy-style-quoting", "false", "--stacktrace");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Assert.assertNotNull((Object)db.findNode(Label.label((String)labelName), "name", (Object)"abc\"def\\\"ghi"));
        }
    }

    @Test
    public void shouldRespectBufferSizeSetting() throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(":ID,name,:LABEL");
        lines.add("id," + StringUtils.repeat((char)'l', (int)2000) + ",Person");
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.data(lines.toArray(new String[lines.size()])).getAbsolutePath(), "--read-buffer-size", "1k");
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"input data"));
        }
    }

    @Test
    public void shouldRespectMaxMemoryPercentageSetting() throws Exception {
        List<String> nodeIds = this.nodeIds(10);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, Configuration.COMMAS, nodeIds, TRUE).getAbsolutePath(), "--max-memory", "60%");
    }

    @Test
    public void shouldFailOnInvalidMaxMemoryPercentageSetting() throws Exception {
        List<String> nodeIds = this.nodeIds(10);
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, Configuration.COMMAS, nodeIds, TRUE).getAbsolutePath(), "--max-memory", "110%");
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"percent"));
        }
    }

    @Test
    public void shouldRespectMaxMemorySuffixedSetting() throws Exception {
        List<String> nodeIds = this.nodeIds(10);
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", this.nodeData(true, Configuration.COMMAS, nodeIds, TRUE).getAbsolutePath(), "--max-memory", "100M");
    }

    @Test
    public void shouldTreatRelationshipWithMissingStartOrEndIdOrTypeAsBadRelationship() throws Exception {
        List<String> nodeIds = Arrays.asList("a", "b", "c");
        Configuration config = Configuration.COMMAS;
        File nodeData = this.nodeData(true, config, nodeIds, TRUE);
        List<RelationshipDataLine> relationships = Arrays.asList(ImportToolTest.relationship("a", null, "TYPE"), ImportToolTest.relationship(null, "b", "TYPE"), ImportToolTest.relationship("a", "b", null));
        File relationshipData = this.relationshipData(true, config, relationships.iterator(), TRUE, true);
        File bad = this.badFile();
        ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--nodes", nodeData.getAbsolutePath(), "--bad", bad.getAbsolutePath(), "--skip-bad-relationships", "true", "--relationships", relationshipData.getAbsolutePath());
        String badContents = FileUtils.readTextFile((File)bad, (Charset)Charset.defaultCharset());
        Assert.assertEquals((String)badContents, (long)3L, (long)ImportToolTest.occurencesOf(badContents, "is missing data"));
    }

    @Test
    public void shouldKeepStoreFilesAfterFailedImport() throws Exception {
        List<String> nodeIds = this.nodeIds();
        Configuration config = Configuration.TABS;
        int extraColumns = 3;
        String storeDir = this.dbRule.getStoreDirAbsolutePath();
        try {
            ImportToolTest.importTool("--into", storeDir, "--nodes", this.nodeHeader(config).getAbsolutePath() + "," + this.nodeData(false, config, nodeIds, TRUE, Charset.defaultCharset(), extraColumns).getAbsolutePath());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InputException e) {
            for (StoreType storeType : StoreType.values()) {
                if (!storeType.isRecordStore()) continue;
                Assert.assertTrue((boolean)new File(storeDir, "neostore" + storeType.getStoreName()).exists());
            }
            List errorLines = this.suppressOutput.getErrorVoice().lines();
            this.assertContains(errorLines, "Starting a database on these store files will likely fail or observe inconsistent records");
        }
    }

    private void assertContains(List<String> errorLines, String string) {
        for (String line : errorLines) {
            if (!line.contains(string)) continue;
            return;
        }
        Assert.fail((String)("Expected error lines " + ArrayUtil.join((Object[])errorLines.toArray(new String[errorLines.size()]), (String)String.format("%n", new Object[0])) + " to have at least one line containing the string '" + string + "'"));
    }

    private static int occurencesOf(String text, String lookFor) {
        int index = -1;
        int count = -1;
        do {
            ++count;
        } while ((index = text.indexOf(lookFor, index + 1)) != -1);
        return count;
    }

    private File writeArrayCsv(String[] headers, String[] values) throws FileNotFoundException {
        File data = this.file(this.fileName("whitespace.csv"));
        try (PrintStream writer = new PrintStream(data);){
            writer.print(":LABEL");
            for (String header : headers) {
                writer.print("," + header);
            }
            writer.println();
            writer.print("PERSON");
            for (String ignored : headers) {
                boolean comma = true;
                for (String value : values) {
                    if (comma) {
                        writer.print(",");
                        comma = false;
                    } else {
                        writer.print(";");
                    }
                    writer.print(value);
                }
            }
            writer.println();
        }
        return data;
    }

    private String joinStringArray(String[] values) {
        return Arrays.stream(values).map(String::trim).collect(Collectors.joining(", ", "[", "]"));
    }

    private File data(String ... lines) throws Exception {
        File file = this.file(this.fileName("data.csv"));
        try (PrintStream writer = this.writer(file, Charset.defaultCharset());){
            for (String line : lines) {
                writer.println(line);
            }
        }
        return file;
    }

    private Predicate<Node> nodeFilter(String id) {
        return node -> node.getProperty("id", (Object)"").equals(id);
    }

    private void assertNodeHasLabels(Node node, String[] names) {
        for (String name : names) {
            Assert.assertTrue((String)(node + " didn't have label " + name + ", it had labels " + node.getLabels()), (boolean)node.hasLabel(Label.label((String)name)));
        }
    }

    private void verifyData() {
        this.verifyData((Validator<Node>)Validators.emptyValidator(), (Validator<Relationship>)Validators.emptyValidator());
    }

    private void verifyData(Validator<Node> nodeAdditionalValidation, Validator<Relationship> relationshipAdditionalValidation) {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            int nodeCount = 0;
            int relationshipCount = 0;
            for (Node node : db.getAllNodes()) {
                Assert.assertTrue((boolean)node.hasProperty("name"));
                nodeAdditionalValidation.validate((Object)node);
                ++nodeCount;
            }
            Assert.assertEquals((long)100L, (long)nodeCount);
            for (Relationship relationship : db.getAllRelationships()) {
                Assert.assertTrue((boolean)relationship.hasProperty("created"));
                relationshipAdditionalValidation.validate((Object)relationship);
                ++relationshipCount;
            }
            Assert.assertEquals((long)10000L, (long)relationshipCount);
            tx.success();
        }
    }

    private void verifyRelationships(List<RelationshipDataLine> relationships) {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        Map<String, Node> nodesById = this.allNodesById((GraphDatabaseService)db);
        try (Transaction tx = db.beginTx();){
            for (RelationshipDataLine relationship : relationships) {
                Node startNode = nodesById.get(relationship.startNodeId);
                Node endNode = nodesById.get(relationship.endNodeId);
                if (startNode == null || endNode == null) continue;
                Assert.assertNotNull((String)relationship.toString(), (Object)this.findRelationship(startNode, endNode, relationship));
            }
            tx.success();
        }
    }

    private Relationship findRelationship(Node startNode, Node endNode, RelationshipDataLine relationship) {
        return (Relationship)Iterators.singleOrNull((Iterator)Iterators.filter(item -> item.getEndNode().equals(endNode) && item.getProperty("name").equals(relationship.name), startNode.getRelationships(new RelationshipType[]{RelationshipType.withName((String)relationship.type)}).iterator()));
    }

    private Map<String, Node> allNodesById(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            HashMap<String, Node> nodes = new HashMap<String, Node>();
            for (Node node : db.getAllNodes()) {
                nodes.put(this.idOf(node), node);
            }
            tx.success();
            Object object = nodes;
            return object;
        }
    }

    private String idOf(Node node) {
        return (String)node.getProperty("id");
    }

    private List<String> nodeIds() {
        return this.nodeIds(100);
    }

    private List<String> nodeIds(int count) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            ids.add(this.randomNodeId());
        }
        return ids;
    }

    private String randomNodeId() {
        return UUID.randomUUID().toString();
    }

    private File nodeData(boolean includeHeader, Configuration config, List<String> nodeIds, IntPredicate linePredicate) throws Exception {
        return this.nodeData(includeHeader, config, nodeIds, linePredicate, Charset.defaultCharset());
    }

    private File nodeData(boolean includeHeader, Configuration config, List<String> nodeIds, IntPredicate linePredicate, Charset encoding) throws Exception {
        return this.nodeData(includeHeader, config, nodeIds, linePredicate, encoding, 0);
    }

    private File nodeData(boolean includeHeader, Configuration config, List<String> nodeIds, IntPredicate linePredicate, Charset encoding, int extraColumns) throws Exception {
        File file = this.file(this.fileName("nodes.csv"));
        try (PrintStream writer = this.writer(file, encoding);){
            if (includeHeader) {
                this.writeNodeHeader(writer, config, null);
            }
            this.writeNodeData(writer, config, nodeIds, linePredicate, extraColumns);
        }
        return file;
    }

    private PrintStream writer(File file, Charset encoding) throws Exception {
        return new PrintStream(file, encoding.name());
    }

    private File nodeHeader(Configuration config) throws Exception {
        return this.nodeHeader(config, null);
    }

    private File nodeHeader(Configuration config, String idGroup) throws Exception {
        return this.nodeHeader(config, idGroup, Charset.defaultCharset());
    }

    private File nodeHeader(Configuration config, String idGroup, Charset encoding) throws Exception {
        File file = this.file(this.fileName("nodes-header.csv"));
        try (PrintStream writer = this.writer(file, encoding);){
            this.writeNodeHeader(writer, config, idGroup);
        }
        return file;
    }

    private void writeNodeHeader(PrintStream writer, Configuration config, String idGroup) {
        char delimiter = config.delimiter();
        writer.println(this.idEntry("id", Type.ID, idGroup) + delimiter + "name" + delimiter + "labels:LABEL");
    }

    private String idEntry(String name, Type type, String idGroup) {
        return (name != null ? name : "") + ":" + type.name() + (idGroup != null ? "(" + idGroup + ")" : "");
    }

    private void writeNodeData(PrintStream writer, Configuration config, List<String> nodeIds, IntPredicate linePredicate, int extraColumns) {
        char delimiter = config.delimiter();
        char arrayDelimiter = config.arrayDelimiter();
        for (int i = 0; i < nodeIds.size(); ++i) {
            if (!linePredicate.test(i)) continue;
            writer.println(this.getLine(nodeIds.get(i), delimiter, arrayDelimiter, extraColumns));
        }
    }

    private String getLine(String nodeId, char delimiter, char arrayDelimiter, int extraColumns) {
        StringBuilder stringBuilder = new StringBuilder().append(nodeId).append(delimiter).append(this.randomName()).append(delimiter).append(this.randomLabels(arrayDelimiter));
        for (int i = 0; i < extraColumns; ++i) {
            stringBuilder.append(delimiter).append("ExtraColumn").append(i);
        }
        return stringBuilder.toString();
    }

    private String randomLabels(char arrayDelimiter) {
        int length = this.random.nextInt(3);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(arrayDelimiter);
            }
            builder.append(this.labelName(this.random.nextInt(4)));
        }
        return builder.toString();
    }

    private String labelName(int number) {
        return "LABEL_" + number;
    }

    private String randomName() {
        int length = this.random.nextInt(10) + 5;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)(97 + this.random.nextInt(20)));
        }
        return builder.toString();
    }

    private File relationshipData(boolean includeHeader, Configuration config, List<String> nodeIds, IntPredicate linePredicate, boolean specifyType) throws Exception {
        return this.relationshipData(includeHeader, config, nodeIds, linePredicate, specifyType, Charset.defaultCharset());
    }

    private File relationshipData(boolean includeHeader, Configuration config, List<String> nodeIds, IntPredicate linePredicate, boolean specifyType, Charset encoding) throws Exception {
        return this.relationshipData(includeHeader, config, this.randomRelationships(nodeIds), linePredicate, specifyType, encoding);
    }

    private File relationshipData(boolean includeHeader, Configuration config, Iterator<RelationshipDataLine> data, IntPredicate linePredicate, boolean specifyType) throws Exception {
        return this.relationshipData(includeHeader, config, data, linePredicate, specifyType, Charset.defaultCharset());
    }

    private File relationshipData(boolean includeHeader, Configuration config, Iterator<RelationshipDataLine> data, IntPredicate linePredicate, boolean specifyType, Charset encoding) throws Exception {
        File file = this.file(this.fileName("relationships.csv"));
        try (PrintStream writer = this.writer(file, encoding);){
            if (includeHeader) {
                this.writeRelationshipHeader(writer, config, null, null, specifyType);
            }
            this.writeRelationshipData(writer, config, data, linePredicate, specifyType);
        }
        return file;
    }

    private File relationshipHeader(Configuration config) throws Exception {
        return this.relationshipHeader(config, Charset.defaultCharset());
    }

    private File relationshipHeader(Configuration config, Charset encoding) throws Exception {
        return this.relationshipHeader(config, null, null, true, encoding);
    }

    private File relationshipHeader(Configuration config, String startIdGroup, String endIdGroup, boolean specifyType) throws Exception {
        return this.relationshipHeader(config, startIdGroup, endIdGroup, specifyType, Charset.defaultCharset());
    }

    private File relationshipHeader(Configuration config, String startIdGroup, String endIdGroup, boolean specifyType, Charset encoding) throws Exception {
        File file = this.file(this.fileName("relationships-header.csv"));
        try (PrintStream writer = this.writer(file, encoding);){
            this.writeRelationshipHeader(writer, config, startIdGroup, endIdGroup, specifyType);
        }
        return file;
    }

    private String fileName(String name) {
        return this.dataIndex++ + "-" + name;
    }

    private File file(String localname) {
        return new File(this.dbRule.getStoreDir(), localname);
    }

    private File badFile() {
        return new File(this.dbRule.getStoreDirFile(), "bad.log");
    }

    private void writeRelationshipHeader(PrintStream writer, Configuration config, String startIdGroup, String endIdGroup, boolean specifyType) {
        char delimiter = config.delimiter();
        writer.println(this.idEntry(null, Type.START_ID, startIdGroup) + delimiter + this.idEntry(null, Type.END_ID, endIdGroup) + (specifyType ? delimiter + ":" + Type.TYPE : "") + delimiter + "created:long" + delimiter + "name:String");
    }

    private static RelationshipDataLine relationship(String startNodeId, String endNodeId, String type) {
        return ImportToolTest.relationship(startNodeId, endNodeId, type, null);
    }

    private static RelationshipDataLine relationship(String startNodeId, String endNodeId, String type, String name) {
        return new RelationshipDataLine(startNodeId, endNodeId, type, name);
    }

    private void writeRelationshipData(PrintStream writer, Configuration config, Iterator<RelationshipDataLine> data, IntPredicate linePredicate, boolean specifyType) {
        char delimiter = config.delimiter();
        for (int i = 0; i < 10000 && data.hasNext(); ++i) {
            RelationshipDataLine entry = data.next();
            if (!linePredicate.test(i)) continue;
            writer.println(ImportToolTest.nullSafeString(entry.startNodeId) + delimiter + ImportToolTest.nullSafeString(entry.endNodeId) + (specifyType ? delimiter + ImportToolTest.nullSafeString(entry.type) : "") + delimiter + System.currentTimeMillis() + delimiter + (entry.name != null ? entry.name : ""));
        }
    }

    private static String nullSafeString(String endNodeId) {
        return endNodeId != null ? endNodeId : "";
    }

    private Iterator<RelationshipDataLine> randomRelationships(final List<String> nodeIds) {
        return new PrefetchingIterator<RelationshipDataLine>(){

            protected RelationshipDataLine fetchNextOrNull() {
                return new RelationshipDataLine((String)nodeIds.get(ImportToolTest.this.random.nextInt(nodeIds.size())), (String)nodeIds.get(ImportToolTest.this.random.nextInt(nodeIds.size())), ImportToolTest.this.randomType(), null);
            }
        };
    }

    static void assertExceptionContains(Exception e, String message, Class<? extends Exception> type) throws Exception {
        if (!Exceptions.contains((Throwable)e, (String)message, (Class[])new Class[]{type})) {
            throw (Exception)Exceptions.withMessage((Throwable)e, (String)String.format("Expected exception to contain cause '%s', %s. but was %s", message, type, e));
        }
    }

    private String randomType() {
        return "TYPE_" + this.random.nextInt(4);
    }

    private IntPredicate lines(int startingAt, int endingAt) {
        return line -> line >= startingAt && line < endingAt;
    }

    static void importTool(String ... arguments) throws IOException {
        ImportTool.main((String[])arguments, (boolean)true);
    }

    private /* synthetic */ void lambda$shouldImportMultipleInputsWithAddedLabelsAndDefaultRelationshipType$1(String[] firstLabels, String[] secondLabels, Node node) {
        if (node.getId() < 50L) {
            this.assertNodeHasLabels(node, firstLabels);
        } else {
            this.assertNodeHasLabels(node, secondLabels);
        }
    }

    private static class RelationshipDataLine {
        private final String startNodeId;
        private final String endNodeId;
        private final String type;
        private final String name;

        RelationshipDataLine(String startNodeId, String endNodeId, String type, String name) {
            this.startNodeId = startNodeId;
            this.endNodeId = endNodeId;
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return "RelationshipDataLine [startNodeId=" + this.startNodeId + ", endNodeId=" + this.endNodeId + ", type=" + this.type + ", name=" + this.name + "]";
        }
    }
}

